/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.uictrls.ext;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.css.property.CCSSProperties;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.HCEdit;
import com.helger.html.hc.html.forms.HCEditPassword;
import com.helger.html.hc.html.forms.HCHiddenField;
import com.helger.html.hc.html.root.HCHtml;
import com.helger.html.hc.html.sections.HCBody;
import com.helger.html.hc.html.textlevel.HCSpan;
import com.helger.photon.bootstrap4.alert.BootstrapErrorBox;
import com.helger.photon.bootstrap4.button.BootstrapSubmitButton;
import com.helger.photon.bootstrap4.form.BootstrapForm;
import com.helger.photon.bootstrap4.form.BootstrapFormGroup;
import com.helger.photon.bootstrap4.layout.BootstrapContainer;
import com.helger.photon.bootstrap4.utils.BootstrapPageHeader;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.execcontext.ISimpleWebExecutionContext;
import com.helger.photon.uicore.login.AbstractLoginHTMLProvider;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class BootstrapLoginHTMLProvider
extends AbstractLoginHTMLProvider {
    public static final boolean DEFAULT_SHOW_LOGIN_ERROR_DETAILS = false;
    private final IHCNode m_aPageTitle;
    private boolean m_bShowLoginErrorDetails = false;

    public BootstrapLoginHTMLProvider(boolean bl, @Nonnull ICredentialValidationResult iCredentialValidationResult, @Nullable IHCNode iHCNode) {
        super(bl, iCredentialValidationResult);
        this.m_aPageTitle = iHCNode;
    }

    public final boolean isShowLoginErrorDetails() {
        return this.m_bShowLoginErrorDetails;
    }

    public final void setShowLoginErrorDetails(boolean bl) {
        this.m_bShowLoginErrorDetails = bl;
    }

    @Nullable
    @OverrideOnDemand
    protected String getTextFieldUserName(@Nonnull Locale locale) {
        return EPhotonCoreText.EMAIL_ADDRESS.getDisplayText(locale);
    }

    @Nullable
    @OverrideOnDemand
    protected String getTextErrorMessage(@Nonnull Locale locale, @Nonnull ICredentialValidationResult iCredentialValidationResult) {
        Object object = EPhotonCoreText.LOGIN_ERROR_MSG.getDisplayText(locale);
        if (this.m_bShowLoginErrorDetails) {
            object = (String)object + " " + iCredentialValidationResult.getDisplayText(locale);
        }
        return object;
    }

    @OverrideOnDemand
    protected void onBeforeForm(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull BootstrapForm bootstrapForm) {
    }

    @OverrideOnDemand
    protected void onAfterForm(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull BootstrapForm bootstrapForm) {
    }

    @Nullable
    @OverrideOnDemand
    protected IHCNode createPageHeader(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nullable IHCNode iHCNode) {
        return BootstrapPageHeader.createOnDemand((IHCNode)iHCNode);
    }

    @Nullable
    protected IHCNode createFormFooter(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext) {
        return null;
    }

    @OverrideOnDemand
    protected void onBeforeLoginContainer(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull HCSpan hCSpan) {
    }

    @OverrideOnDemand
    protected void onAfterLoginContainer(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull HCSpan hCSpan) {
    }

    @OverridingMethodsMustInvokeSuper
    protected void fillBody(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull HCHtml hCHtml) {
        IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse = iSimpleWebExecutionContext.getRequestScope();
        Locale locale = iSimpleWebExecutionContext.getDisplayLocale();
        BootstrapForm bootstrapForm = (BootstrapForm)new BootstrapForm(iSimpleWebExecutionContext).setAction((ISimpleURL)new SimpleURL(iRequestWebScopeWithoutResponse.getURIDecoded()));
        this.onBeforeForm(iSimpleWebExecutionContext, bootstrapForm);
        bootstrapForm.addChild((IHCNode)new HCHiddenField("login-action", "validate-login-credentials"));
        bootstrapForm.addChild((IHCNode)this.getCSRFHandler().createCSRFNonceField());
        if (this.isLoginError()) {
            bootstrapForm.addChild((IHCNode)new BootstrapErrorBox().addChild(this.getTextErrorMessage(locale, this.getLoginResult())));
        }
        String string = this.getTextFieldUserName(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string).setCtrl((IHCNode)((HCEdit)new HCEdit("userid").setPlaceholder(string)).setAutoFocus(true)));
        String string2 = this.getTextFieldPassword(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string2).setCtrl((IHCNode)new HCEditPassword("password").setPlaceholder(string2)));
        bootstrapForm.addChild((IHCNode)new BootstrapSubmitButton().addChild(this.getLoginButtonText(locale)));
        this.onAfterForm(iSimpleWebExecutionContext, bootstrapForm);
        HCSpan hCSpan = (HCSpan)new HCSpan().setID("login");
        hCSpan.addStyle(CCSSProperties.MIN_HEIGHT.newValue("100%"));
        hCSpan.addStyle(CCSSProperties.MIN_HEIGHT.newValue("100vh"));
        hCSpan.addStyle(CCSSProperties.DISPLAY.newValue("flex"));
        hCSpan.addStyle(CCSSProperties.ALIGN_ITEMS.newValue("center"));
        this.onBeforeLoginContainer(iSimpleWebExecutionContext, hCSpan);
        BootstrapContainer bootstrapContainer = new BootstrapContainer();
        bootstrapContainer.addChild(this.createPageHeader(iSimpleWebExecutionContext, this.m_aPageTitle));
        bootstrapContainer.addChild((IHCNode)bootstrapForm);
        bootstrapContainer.addChild(this.createFormFooter(iSimpleWebExecutionContext));
        hCSpan.addChild((IHCNode)bootstrapContainer);
        this.onAfterLoginContainer(iSimpleWebExecutionContext, hCSpan);
        HCBody hCBody = hCHtml.body();
        hCBody.addChild((IHCNode)hCSpan);
    }

    @OverridingMethodsMustInvokeSuper
    protected void fillHead(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull HCHtml hCHtml) {
        super.fillHead(iSimpleWebExecutionContext, hCHtml);
        if (this.m_aPageTitle != null) {
            hCHtml.head().setPageTitle(this.m_aPageTitle.getPlainText());
        }
    }
}

