/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.utils;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.HCEdit;
import com.helger.html.hc.html.forms.HCHiddenField;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.request.IHCRequestField;
import com.helger.network.port.ENetworkPortStatus;
import com.helger.network.port.NetworkPortHelper;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.button.BootstrapButton;
import com.helger.photon.bootstrap4.button.BootstrapSubmitButton;
import com.helger.photon.bootstrap4.card.BootstrapCard;
import com.helger.photon.bootstrap4.card.BootstrapCardBody;
import com.helger.photon.bootstrap4.form.BootstrapForm;
import com.helger.photon.bootstrap4.form.BootstrapFormGroup;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.core.form.RequestField;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class BasePageUtilsPortChecker<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    private static final String FIELD_HOST = "host";
    private static final String FIELD_PORT = "port";

    public BasePageUtilsPortChecker(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_UTILS_PORT_CHECKER.getAsMLT());
    }

    public BasePageUtilsPortChecker(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageUtilsPortChecker(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageUtilsPortChecker(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    public void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        String string;
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        hCNodeList.addChild((IHCNode)this.info(EText.MSG_NOTE.getDisplayText(locale)));
        FormErrorList formErrorList = new FormErrorList();
        if ("perform".equals(WPECTYPE.params().getAsString((Object)"action"))) {
            string = WPECTYPE.params().getAsStringTrimmed(FIELD_HOST);
            String string2 = WPECTYPE.params().getAsStringTrimmed(FIELD_PORT);
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            if (string2 != null) {
                for (Object object : RegExHelper.getSplitToArray((CharSequence)string2, (String)"\\s+")) {
                    int n = StringParser.parseInt((String)object, (int)-1);
                    if (n <= 0) continue;
                    commonsArrayList.add((Object)n);
                }
            }
            if (StringHelper.isEmpty((String)string)) {
                formErrorList.addFieldError(FIELD_HOST, EText.MSG_ERROR_HOSTNAME_MISSING.getDisplayText(locale));
            }
            if (commonsArrayList.isEmpty()) {
                formErrorList.addFieldError(FIELD_PORT, EText.MSG_ERROR_PORT_MISSING.getDisplayText(locale));
            }
            if (formErrorList.isEmpty()) {
                BootstrapCard bootstrapCard = new BootstrapCard();
                bootstrapCard.createAndAddHeader().addChild(EText.MSG_RESULT_HEADER.getDisplayText(locale));
                BootstrapCardBody bootstrapCardBody = bootstrapCard.createAndAddBody();
                for (Object object : commonsArrayList) {
                    ENetworkPortStatus eNetworkPortStatus = NetworkPortHelper.checkPortOpen((String)string, (int)((Integer)object), (int)3000);
                    bootstrapCardBody.addChild((IHCNode)((HCDiv)((HCDiv)((HCDiv)this.div().addChild(EText.MSG_RESULT_STATUS_PREFIX.getDisplayText(locale))).addChild((IHCNode)this.code(string + ":" + (Integer)object))).addChild(" = ")).addChild((IHCNode)(eNetworkPortStatus.isPortOpen() ? this.badgeSuccess(eNetworkPortStatus.toString()) : this.badgeDanger(eNetworkPortStatus.toString()))));
                }
                hCNodeList.addChild((IHCNode)bootstrapCard.addClass(CBootstrapCSS.MB_2));
            }
        }
        string = (BootstrapForm)hCNodeList.addAndReturnChild((IHCNode)((BootstrapForm)this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE)));
        string.addChild((IHCNode)new HCHiddenField("action", "perform"));
        string.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_HOSTNAME.getDisplayText(locale)).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(FIELD_HOST))).setHelpText(EText.MSG_HOSTNAME_HELPTEXT.getDisplayText(locale)).setErrorList(formErrorList.getListOfField(FIELD_HOST)));
        string.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_PORTS.getDisplayText(locale)).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(FIELD_PORT))).setHelpText(EText.MSG_PORTS_HELPTEXT.getDisplayText(locale)).setErrorList(formErrorList.getListOfField(FIELD_PORT)));
        string.addChild((IHCNode)((BootstrapButton)new BootstrapSubmitButton().addChild(EText.MSG_BUTTON_CHECK.getDisplayText(locale))).setIcon((IIcon)EDefaultIcon.YES));
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_NOTE("Hinweis: es k\u00f6nnen nur TCP-Ports gepr\u00fcft werden.", "Note: only TCP ports can be checked."),
        MSG_HOSTNAME("Hostname", "Hostname"),
        MSG_HOSTNAME_HELPTEXT("Es kann ein Hostname oder eine IP-Adresse angegeben werden.", "A hostname or an IP address can be provided"),
        MSG_PORTS("Port Nummer(n)", "Port(s)"),
        MSG_PORTS_HELPTEXT("Mehrere Port-Nummern k\u00f6nnen durch Leerzeichen getrennt angegeben werden.", "Multiple port numbers can be provided, separated by space characters."),
        MSG_BUTTON_CHECK("Pr\u00fcfe Ports", "Check ports"),
        MSG_ERROR_HOSTNAME_MISSING("Es muss ein Hostname angegeben werden.", "The hostname to check is mandatory."),
        MSG_ERROR_PORT_MISSING("Es muss mindestens eine Port-Nummer angegeben werden.", "At least one port number must be provided."),
        MSG_RESULT_HEADER("\u00dcberpr\u00fcfungsergebnisse", "Port check results"),
        MSG_RESULT_STATUS_PREFIX("Status von ", "Status for ");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

