/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.utils;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.compare.ESortOrder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.base.name.IHasDisplayName;
import com.helger.base.state.EChange;
import com.helger.base.string.StringCount;
import com.helger.base.string.StringHelper;
import com.helger.base.timing.StopWatch;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.HCEdit;
import com.helger.html.hc.html.forms.HCHiddenField;
import com.helger.html.hc.html.forms.HCTextArea;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.html.request.IHCRequestField;
import com.helger.http.EHttpMethod;
import com.helger.http.header.HttpHeaderMap;
import com.helger.httpclient.HttpClientHelper;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.HttpClientSettings;
import com.helger.httpclient.response.ResponseHandlerHttpEntity;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.button.BootstrapSubmitButton;
import com.helger.photon.bootstrap4.form.BootstrapForm;
import com.helger.photon.bootstrap4.form.BootstrapFormGroup;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.bootstrap4.uictrls.ext.BootstrapTechnicalUI;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.core.form.RequestField;
import com.helger.photon.uicore.html.select.HCExtSelect;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.DataTablesLengthMenu;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.text.IMultilingualText;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.StatusLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePageUtilsHttpClient<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePageUtilsHttpClient.class);
    private static final String FIELD_CONFIG = "config";
    private static final String FIELD_HTTP_METHOD = "http_method";
    private static final String FIELD_URI = "uri";

    public BasePageUtilsHttpClient(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_UTILS_HTTP_CLIENT.getAsMLT());
    }

    public BasePageUtilsHttpClient(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageUtilsHttpClient(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageUtilsHttpClient(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    /*
     * WARNING - void declaration
     */
    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        IHttpClientConfig iHttpClientConfig;
        String string;
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        hCNodeList.addChild((IHCNode)this.info("This page allows to perform arbitrary http(s) queries to test network connectivity problems."));
        FormErrorList formErrorList = new FormErrorList();
        if (WPECTYPE.hasAction("perform")) {
            string = WPECTYPE.params().getAsStringTrimmed(FIELD_CONFIG);
            iHttpClientConfig = HttpClientConfigRegistry.getFromID(string);
            EHttpMethod[] eHttpMethodArray = WPECTYPE.params().getAsStringTrimmed(FIELD_HTTP_METHOD);
            EHttpMethod object = EHttpMethod.getFromNameOrNull((String)eHttpMethodArray);
            String string2 = WPECTYPE.params().getAsStringTrimmed(FIELD_URI);
            if (StringHelper.isEmpty((String)string)) {
                formErrorList.addFieldError(FIELD_CONFIG, "A configuration must be selected.");
            } else if (iHttpClientConfig == null) {
                formErrorList.addFieldError(FIELD_CONFIG, "Please select a valid configuration.");
            }
            if (StringHelper.isEmpty((String)eHttpMethodArray)) {
                formErrorList.addFieldError(FIELD_HTTP_METHOD, "A HTTP method must be selected.");
            } else if (object == null) {
                formErrorList.addFieldError(FIELD_HTTP_METHOD, "Please select a valid HTTP method.");
            }
            if (StringHelper.isEmpty((String)string2)) {
                formErrorList.addFieldError(FIELD_URI, "A URI must be provided.");
            } else if (!string2.startsWith("http://") && !string2.startsWith("https://")) {
                formErrorList.addFieldError(FIELD_URI, "The URI must start with 'http://' or 'https://'");
            }
            if (formErrorList.isEmpty()) {
                void var10_24;
                HttpUriRequestBase httpUriRequestBase;
                HttpClientManager httpClientManager;
                boolean bl = false;
                LOGGER.info("http client " + object.getName() + " query '" + string2 + "' using configuration '" + (String)iHttpClientConfig.getID() + "'");
                StopWatch stopWatch = StopWatch.createdStarted();
                HttpClientSettings httpClientSettings = iHttpClientConfig.getHttpClientSettings(string2);
                DebugResponseHandler debugResponseHandler = new DebugResponseHandler(StandardCharsets.UTF_8);
                try {
                    httpClientManager = HttpClientManager.create((HttpClientSettings)httpClientSettings);
                    try {
                        httpUriRequestBase = HttpClientHelper.createRequest((EHttpMethod)object, (ISimpleURL)new SimpleURL(string2));
                        String string3 = (String)httpClientManager.execute((HttpUriRequest)httpUriRequestBase, (HttpClientResponseHandler)debugResponseHandler);
                        bl = true;
                        LOGGER.info("http client " + object.getName() + " query succeeded");
                    }
                    finally {
                        if (httpClientManager != null) {
                            httpClientManager.close();
                        }
                    }
                }
                catch (IOException iOException) {
                    String string4 = BootstrapTechnicalUI.getTechnicalDetailsString((Throwable)iOException, (Locale)locale);
                    LOGGER.warn("http client " + object.getName() + " query failed with " + iOException.getClass().getName() + " - " + iOException.getMessage());
                }
                stopWatch.stop();
                hCNodeList.addChild((IHCNode)((HCDiv)((HCDiv)((HCDiv)((HCDiv)this.div("Output of querying ").addChild((IHCNode)this.code(string2))).addChild(" using ")).addChild((IHCNode)this.em(iHttpClientConfig.getDisplayName()))).addChild(": ")).addChild((IHCNode)(bl ? this.badgeSuccess("success") : this.badgeDanger("error"))));
                hCNodeList.addChild((IHCNode)this.div("Querying took " + stopWatch.getMillis() + " milliseconds"));
                if (debugResponseHandler.m_aUsedStatusLine != null) {
                    hCNodeList.addChild((IHCNode)this.div("Response protocol version: ").addChild((IHCNode)this.code(String.valueOf(debugResponseHandler.m_aUsedStatusLine.getProtocolVersion()))));
                    hCNodeList.addChild((IHCNode)this.div("Response status code: ").addChild((IHCNode)this.code(Integer.toString(debugResponseHandler.m_aUsedStatusLine.getStatusCode()))));
                    hCNodeList.addChild((IHCNode)this.div("Response reason phrase: ").addChild((IHCNode)this.code(debugResponseHandler.m_aUsedStatusLine.getReasonPhrase())));
                }
                if (debugResponseHandler.m_aUsedCharset != null) {
                    hCNodeList.addChild((IHCNode)this.div("Response charset used: ").addChild((IHCNode)this.code(debugResponseHandler.m_aUsedCharset.name())));
                }
                if (debugResponseHandler.m_aUsedHeaders.isNotEmpty()) {
                    hCNodeList.addChild((IHCNode)this.div("Response HTTP headers:"));
                    httpClientManager = (HCTable)new HCTable(new IHCCol[]{new DTCol("Name").setInitialSorting(ESortOrder.ASCENDING), new DTCol("Value")}).setID("httpresponseheaders");
                    debugResponseHandler.m_aUsedHeaders.forEachSingleHeader((arg_0, arg_1) -> BasePageUtilsHttpClient.lambda$fillContent$0((HCTable)httpClientManager, arg_0, arg_1), false);
                    httpUriRequestBase = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)httpClientManager);
                    httpUriRequestBase.setLengthMenu(DataTablesLengthMenu.INSTANCE_ALL);
                    httpUriRequestBase.setPaging(false);
                    httpUriRequestBase.setInfo(false);
                    ((HCNodeList)hCNodeList.addChild((IHCNode)httpClientManager)).addChild((IHCNode)httpUriRequestBase);
                }
                hCNodeList.addChild((IHCNode)((HCTextArea)((HCTextArea)((HCTextArea)((HCTextArea)new HCTextArea("responsepayload").setRows(Math.min(10, 1 + StringCount.getCharCount((String)var10_24, (char)'\n')))).setValue((String)var10_24)).addClass(CBootstrapCSS.FORM_CONTROL)).addClass(CBootstrapCSS.TEXT_MONOSPACE)).addClass(CBootstrapCSS.MB_2));
            }
        }
        string = (BootstrapForm)hCNodeList.addAndReturnChild((IHCNode)new BootstrapForm(WPECTYPE));
        string.setLeft(2);
        iHttpClientConfig = new HCExtSelect((IHCRequestField)new RequestField(FIELD_CONFIG, "systemdefault"));
        iHttpClientConfig.addOptionPleaseSelect(locale);
        for (IHttpClientConfig iHttpClientConfig2 : HttpClientConfigRegistry.iterate()) {
            iHttpClientConfig.addOption((String)iHttpClientConfig2.getID(), iHttpClientConfig2.getDisplayName());
        }
        string.addFormGroup(new BootstrapFormGroup().setLabelMandatory("Configuration to use").setCtrl((IHCNode)iHttpClientConfig).setErrorList(formErrorList.getListOfField(FIELD_CONFIG)));
        iHttpClientConfig = new HCExtSelect((IHCRequestField)new RequestField(FIELD_HTTP_METHOD, EHttpMethod.GET.getName()));
        iHttpClientConfig.addOptionPleaseSelect(locale);
        for (EHttpMethod eHttpMethod : EHttpMethod.values()) {
            if (eHttpMethod == EHttpMethod.CONNECT) continue;
            iHttpClientConfig.addOption(eHttpMethod.getName());
        }
        string.addFormGroup(new BootstrapFormGroup().setLabelMandatory("HTTP method").setCtrl((IHCNode)iHttpClientConfig).setErrorList(formErrorList.getListOfField(FIELD_HTTP_METHOD)));
        string.addFormGroup(new BootstrapFormGroup().setLabelMandatory("URI to query").setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(FIELD_URI))).setHelpText(new IHCNode[]{new HCTextNode("The URI to query. Must start with "), this.code("http://"), new HCTextNode(" or "), this.code("https://"), new HCTextNode(".")}).setErrorList(formErrorList.getListOfField(FIELD_URI)));
        string.addChild((IHCNode)new HCHiddenField("action", "perform"));
        string.addChild((IHCNode)new BootstrapSubmitButton().addChild("Query now"));
    }

    private static /* synthetic */ void lambda$fillContent$0(HCTable hCTable, String string, String string2) {
        hCTable.addBodyRow().addCells(new String[]{string, string2});
    }

    @NotThreadSafe
    public static class HttpClientConfigRegistry {
        public static final String DEFAULT_CONFIG_ID = "systemdefault";
        private static final ICommonsMap<String, IHttpClientConfig> s_aMap = new CommonsHashMap();

        private HttpClientConfigRegistry() {
        }

        public static void register(@Nonnull IHttpClientConfig iHttpClientConfig) {
            ValueEnforcer.notNull((Object)iHttpClientConfig, (String)"HCC");
            String string = (String)iHttpClientConfig.getID();
            if (s_aMap.containsKey((Object)string)) {
                throw new IllegalArgumentException("Another configuration with ID '" + string + "' is already registered");
            }
            s_aMap.put((Object)string, (Object)iHttpClientConfig);
        }

        @Nonnull
        public static EChange unregister(@Nullable String string) {
            if (StringHelper.isEmpty((String)string)) {
                return EChange.UNCHANGED;
            }
            return s_aMap.removeObject((Object)string);
        }

        @Nullable
        public static IHttpClientConfig getFromID(@Nullable String string) {
            if (StringHelper.isEmpty((String)string)) {
                return null;
            }
            return (IHttpClientConfig)s_aMap.get((Object)string);
        }

        @Nonnull
        public static Iterable<IHttpClientConfig> iterate() {
            return s_aMap.values();
        }

        public static void setToDefault() {
            s_aMap.clear();
            HttpClientConfigRegistry.register(new HttpClientConfig(DEFAULT_CONFIG_ID, "System default settings", string -> new HttpClientSettings()));
        }

        static {
            HttpClientConfigRegistry.setToDefault();
        }
    }

    public static interface IHttpClientConfig
    extends IHasID<String>,
    IHasDisplayName,
    IHttpClientMetaProvider {
    }

    private static final class DebugResponseHandler
    implements HttpClientResponseHandler<String> {
        private final Charset m_aDefaultCharset;
        private StatusLine m_aUsedStatusLine;
        private Charset m_aUsedCharset;
        private final HttpHeaderMap m_aUsedHeaders = new HttpHeaderMap();

        public DebugResponseHandler(@Nonnull Charset charset) {
            this.m_aDefaultCharset = charset;
        }

        @Nullable
        public String handleResponse(@Nonnull ClassicHttpResponse classicHttpResponse) throws IOException {
            HttpEntity httpEntity = ResponseHandlerHttpEntity.INSTANCE.handleResponse(classicHttpResponse);
            if (httpEntity == null) {
                return null;
            }
            ContentType contentType = HttpClientHelper.getContentType((HttpEntity)httpEntity);
            Charset charset = contentType == null ? this.m_aDefaultCharset : HttpClientHelper.getCharset((ContentType)contentType, (Charset)this.m_aDefaultCharset);
            this.m_aUsedStatusLine = new StatusLine((HttpResponse)classicHttpResponse);
            this.m_aUsedCharset = charset;
            this.m_aUsedHeaders.removeAll();
            for (Header header : classicHttpResponse.getHeaders()) {
                this.m_aUsedHeaders.addHeader(header.getName(), header.getValue());
            }
            return HttpClientHelper.entityToString((HttpEntity)httpEntity, (Charset)charset);
        }
    }

    public static class HttpClientConfig
    implements IHttpClientConfig {
        private final String m_sID;
        private final String m_sDisplayName;
        private final IHttpClientMetaProvider m_aHCMP;

        public HttpClientConfig(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull IHttpClientMetaProvider iHttpClientMetaProvider) {
            ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
            ValueEnforcer.notEmpty((CharSequence)string2, (String)"DisplayName");
            ValueEnforcer.notNull((Object)iHttpClientMetaProvider, (String)"HCMP");
            this.m_sID = string;
            this.m_sDisplayName = string2;
            this.m_aHCMP = iHttpClientMetaProvider;
        }

        @Nonnull
        @Nonempty
        public String getID() {
            return this.m_sID;
        }

        @Nonnull
        @Nonempty
        public String getDisplayName() {
            return this.m_sDisplayName;
        }

        @Override
        @Nonnull
        public HttpClientSettings getHttpClientSettings(@Nonnull @Nonempty String string) {
            return this.m_aHCMP.getHttpClientSettings(string);
        }
    }

    public static interface IHttpClientMetaProvider {
        @Nonnull
        public HttpClientSettings getHttpClientSettings(@Nonnull @Nonempty String var1);
    }
}

