/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.utils;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.charset.EUnicodeBOM;
import com.helger.base.codec.base64.Base64;
import com.helger.base.string.StringCount;
import com.helger.base.string.StringHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.HCCheckBox;
import com.helger.html.hc.html.forms.HCHiddenField;
import com.helger.html.hc.html.forms.HCTextArea;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.request.IHCRequestField;
import com.helger.html.request.IHCRequestFieldBoolean;
import com.helger.mime.CMimeType;
import com.helger.photon.ajax.decl.AjaxFunctionDeclaration;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.button.BootstrapButton;
import com.helger.photon.bootstrap4.button.BootstrapSubmitButton;
import com.helger.photon.bootstrap4.form.BootstrapForm;
import com.helger.photon.bootstrap4.form.BootstrapFormGroup;
import com.helger.photon.bootstrap4.form.BootstrapFormHelper;
import com.helger.photon.bootstrap4.nav.BootstrapTabBox;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap4.uictrls.ext.BootstrapFileUpload;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.core.form.RequestField;
import com.helger.photon.core.form.RequestFieldBoolean;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.servlet.response.EContentDispositionType;
import com.helger.text.IMultilingualText;
import com.helger.text.locale.LocaleFormatter;
import com.helger.url.ISimpleURL;
import com.helger.web.fileupload.IFileItem;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.web.scope.singleton.AbstractSessionWebSingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public class BasePageUtilsBase64Encode<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    private static final String PARAM_TAB = "tab";
    private static final String FIELD_FILE = "file";
    private static final String FIELD_TEXT = "text";
    private static final String FIELD_SHOW_AS_STRING = "showasstring";
    private static final boolean DEFAULT_SHOW_AS_STRING = true;
    private static final AjaxFunctionDeclaration AJAX_GET_ENCODED = BasePageUtilsBase64Encode.addAjax((IAjaxExecutor & Serializable)(iRequestWebScopeWithoutResponse, photonUnifiedResponse) -> {
        Encoded encoded = Encoded.getInstance();
        if (encoded.hasData()) {
            photonUnifiedResponse.setContentAndCharset(encoded.m_sData, StandardCharsets.UTF_8);
            photonUnifiedResponse.setMimeType(CMimeType.TEXT_PLAIN);
            photonUnifiedResponse.setContentDispositionType(EContentDispositionType.ATTACHMENT);
            photonUnifiedResponse.setContentDispositionFilename("base64-encoded-file.txt");
            photonUnifiedResponse.disableCaching();
        } else {
            photonUnifiedResponse.createBadRequest();
        }
    });

    public BasePageUtilsBase64Encode(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_UTILS_BASE64_ENCODE.getAsMLT());
    }

    public BasePageUtilsBase64Encode(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageUtilsBase64Encode(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageUtilsBase64Encode(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    public void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        String string;
        IFileItem iFileItem;
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse = WPECTYPE.getRequestScope();
        String string2 = WPECTYPE.params().getAsString((Object)PARAM_TAB);
        boolean bl = StringHelper.isEmpty((String)string2) || FIELD_FILE.equals(string2);
        FormErrorList formErrorList = new FormErrorList();
        if (WPECTYPE.params().hasStringValue((Object)"action", "perform")) {
            iFileItem = WPECTYPE.params().getAsFileItem(FIELD_FILE);
            string = WPECTYPE.params().getAsString((Object)FIELD_TEXT);
            boolean bl2 = WPECTYPE.params().isCheckBoxChecked(FIELD_SHOW_AS_STRING, true);
            byte[] byArray = null;
            if (bl) {
                if (iFileItem == null || StringHelper.isEmpty((String)iFileItem.getName())) {
                    formErrorList.addFieldError(FIELD_FILE, "No file was selected");
                } else {
                    byArray = iFileItem.directGet();
                }
            } else if (StringHelper.isEmpty((String)string)) {
                formErrorList.addFieldError(FIELD_TEXT, "No text to encode was provided");
            } else {
                byArray = string.getBytes(StandardCharsets.UTF_8);
            }
            if (byArray != null) {
                String string3;
                int n = byArray.length;
                EUnicodeBOM eUnicodeBOM = EUnicodeBOM.getFromBytesOrNull((byte[])byArray);
                if (eUnicodeBOM != null) {
                    hCNodeList.addChild((IHCNode)this.warn("The selected file contains a BOM: " + eUnicodeBOM.name()));
                }
                try {
                    string3 = Base64.encodeBytes((byte[])byArray, (int)0, (int)n, (int)8);
                }
                catch (IOException iOException) {
                    string3 = "";
                }
                hCNodeList.addChild((IHCNode)this.success((String)(iFileItem != null ? "File '" + iFileItem.getName() + "'" : "Uploaded text") + " was encoded from " + byArray.length + " bytes to " + string3.length() + " characters (=" + LocaleFormatter.getFormattedPercent((double)((double)string3.length() / (double)byArray.length), (int)2, (Locale)locale) + ")!"));
                if (bl2) {
                    int n2 = StringCount.getLineCount((String)string3);
                    HCTextArea hCTextArea = (HCTextArea)((HCTextArea)((HCTextArea)((HCTextArea)((HCTextArea)new HCTextArea("result").setReadOnly(true)).setRows(Math.max(n2, 5))).setValue(string3)).addClass(CBootstrapCSS.TEXT_MONOSPACE)).addClass(CBootstrapCSS.MB_3);
                    BootstrapFormHelper.markAsFormControl((IHCNode)hCTextArea);
                    hCNodeList.addChild((IHCNode)hCTextArea);
                } else {
                    Encoded.getInstance().setData(string3);
                    hCNodeList.addChild((IHCNode)this.success((IHCNode)this.a((ISimpleURL)AJAX_GET_ENCODED.getInvocationURL(iRequestWebScopeWithoutResponse)).addChild("Download encoded result file")));
                }
            }
        }
        if (formErrorList.isNotEmpty()) {
            hCNodeList.addChild((IHCNode)this.getUIHandler().createIncorrectInputBox((ILayoutExecutionContext)WPECTYPE));
        }
        iFileItem = (BootstrapTabBox)hCNodeList.addAndReturnChild((IHCNode)new BootstrapTabBox());
        string = (BootstrapForm)this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE);
        string.setEncTypeFileUpload();
        string.addChild((IHCNode)new HCHiddenField("action", "perform"));
        string.addChild((IHCNode)new HCHiddenField(PARAM_TAB, FIELD_FILE));
        string.addFormGroup(new BootstrapFormGroup().setLabelMandatory("File to encode").setCtrl((IHCNode)new BootstrapFileUpload(FIELD_FILE, locale).setCustomPlaceholder("No file selected")).setErrorList(formErrorList.getListOfField(FIELD_FILE)));
        string.addFormGroup(new BootstrapFormGroup().setLabel("Show result as String?").setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_SHOW_AS_STRING, true))).setErrorList(formErrorList.getListOfField(FIELD_SHOW_AS_STRING)));
        string.addChild((IHCNode)((BootstrapButton)new BootstrapSubmitButton().addChild("Create Base64 encoded version")).setIcon((IIcon)EDefaultIcon.YES));
        iFileItem.addTab(FIELD_FILE, "Upload file", (IHCNode)string, bl);
        string = (BootstrapForm)this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE);
        string.addChild((IHCNode)new HCHiddenField("action", "perform"));
        string.addChild((IHCNode)new HCHiddenField(PARAM_TAB, FIELD_TEXT));
        string.addFormGroup(new BootstrapFormGroup().setLabelMandatory("Text to encode").setCtrl((IHCNode)((HCTextArea)((HCTextArea)new HCTextArea((IHCRequestField)new RequestField(FIELD_TEXT)).setRows(10)).addClass(CBootstrapCSS.TEXT_MONOSPACE)).setPlaceholder("Text to be Base64 encoded")).setErrorList(formErrorList.getListOfField(FIELD_TEXT)));
        string.addFormGroup(new BootstrapFormGroup().setLabel("Show result as String?").setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_SHOW_AS_STRING, true))).setErrorList(formErrorList.getListOfField(FIELD_SHOW_AS_STRING)));
        string.addChild((IHCNode)((BootstrapButton)new BootstrapSubmitButton().addChild("Create Base64 encoded version")).setIcon((IIcon)EDefaultIcon.YES));
        iFileItem.addTab(FIELD_TEXT, "Edit text to encode", (IHCNode)string, !bl);
    }

    public static class Encoded
    extends AbstractSessionWebSingleton {
        private String m_sData;

        @Deprecated(forRemoval=false)
        @UsedViaReflection
        public Encoded() {
        }

        @Nonnull
        public static Encoded getInstance() {
            return (Encoded)Encoded.getSessionSingleton(Encoded.class);
        }

        public void setData(@Nullable String string) {
            this.m_sData = string;
        }

        public boolean hasData() {
            return this.m_sData != null;
        }
    }
}

