/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.utils;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.charset.CharsetHelper;
import com.helger.base.codec.base64.Base64;
import com.helger.base.string.StringHelper;
import com.helger.css.property.CCSSProperties;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.HCCheckBox;
import com.helger.html.hc.html.forms.HCHiddenField;
import com.helger.html.hc.html.forms.HCTextArea;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.jquery.JQuery;
import com.helger.html.js.EJSEvent;
import com.helger.html.js.IHasJSCode;
import com.helger.html.request.IHCRequestField;
import com.helger.html.request.IHCRequestFieldBoolean;
import com.helger.mime.CMimeType;
import com.helger.mime.IMimeType;
import com.helger.mime.determine.MimeTypeDeterminator;
import com.helger.photon.ajax.decl.AjaxFunctionDeclaration;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.button.BootstrapButton;
import com.helger.photon.bootstrap4.button.BootstrapSubmitButton;
import com.helger.photon.bootstrap4.form.BootstrapForm;
import com.helger.photon.bootstrap4.form.BootstrapFormGroup;
import com.helger.photon.bootstrap4.form.BootstrapFormHelper;
import com.helger.photon.bootstrap4.grid.BootstrapRow;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.core.form.RequestField;
import com.helger.photon.core.form.RequestFieldBoolean;
import com.helger.photon.uicore.html.select.HCCharsetSelect;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.servlet.response.EContentDispositionType;
import com.helger.text.IMultilingualText;
import com.helger.text.locale.LocaleFormatter;
import com.helger.url.ISimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.web.scope.singleton.AbstractSessionWebSingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public class BasePageUtilsBase64Decode<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    private static final String FIELD_CHARSET = "charset";
    private static final String FIELD_DECODE = "decode";
    private static final String FIELD_SHOW_AS_STRING = "showasstring";
    private static final boolean DEFAULT_SHOW_AS_STRING = false;
    private static final AjaxFunctionDeclaration AJAX_GET_DECODED = BasePageUtilsBase64Decode.addAjax((IAjaxExecutor & Serializable)(iRequestWebScopeWithoutResponse, photonUnifiedResponse) -> {
        Decoded decoded = Decoded.getInstance();
        if (decoded.hasData()) {
            photonUnifiedResponse.setContent(decoded.m_aData);
            photonUnifiedResponse.setMimeType(decoded.m_aMimeType);
            photonUnifiedResponse.setContentDispositionType(EContentDispositionType.ATTACHMENT);
            photonUnifiedResponse.setContentDispositionFilename("base64-decoded-file.dat");
            photonUnifiedResponse.disableCaching();
        } else {
            photonUnifiedResponse.createBadRequest();
        }
    });

    public BasePageUtilsBase64Decode(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_UTILS_BASE64_DECODE.getAsMLT());
    }

    public BasePageUtilsBase64Decode(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageUtilsBase64Decode(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageUtilsBase64Decode(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    public void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        String string;
        Charset charset;
        String string2;
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse = WPECTYPE.getRequestScope();
        boolean bl = WPECTYPE.params().isCheckBoxChecked(FIELD_SHOW_AS_STRING, false);
        FormErrorList formErrorList = new FormErrorList();
        if (WPECTYPE.params().hasStringValue((Object)"action", "perform")) {
            string2 = WPECTYPE.params().getAsString((Object)FIELD_CHARSET);
            charset = CharsetHelper.getCharsetFromNameOrNull((String)string2);
            string = WPECTYPE.params().getAsString((Object)FIELD_DECODE);
            if (charset == null && bl) {
                formErrorList.addFieldError(FIELD_CHARSET, "To show result as String, a Charset must be selected!");
            }
            if (StringHelper.isEmpty((String)string)) {
                formErrorList.addFieldError(FIELD_DECODE, "Please provide a String to decode!");
            }
            byte[] byArray = null;
            if (formErrorList.isEmpty() && (byArray = Base64.safeDecode((String)string)) == null) {
                formErrorList.addFieldError(FIELD_DECODE, "The provided String to decode is not Base64 encoded!");
            }
            if (formErrorList.isEmpty()) {
                hCNodeList.addChild((IHCNode)this.success("Content decoded from " + string.length() + " characters to " + byArray.length + " bytes (=" + LocaleFormatter.getFormattedPercent((double)((double)byArray.length / (double)string.length()), (int)2, (Locale)locale) + ")!" + (String)(bl ? " Showing result in charset '" + charset.name() + "'" : "")));
                if (bl) {
                    String string3 = new String(byArray, charset);
                    HCTextArea hCTextArea = (HCTextArea)((HCTextArea)((HCTextArea)new HCTextArea().setReadOnly(true)).setValue(string3)).addStyle(CCSSProperties.FONT_FAMILY.newValue("monospace"));
                    BootstrapFormHelper.markAsFormControl((IHCNode)hCTextArea);
                    hCNodeList.addChild((IHCNode)hCTextArea);
                } else {
                    IMimeType iMimeType = MimeTypeDeterminator.getInstance().getMimeTypeFromBytes(byArray, null);
                    if (iMimeType == null) {
                        iMimeType = CMimeType.APPLICATION_OCTET_STREAM;
                    }
                    Decoded.getInstance().setData(byArray, iMimeType);
                    hCNodeList.addChild((IHCNode)this.success((IHCNode)this.a((ISimpleURL)AJAX_GET_DECODED.getInvocationURL(iRequestWebScopeWithoutResponse)).addChild("Download decoded result file")));
                }
            }
        }
        if (formErrorList.isNotEmpty()) {
            hCNodeList.addChild((IHCNode)this.getUIHandler().createIncorrectInputBox((ILayoutExecutionContext)WPECTYPE));
        }
        string2 = (BootstrapForm)hCNodeList.addAndReturnChild((IHCNode)((BootstrapForm)this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE)));
        string2.setEncTypeFileUpload();
        string2.addChild((IHCNode)new HCHiddenField("action", "perform"));
        string2.addFormGroup(new BootstrapFormGroup().setLabelMandatory("Content to decode").setCtrl((IHCNode)((HCTextArea)((HCTextArea)new HCTextArea((IHCRequestField)new RequestField(FIELD_DECODE)).setRows(10)).addClass(CBootstrapCSS.TEXT_MONOSPACE)).setPlaceholder("Text to be Base64 decoded")).setErrorList(formErrorList.getListOfField(FIELD_DECODE)));
        charset = new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_SHOW_AS_STRING, false));
        string2.addFormGroup(new BootstrapFormGroup().setLabel("Show result as String?").setCtrl((IHCNode)charset).setErrorList(formErrorList.getListOfField(FIELD_SHOW_AS_STRING)));
        string2.addFormGroup(new BootstrapFormGroup().setLabel("Charset").setCtrl((IHCNode)new HCCharsetSelect((IHCRequestField)new RequestField(FIELD_CHARSET, StandardCharsets.UTF_8.name()), true, locale)).setErrorList(formErrorList.getListOfField(FIELD_CHARSET)));
        string = (BootstrapRow)string2.getLastChild();
        if (!bl) {
            string.addStyle(CCSSProperties.DISPLAY_NONE);
        }
        charset.addEventHandler(EJSEvent.CLICK, (IHasJSCode)JQuery.idRef((IHCHasID)string).toggle());
        string2.addChild((IHCNode)((BootstrapButton)new BootstrapSubmitButton().addChild("Create Base64 decoded version")).setIcon((IIcon)EDefaultIcon.YES));
    }

    public static class Decoded
    extends AbstractSessionWebSingleton {
        private byte[] m_aData;
        private IMimeType m_aMimeType;

        @Deprecated(forRemoval=false)
        @UsedViaReflection
        public Decoded() {
        }

        @Nonnull
        public static Decoded getInstance() {
            return (Decoded)Decoded.getSessionSingleton(Decoded.class);
        }

        public void setData(@Nullable byte[] byArray, @Nullable IMimeType iMimeType) {
            this.m_aData = byArray;
            this.m_aMimeType = iMimeType;
        }

        public boolean hasData() {
            return this.m_aData != null && this.m_aMimeType != null;
        }
    }
}

