/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.sysinfo;

import com.helger.annotation.concurrent.Immutable;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.hierarchy.IParentProvider;
import com.helger.collection.iterator.IteratorHelper;
import com.helger.tree.withid.DefaultTreeItemWithID;
import com.helger.tree.withid.unique.DefaultTreeWithGlobalUniqueID;
import jakarta.annotation.Nonnull;
import java.net.NetworkInterface;

@Immutable
public final class NetworkInterfaceHelper {
    private static final NetworkInterfaceHelper INSTANCE = new NetworkInterfaceHelper();

    private NetworkInterfaceHelper() {
    }

    @Nonnull
    public static DefaultTreeWithGlobalUniqueID<String, NetworkInterface> createNetworkInterfaceTree() {
        DefaultTreeWithGlobalUniqueID defaultTreeWithGlobalUniqueID = new DefaultTreeWithGlobalUniqueID();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        try {
            for (NetworkInterface networkInterface : IteratorHelper.getIterator(NetworkInterface.getNetworkInterfaces())) {
                if (networkInterface.getParent() == null) {
                    ((DefaultTreeItemWithID)defaultTreeWithGlobalUniqueID.getRootItem()).createChildItem((Object)networkInterface.getName(), (Object)networkInterface);
                    continue;
                }
                commonsArrayList.add((Object)networkInterface);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to get all network interfaces", exception);
        }
        int n = 0;
        while (commonsArrayList.isNotEmpty()) {
            NetworkInterface networkInterface;
            networkInterface = (NetworkInterface)commonsArrayList.removeFirstOrNull();
            DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)defaultTreeWithGlobalUniqueID.getItemWithID((Object)networkInterface.getParent().getName());
            if (defaultTreeItemWithID != null) {
                defaultTreeItemWithID.createChildItem((Object)networkInterface.getName(), (Object)networkInterface);
                n = 0;
                continue;
            }
            commonsArrayList.add((Object)networkInterface);
            if (++n <= commonsArrayList.size()) continue;
            throw new IllegalStateException("Seems like we have a data structure inconsistency! Remaining are: " + String.valueOf(commonsArrayList));
        }
        return defaultTreeWithGlobalUniqueID;
    }

    @Nonnull
    public static IParentProvider<NetworkInterface> parentProvider() {
        return NetworkInterface::getParent;
    }
}

