/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.sysinfo;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.compare.ESortOrder;
import com.helger.base.rt.StackTraceHelper;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.helper.CollectionSort;
import com.helger.datetime.format.PDTToString;
import com.helger.datetime.helper.PDTFactory;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.DataTablesLengthMenu;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayTextWithArgs;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;

public class BasePageSysInfoThreads<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageSysInfoThreads(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SYSINFO_THREADS.getAsMLT());
    }

    public BasePageSysInfoThreads(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageSysInfoThreads(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageSysInfoThreads(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    @Nonnull
    private static String _getThreadGroupName(@Nullable ThreadGroup threadGroup) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ThreadGroup threadGroup2 = threadGroup; threadGroup2 != null; threadGroup2 = threadGroup2.getParent()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '/');
            }
            stringBuilder.insert(0, threadGroup2.getName());
        }
        return stringBuilder.toString();
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        ICommonsOrderedMap iCommonsOrderedMap = CollectionSort.getSortedByKey(Thread.getAllStackTraces(), Comparator.comparing(Thread::getId));
        hCNodeList.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.MSG_HEADER.getDisplayTextWithArgs(locale, new Object[]{iCommonsOrderedMap.size(), PDTToString.getAsString((LocalDateTime)PDTFactory.getCurrentLocalDateTime(), (Locale)locale)})));
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_ID.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_GROUP.getDisplayText(locale)), new DTCol(EText.MSG_NAME.getDisplayText(locale)), new DTCol(EText.MSG_PRIORITY.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_STATE.getDisplayText(locale)), new DTCol(EText.MSG_STACKTRACE.getDisplayText(locale)).setOrderable(false)}).setID(this.getID());
        for (Map.Entry entry : iCommonsOrderedMap.entrySet()) {
            HCRow hCRow = hCTable.addBodyRow();
            Thread thread = (Thread)entry.getKey();
            hCRow.addCell(Long.toString(thread.getId()));
            ThreadGroup threadGroup = thread.getThreadGroup();
            hCRow.addCell(BasePageSysInfoThreads._getThreadGroupName(threadGroup));
            hCRow.addCell(thread.getName());
            hCRow.addCell(Integer.toString(thread.getPriority()));
            hCRow.addCell(String.valueOf((Object)thread.getState()));
            hCRow.addCell((Iterable)HCExtHelper.nl2brList((String)StackTraceHelper.getStackAsString((StackTraceElement[])((StackTraceElement[])entry.getValue()))));
        }
        hCNodeList.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        bootstrapDataTables.setLengthMenu(DataTablesLengthMenu.INSTANCE_ALL);
        bootstrapDataTables.setAjaxBuilder(null);
        bootstrapDataTables.setNoTextLoadingURL();
        hCNodeList.addChild((IHCNode)bootstrapDataTables);
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        MSG_HEADER("Anzahl={0}; Prios (min/norm/max): 1/5/10; Zeitpunkt: {1}", "Total count={0}; Prios (min/norm/max): 1/5/10; Datetime: {1}"),
        MSG_ID("ID", "ID"),
        MSG_GROUP("Gruppe", "Group"),
        MSG_NAME("Name", "Name"),
        MSG_PRIORITY("Prio", "Prio"),
        MSG_STATE("Status", "State"),
        MSG_STACKTRACE("Stacktrace", "Stacktrace");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

