/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.sysinfo;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.name.IHasDisplayName;
import com.helger.base.thirdparty.IThirdPartyModule;
import com.helger.base.thirdparty.ThirdPartyModuleRegistry;
import com.helger.collection.helper.CollectionSort;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.HCUL;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.compare.ComparatorHelper;
import com.helger.text.display.IHasDisplayText;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;

public class BasePageSysInfoThirdPartyLibraries<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageSysInfoThirdPartyLibraries(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SYSINFO_THIRDPARTYLIBS.getAsMLT());
    }

    public BasePageSysInfoThirdPartyLibraries(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
    }

    public BasePageSysInfoThirdPartyLibraries(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageSysInfoThirdPartyLibraries(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    @Nonnull
    private static IHCNode _getModuleHCNode(@Nonnull IThirdPartyModule iThirdPartyModule, @Nonnull Locale locale) {
        HCNodeList hCNodeList = new HCNodeList();
        Object object = iThirdPartyModule.getDisplayName();
        if (iThirdPartyModule.getVersion() != null) {
            object = (String)object + " " + iThirdPartyModule.getVersion().getAsString();
        }
        if (iThirdPartyModule.getWebSiteURL() == null) {
            hCNodeList.addChild((String)object);
        } else {
            hCNodeList.addChild((IHCNode)((HCA)new HCA((ISimpleURL)new SimpleURL(iThirdPartyModule.getWebSiteURL())).setTargetBlank()).addChild((String)object));
        }
        hCNodeList.addChild(EText.MSG_LICENSED_UNDER.getDisplayText(locale));
        Object object2 = iThirdPartyModule.getLicense().getDisplayName();
        if (iThirdPartyModule.getLicense().getVersion() != null) {
            object2 = (String)object2 + " " + iThirdPartyModule.getLicense().getVersion().getAsString();
        }
        if (iThirdPartyModule.getLicense().getURL() == null) {
            hCNodeList.addChild((String)object2);
        } else {
            hCNodeList.addChild((IHCNode)((HCA)new HCA((ISimpleURL)new SimpleURL(iThirdPartyModule.getLicense().getURL())).setTargetBlank()).addChild((String)object2));
        }
        return hCNodeList;
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        hCNodeList.addChild((IHCNode)this.h4(EText.MSG_TPM_HEADER.getDisplayText(locale)));
        Set set = ThirdPartyModuleRegistry.getInstance().getAllRegisteredThirdPartyModules();
        HCUL hCUL = (HCUL)hCNodeList.addAndReturnChild((IHCNode)new HCUL());
        for (IThirdPartyModule iThirdPartyModule : CollectionSort.getSorted((Collection)set, (Comparator)ComparatorHelper.getComparatorCollating(IHasDisplayName::getDisplayName, (Locale)locale))) {
            if (iThirdPartyModule.isOptional()) continue;
            hCUL.addItem(BasePageSysInfoThirdPartyLibraries._getModuleHCNode(iThirdPartyModule, locale));
        }
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_TPM_HEADER("Folgende externen Module werden verwendet", "The following external libraries are used"),
        MSG_LICENSED_UNDER(" lizensiert unter ", " licensed under ");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

