/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.sysinfo;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.compare.ESortOrder;
import com.helger.base.rt.PropertiesHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.base.system.SystemProperties;
import com.helger.base.url.URLHelper;
import com.helger.base.version.Version;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.helper.CollectionSort;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCCol;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.io.file.FileHelper;
import com.helger.io.resource.URLResource;
import com.helger.photon.bootstrap4.nav.BootstrapTabBox;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap4.table.BootstrapTable;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.Comparator;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class BasePageSysInfoSecurity<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageSysInfoSecurity(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SYSINFO_SECURITY.getAsMLT());
    }

    public BasePageSysInfoSecurity(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageSysInfoSecurity(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageSysInfoSecurity(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCRow hCRow;
        Object object222;
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        BootstrapTabBox bootstrapTabBox = new BootstrapTabBox();
        CommonsArrayList commonsArrayList = CollectionSort.getSorted((Object[])Security.getProviders(), Comparator.comparing(Provider::getName).thenComparing(Comparator.comparing(provider -> Version.parse((String)provider.getVersionStr()))));
        Object object3 = new File(SystemProperties.getJavaHome() + "/lib/security", "java.security");
        Object object422 = PropertiesHelper.loadProperties((InputStream)FileHelper.getInputStream((File)object3));
        if (object422 != null && "true".equalsIgnoreCase((String)object422.get((Object)"security.overridePropertiesFile"))) {
            object222 = SystemProperties.getPropertyValueOrNull((String)"java.security.properties");
            boolean bl = StringHelper.startsWith((CharSequence)object222, (char)'=');
            if (bl) {
                object222 = ((String)object222).substring(1);
                object422.clear();
            }
            if (object222 != null) {
                object3 = new File((String)(object222 = PropertiesHelper.expandSystemProperties((String)object222)));
                object422 = ((File)object3).exists() ? PropertiesHelper.loadProperties((InputStream)FileHelper.getInputStream((File)object3)) : PropertiesHelper.loadProperties((InputStream)URLResource.getInputStream((URL)URLHelper.getAsURL((String)object222)));
            }
        }
        object222 = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_VALUE.getDisplayText(locale))}).setID(this.getID() + "-secattrs");
        if (object422 != null) {
            for (Object object5 : object422.entrySet()) {
                HCRow object7 = object222.addBodyRow();
                object7.addCell((String)object5.getKey());
                object7.addCell((String)object5.getValue());
            }
        }
        Object object6 = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)object222);
        object6.setPageLengthAll();
        bootstrapTabBox.addTab("secattrs", EText.TAB_SECATTRS.getDisplayText(locale), (IHCNode)((HCNodeList)new HCNodeList().addChild((IHCNode)object222)).addChild((IHCNode)object6));
        object3 = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_VERSION.getDisplayText(locale)).setDisplayType(EDTColType.DOUBLE, locale), new DTCol(EText.MSG_INFO.getDisplayText(locale))}).setID(this.getID() + "-providers");
        for (Object object222 : commonsArrayList) {
            object6 = object3.addBodyRow();
            object6.addCell(((Provider)object222).getName());
            object6.addCell(((Provider)object222).getVersionStr());
            object6.addCell(((Provider)object222).getInfo());
        }
        object422 = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)object3);
        object422.setPageLengthAll();
        bootstrapTabBox.addTab("providers", EText.TAB_PROVIDERS.getDisplayText(locale), (IHCNode)((HCNodeList)new HCNodeList().addChild((IHCNode)object3)).addChild((IHCNode)object422));
        object3 = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_PROVIDER.getDisplayText(locale)).setDataSort(new int[]{0, 1, 2}), new DTCol(EText.MSG_TYPE.getDisplayText(locale)).setDataSort(new int[]{1, 2}).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_ALGORITHM.getDisplayText(locale)), new DTCol(EText.MSG_CLASSNAME.getDisplayText(locale))}).setID(this.getID() + "-algorithm");
        for (Object object222 : commonsArrayList) {
            object6 = ((Provider)object222).getName() + " " + ((Provider)object222).getVersionStr();
            for (Provider.Service service : ((Provider)object222).getServices()) {
                hCRow = object3.addBodyRow();
                hCRow.addCell((IHCNode)this.span((String)object6).addClass(CSS_CLASS_NOWRAP));
                hCRow.addCell(service.getType());
                hCRow.addCell(service.getAlgorithm());
                hCRow.addCell(service.getClassName());
            }
        }
        object422 = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)object3);
        object422.setPageLengthAll();
        bootstrapTabBox.addTab("algos", EText.TAB_ALGORITHMS.getDisplayText(locale), (IHCNode)((HCNodeList)new HCNodeList().addChild((IHCNode)object3)).addChild((IHCNode)object422));
        for (Object object422 : commonsArrayList) {
            Object object5;
            object222 = ((Provider)object422).getName() + " " + ((Provider)object422).getVersionStr();
            object6 = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_TYPE.getDisplayText(locale)).setDataSort(new int[]{0, 1}), new DTCol(EText.MSG_ALGORITHM.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_CLASSNAME.getDisplayText(locale))}).setID(this.getID() + "-" + RegExHelper.getAsIdentifier((String)object222));
            for (Provider.Service service : ((Provider)object422).getServices()) {
                hCRow = object6.addBodyRow();
                hCRow.addCell(service.getType());
                hCRow.addCell(service.getAlgorithm());
                hCRow.addCell(service.getClassName());
            }
            object5 = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)object6);
            object5.setPageLengthAll();
            BootstrapTable bootstrapTable = new BootstrapTable(new IHCCol[]{HCCol.star(), HCCol.star()});
            bootstrapTable.addHeaderRow().addCells(new String[]{EText.MSG_KEY.getDisplayText(locale), EText.MSG_VALUE.getDisplayText(locale)});
            hCRow = new CommonsHashSet();
            for (Object object : ((Provider)object422).keySet()) {
                hCRow.add((Object)((String)object));
            }
            for (Object object : hCRow.getSorted(Comparator.naturalOrder())) {
                HCRow hCRow2 = bootstrapTable.addBodyRow();
                hCRow2.addCell((String)object);
                hCRow2.addCell(((Provider)object422).getProperty((String)object));
            }
            bootstrapTabBox.addTab(RegExHelper.getAsIdentifier((String)object222), (String)object222, (IHCNode)((HCNodeList)((HCNodeList)((HCNodeList)new HCNodeList().addChild((IHCNode)object6)).addChild((IHCNode)object5)).addChild((IHCNode)this.getUIHandler().createDataGroupHeader(EText.MSG_PROPS.getDisplayText(locale)))).addChild((IHCNode)bootstrapTable));
        }
        object3 = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_PROVIDER.getDisplayText(locale)).setDataSort(new int[]{0, 1, 2}), new DTCol(EText.MSG_TYPE.getDisplayText(locale)).setDataSort(new int[]{1, 2}), new DTCol(EText.MSG_ALGORITHM.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_DEFAULT_PROTOCOLS.getDisplayText(locale)), new DTCol(EText.MSG_DEFAULT_CIPHER_SUITES.getDisplayText(locale)), new DTCol(EText.MSG_SUPPORTED_PROTOCOLS.getDisplayText(locale)), new DTCol(EText.MSG_SUPPORTED_CIPHER_SUITES.getDisplayText(locale))}).setID(this.getID() + "-sslcontexts");
        for (Object object222 : commonsArrayList) {
            object6 = ((Provider)object222).getName() + " " + ((Provider)object222).getVersionStr();
            for (Provider.Service service : ((Provider)object222).getServices()) {
                if (!"SSLContext".equals(service.getType())) continue;
                hCRow = object3.addBodyRow();
                hCRow.addCell((IHCNode)this.span((String)object6).addClass(CSS_CLASS_NOWRAP));
                hCRow.addCell(service.getType());
                hCRow.addCell(service.getAlgorithm());
                try {
                    Object object;
                    SSLContext sSLContext = SSLContext.getInstance(service.getAlgorithm());
                    if (!"Default".equals(service.getAlgorithm())) {
                        sSLContext.init(null, null, null);
                    }
                    object = sSLContext.getDefaultSSLParameters();
                    hCRow.addCell(StringImplode.getImploded((String)", ", (Object[])((SSLParameters)object).getProtocols()));
                    hCRow.addCell(StringImplode.getImploded((String)", ", (Object[])((SSLParameters)object).getCipherSuites()));
                    object = sSLContext.getSupportedSSLParameters();
                    hCRow.addCell(StringImplode.getImploded((String)", ", (Object[])((SSLParameters)object).getProtocols()));
                    hCRow.addCell(StringImplode.getImploded((String)", ", (Object[])((SSLParameters)object).getCipherSuites()));
                }
                catch (Exception exception) {
                    hCRow.addCell((IHCNode)this.error(exception.getMessage()));
                    hCRow.addCell();
                    hCRow.addCell();
                    hCRow.addCell();
                }
            }
        }
        object422 = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)object3);
        object422.setPageLengthAll();
        bootstrapTabBox.addTab("sslcontext", EText.TAB_SSLCONTEXT.getDisplayText(locale), (IHCNode)((HCNodeList)new HCNodeList().addChild((IHCNode)object3)).addChild((IHCNode)object422));
        hCNodeList.addChild((IHCNode)bootstrapTabBox);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        TAB_SECATTRS("Attribute", "Attributes"),
        TAB_PROVIDERS("Provider", "Providers"),
        TAB_ALGORITHMS("Algorithmen", "Algorithms"),
        TAB_SSLCONTEXT("SSLContext", "SSLContext"),
        MSG_KEY("Name", "Name"),
        MSG_VALUE("Wert", "Value"),
        MSG_NAME("Name", "Name"),
        MSG_VERSION("Version", "Version"),
        MSG_INFO("Info", "Info"),
        MSG_PROPS("Eigenschaften", "Properties"),
        MSG_PROVIDER("Provider", "Provider"),
        MSG_TYPE("Typ", "Type"),
        MSG_ALGORITHM("Algorithmus", "Algorithm"),
        MSG_CLASSNAME("Klassenname", "Class name"),
        MSG_DEFAULT_PROTOCOLS("Standard Protokolle", "Default protocols"),
        MSG_DEFAULT_CIPHER_SUITES("Standard Cipher Suites", "Default cipher suites"),
        MSG_SUPPORTED_PROTOCOLS("Unterst\u00fctzte Protokolle", "Supported protocols"),
        MSG_SUPPORTED_CIPHER_SUITES("Unterst\u00fctzte Cipher Suites", "Supported cipher suites");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

