/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.sysinfo;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.compare.ESortOrder;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.system.SystemProperties;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.datetime.format.PDTToString;
import com.helger.datetime.helper.PDTFactory;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElementWithChildren;
import com.helger.html.hc.html.grouping.HCOL;
import com.helger.html.hc.html.grouping.IHCLI;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.bootstrap4.uictrls.ext.BootstrapTechnicalUI;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKeyStore;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayTextWithArgs;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Locale;

public class BasePageSysInfoCACerts<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageSysInfoCACerts(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SYSINFO_CACERTS.getAsMLT());
    }

    public BasePageSysInfoCACerts(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageSysInfoCACerts(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageSysInfoCACerts(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    private void _showKeyStore(@Nonnull WPECTYPE WPECTYPE, int n, @Nonnull IHCElementWithChildren<?> iHCElementWithChildren, @Nonnull KeyStore keyStore) {
        Locale locale = WPECTYPE.getDisplayLocale();
        try {
            CommonsArrayList commonsArrayList = new CommonsArrayList(keyStore.aliases());
            HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol("Alias"), new DTCol("Subject").setInitialSorting(ESortOrder.ASCENDING), new DTCol("Root cert?"), ((DTCol)new DTCol("Valid from").setWidth(170)).setDisplayType(EDTColType.DATETIME, locale), ((DTCol)new DTCol("Valid to").setWidth(170)).setDisplayType(EDTColType.DATETIME, locale)}).setID(this.getID() + n);
            for (String string : commonsArrayList) {
                HCRow hCRow = hCTable.addBodyRow();
                hCRow.addCell(string);
                try {
                    KeyStore.Entry entry = keyStore.getEntry(string, null);
                    if (entry instanceof KeyStore.TrustedCertificateEntry) {
                        KeyStore.TrustedCertificateEntry trustedCertificateEntry = (KeyStore.TrustedCertificateEntry)entry;
                        Certificate certificate = trustedCertificateEntry.getTrustedCertificate();
                        if (certificate instanceof X509Certificate) {
                            X509Certificate x509Certificate = (X509Certificate)certificate;
                            String string2 = x509Certificate.getSubjectX500Principal().getName();
                            String string3 = x509Certificate.getIssuerX500Principal().getName();
                            boolean bl = string2.equals(string3);
                            hCRow.addCell(string2);
                            hCRow.addCell(new String[]{EPhotonCoreText.getYesOrNo((boolean)bl, (Locale)locale), bl ? null : string3});
                            LocalDateTime localDateTime = PDTFactory.createLocalDateTime((Date)x509Certificate.getNotBefore());
                            hCRow.addCell(PDTToString.getAsString((LocalDateTime)localDateTime, (Locale)locale));
                            LocalDateTime localDateTime2 = PDTFactory.createLocalDateTime((Date)x509Certificate.getNotAfter());
                            hCRow.addCell(PDTToString.getAsString((LocalDateTime)localDateTime2, (Locale)locale));
                            continue;
                        }
                        hCRow.addCell((IHCNode)this.em("Not an X509 certificate"));
                        hCRow.addCell();
                        hCRow.addCell();
                        hCRow.addCell();
                        continue;
                    }
                    hCRow.addCell((IHCNode)this.em("Unsupported type: " + ClassHelper.getClassLocalName((Object)entry)));
                    hCRow.addCell();
                    hCRow.addCell();
                    hCRow.addCell();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    hCRow.addCell((IHCNode)this.em("password required?"));
                    hCRow.addCell();
                    hCRow.addCell();
                    hCRow.addCell();
                }
            }
            ((IHCElementWithChildren)iHCElementWithChildren.addChild((IHCNode)hCTable)).addChild((IHCNode)BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable));
        }
        catch (GeneralSecurityException generalSecurityException) {
            iHCElementWithChildren.addChild((IHCNode)this.error((IHCNode)this.div("Error traversing trust store.")).addChild((IHCNode)BootstrapTechnicalUI.getTechnicalDetailsNode((Throwable)generalSecurityException, (Locale)locale)));
        }
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        commonsArrayList.add((Object)SystemProperties.getPropertyValueOrNull((String)"javax.net.ssl.trustStore"));
        commonsArrayList.add((Object)(SystemProperties.getJavaHome() + "/lib/security/cacerts"));
        commonsArrayList.add((Object)(SystemProperties.getJavaHome() + "/jre/lib/security/cacerts"));
        HCOL hCOL = new HCOL();
        int n = 0;
        for (String string : commonsArrayList) {
            if (!StringHelper.isNotEmpty((String)string)) continue;
            File file = new File(string);
            IHCLI iHCLI = hCOL.addAndReturnItem((IHCNode)this.div("Checking file ").addChild((IHCNode)this.code(file.getAbsolutePath())));
            if (file.exists()) {
                if (file.canRead()) {
                    LoadedKeyStore loadedKeyStore = KeyStoreHelper.loadKeyStore((IKeyStoreType)EKeyStoreType.JKS, (String)string, (char[])"changeit".toCharArray());
                    if (loadedKeyStore.isSuccess()) {
                        KeyStore keyStore = loadedKeyStore.getKeyStore();
                        this._showKeyStore(WPECTYPE, n, (IHCElementWithChildren<?>)iHCLI, keyStore);
                    } else {
                        iHCLI.addChild((IHCNode)this.error("Failed to load the keystore - " + loadedKeyStore.getErrorText(locale)));
                    }
                } else {
                    iHCLI.addChild((IHCNode)this.error("File exist but cannot be read"));
                }
            } else {
                iHCLI.addChild((IHCNode)this.badgeWarn("File does not exist"));
            }
            ++n;
        }
        hCNodeList.addChild((IHCNode)hCOL);
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        MSG_HEADER_SPECIAL_SYSPROPS("Spezielle System-Eigenschaften:", "Special system properties:"),
        MSG_HEADER_SYSPROPS("Alle System-Eigenschaften:", "All system properties:"),
        MSG_HEADER_NAME("Name", "Name"),
        MSG_HEADER_VALUE("Wert", "Value"),
        MSG_SYSTEM_OS("Betriebssystem", "Operating system"),
        MSG_SYSTEM_NUM_PROCESSORS("Anzahl Prozessoren", "Number of processors"),
        MSG_SYSTEM_CHARSET("System-Zeichensatz", "System charset"),
        MSG_SYSTEM_LOCALE("System-Sprache", "System locale"),
        MSG_SYSTEM_MEM_FREE("Freier Speicher", "Free memory"),
        MSG_SYSTEM_MEM_MAX("Max Speicher", "Max memory"),
        MSG_SYSTEM_MEM_TOTAL("Totaler Speicher", "Total memory"),
        MSG_CONTEXT_CLASSLOADER("Context Classloader", "Context classloader"),
        MSG_SYSTEM_CLASSLOADER("System Classloader", "System classloader"),
        MSG_SYSTEM_BASEDIR("Datenverzeichnis", "Data directory"),
        MSG_SYSTEM_BASEDIR_TOTAL("Speicherplatz im Datenverzeichnis", "Total space in the data directory"),
        MSG_SYSTEM_BASEDIR_FREE("Freier Speicherplatz im Datenverzeichnis", "Free space in the data directory"),
        MSG_SYSTEM_BASEDIR_USABLE("Verwendbarer Speicherplatz im Datenverzeichnis", "Usable space in the data directory"),
        MSG_SYSTEM_SC_DIR("WebApp-Verzeichnis", "WebApp directory"),
        MSG_SYSTEM_SC_DIR_TOTAL("Speicherplatz im WebApp-Verzeichnis", "Total space in the WebApp directory"),
        MSG_SYSTEM_SC_DIR_FREE("Freier Speicherplatz im WebApp-Verzeichnis", "Free space in the WebApp directory"),
        MSG_SYSTEM_SC_DIR_USABLE("Verwendbarer Speicherplatz im WebApp-Verzeichnis", "Usable space in the WebApp directory"),
        MSG_SYSTEM_SC_NO_DIR("Kein Verzeichnis: {0}", "Not a directory: {0}"),
        MSG_STARTUP_DATE_TIME("Startzeit der Anwendung", "Application startup time"),
        MSG_UPTIME("Uptime", "Uptime"),
        MSG_JCE_UNLIMITED_STRENGTH("JCE Unlimited Strength Policy", "JCE Unlimited Strength Policy"),
        MSG_ENDORSED_DIR("Endorsed Verzeichnis", "Endorsed directory"),
        MSG_EXT_DIR("Extension Verzeichnis", "Extension directory"),
        MSG_DIR_NOT_EXISTING("Das Verzeichnis existiert nicht", "The directory does not exist"),
        MSG_DIR_EMPTY("Das Verzeichnis ist leer", "The directory is empty"),
        MSG_DIR_FILE_ENTRY("{0} ({1} Bytes - {2})", "{0} ({1} bytes - {2})");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

