/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.settings;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.base.name.IHasDisplayName;
import com.helger.base.string.StringHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.forms.HCHiddenField;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.request.IHCRequestField;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.bootstrap4.button.BootstrapSubmitButton;
import com.helger.photon.bootstrap4.form.BootstrapForm;
import com.helger.photon.bootstrap4.form.BootstrapFormGroup;
import com.helger.photon.bootstrap4.pages.settings.BasePageSettingsLogLevel;
import com.helger.photon.bootstrap4.traits.IHCBootstrap4Trait;
import com.helger.photon.core.execcontext.ISimpleWebExecutionContext;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.core.form.RequestField;
import com.helger.photon.uicore.html.select.HCExtSelect;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InternalLog4J2Handler
implements IHCBootstrap4Trait {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalLog4J2Handler.class);
    private static final String FIELD_NEW_LEVEL = "level";

    InternalLog4J2Handler() {
    }

    public void handle(@Nonnull IWebPageExecutionContext iWebPageExecutionContext) {
        String string;
        HCNodeList hCNodeList = iWebPageExecutionContext.getNodeList();
        Locale locale = iWebPageExecutionContext.getDisplayLocale();
        hCNodeList.addChild((IHCNode)this.info((Iterable)HCExtHelper.nl2divList((String)BasePageSettingsLogLevel.EText.MSG_HEADER.getDisplayText(locale))));
        FormErrorList formErrorList = new FormErrorList();
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        LoggerConfig loggerConfig = loggerContext.getConfiguration().getRootLogger();
        Level level = loggerConfig.getLevel();
        ELevel eLevel = ELevel.getFromLevelOrNull(level);
        if (iWebPageExecutionContext.hasAction("perform")) {
            string = iWebPageExecutionContext.params().getAsStringTrimmed(FIELD_NEW_LEVEL);
            ELevel eLevel2 = ELevel.getFromIDOrNull(string);
            if (StringHelper.isEmpty((String)string)) {
                formErrorList.addFieldError(FIELD_NEW_LEVEL, BasePageSettingsLogLevel.EText.MSG_ERR_NO_LEVEL.getDisplayText(locale));
            } else if (eLevel2 == null) {
                formErrorList.addFieldError(FIELD_NEW_LEVEL, BasePageSettingsLogLevel.EText.MSG_ERR_INVALID_LEVEL.getDisplayText(locale));
            }
            if (formErrorList.isEmpty()) {
                if (eLevel2 == eLevel) {
                    LOGGER.info("No change in log levels. Sticking with " + String.valueOf((Object)eLevel));
                    hCNodeList.addChild((IHCNode)this.info(BasePageSettingsLogLevel.EText.MSG_NO_CHANGE.getDisplayTextWithArgs(locale, new Object[]{eLevel.getDisplayName()})));
                } else {
                    LOGGER.info("Changing log levels from " + String.valueOf((Object)eLevel) + " to " + String.valueOf((Object)eLevel2));
                    Configurator.setRootLevel((Level)eLevel2.getLevel());
                    AuditHelper.onAuditExecuteSuccess((String)"change-log-level", (Object[])new Object[]{eLevel.getDisplayName(), eLevel2.getDisplayName()});
                    hCNodeList.addChild((IHCNode)this.info(BasePageSettingsLogLevel.EText.MSG_CHANGE_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{eLevel.getDisplayName(), eLevel2.getDisplayName()})));
                    LOGGER.info("Finished changing log levels from " + String.valueOf((Object)eLevel) + " to " + String.valueOf((Object)eLevel2));
                    eLevel = eLevel2;
                }
            }
        }
        string = (BootstrapForm)hCNodeList.addAndReturnChild((IHCNode)new BootstrapForm((ISimpleWebExecutionContext)iWebPageExecutionContext));
        if (eLevel != null) {
            string.addFormGroup(new BootstrapFormGroup().setLabel(BasePageSettingsLogLevel.EText.MSG_EXISTING_LEVEL.getDisplayText(locale)).setCtrl((IHCNode)this.badgeInfo(eLevel.getDisplayName())));
        }
        string.addFormGroup(new BootstrapFormGroup().setLabelMandatory(BasePageSettingsLogLevel.EText.MSG_FIELD_LEVEL.getDisplayText(locale)).setCtrl((IHCNode)new LevelSelect((IHCRequestField)new RequestField(FIELD_NEW_LEVEL, eLevel != null ? eLevel.getID() : null), locale)).setErrorList(formErrorList.getListOfField(FIELD_NEW_LEVEL)));
        string.addChild((IHCNode)new HCHiddenField("action", "perform"));
        string.addChild((IHCNode)new BootstrapSubmitButton().addChild(BasePageSettingsLogLevel.EText.MSG_SUBMIT_BUTTON.getDisplayText(locale)));
    }

    static enum ELevel implements IHasID<String>,
    IHasDisplayName
    {
        OFF(Level.OFF),
        FATAL(Level.FATAL),
        ERROR(Level.ERROR),
        WARN(Level.WARN),
        INFO(Level.INFO),
        DEBUG(Level.DEBUG),
        TRACE(Level.TRACE),
        ALL(Level.ALL);

        private final Level m_aLevel;

        private ELevel(Level level) {
            this.m_aLevel = level;
        }

        @Nonnull
        @Nonempty
        public String getID() {
            return "L" + Integer.toString(this.m_aLevel.intLevel());
        }

        @Nonnull
        @Nonempty
        public String getDisplayName() {
            return this.name() + " (" + this.m_aLevel.intLevel() + ")";
        }

        @Nonnull
        public Level getLevel() {
            return this.m_aLevel;
        }

        @Nullable
        public static ELevel getFromIDOrNull(@Nullable String string) {
            return (ELevel)EnumHelper.getFromIDOrNull(ELevel.class, (Object)string);
        }

        @Nullable
        public static ELevel getFromLevelOrNull(@Nullable Level level) {
            if (level != null) {
                for (ELevel eLevel : ELevel.values()) {
                    if (!eLevel.m_aLevel.equals((Object)level)) continue;
                    return eLevel;
                }
            }
            return null;
        }
    }

    private static class LevelSelect
    extends HCExtSelect {
        public LevelSelect(@Nonnull IHCRequestField iHCRequestField, @Nonnull Locale locale) {
            super(iHCRequestField);
            for (ELevel eLevel : ELevel.values()) {
                this.addOption(eLevel.getID(), eLevel.getDisplayName());
            }
            this.addOptionPleaseSelect(locale);
        }
    }
}

