/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.settings;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.string.StringHelper;
import com.helger.html.hc.IHCConversionSettings;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.html.forms.HCCheckBox;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.request.IHCRequestFieldBoolean;
import com.helger.photon.bootstrap4.buttongroup.BootstrapButtonToolbar;
import com.helger.photon.bootstrap4.form.BootstrapForm;
import com.helger.photon.bootstrap4.form.BootstrapFormGroup;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.RequestFieldBoolean;
import com.helger.photon.uicore.html.formlabel.ELabelType;
import com.helger.photon.uicore.html.formlabel.HCFormLabelHelper;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public class BasePageSettingsHTML<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    private static final String FIELD_FORMAT_HTML = "formathtml";
    private static final String FIELD_FORMAT_CSS = "formatcss";
    private static final String FIELD_FORMAT_JS = "formatjs";
    private static final String FIELD_CONSISTENCY_CHECKS_ENABLED = "consistencychecks";
    private static final String FIELD_EXTRACT_OUT_OF_BAND_NODES = "extractoobnodes";
    private static final String FIELD_AUTO_COMPLETE_FOR_PASSWORD_EDITS = "autocompletepw";
    private static final String FIELD_OUT_OF_BAND_DEBUG = "oobdebug";
    private static final String FIELD_SCRIPTS_IN_BODY = "scriptsinbody";
    private static final String FIELD_USE_REGULAR_RESOURCES = "useregular";
    private static final String FIELD_USE_NONCE_SCRIPT = "noncescript";
    private static final String FIELD_USE_NONCE_STYLE = "noncestyle";

    public BasePageSettingsHTML(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SETTINGS_HTML.getAsMLT());
    }

    public BasePageSettingsHTML(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageSettingsHTML(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageSettingsHTML(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        IHCConversionSettings iHCConversionSettings = HCSettings.getConversionSettings();
        boolean bl = WPECTYPE.hasAction("save");
        if (bl) {
            boolean bl2 = WPECTYPE.params().isCheckBoxChecked(FIELD_FORMAT_HTML, iHCConversionSettings.getXMLWriterSettings().getIndent().isIndent());
            boolean bl3 = WPECTYPE.params().isCheckBoxChecked(FIELD_FORMAT_CSS, !iHCConversionSettings.getCSSWriterSettings().isOptimizedOutput());
            boolean bl4 = WPECTYPE.params().isCheckBoxChecked(FIELD_FORMAT_JS, iHCConversionSettings.getJSWriterSettings().isIndentAndAlign());
            boolean bl5 = WPECTYPE.params().isCheckBoxChecked(FIELD_CONSISTENCY_CHECKS_ENABLED, iHCConversionSettings.areConsistencyChecksEnabled());
            boolean bl6 = WPECTYPE.params().isCheckBoxChecked(FIELD_EXTRACT_OUT_OF_BAND_NODES, iHCConversionSettings.isExtractOutOfBandNodes());
            boolean bl7 = WPECTYPE.params().isCheckBoxChecked(FIELD_AUTO_COMPLETE_FOR_PASSWORD_EDITS, !HCSettings.isAutoCompleteOffForPasswordEdits());
            boolean bl8 = WPECTYPE.params().isCheckBoxChecked(FIELD_OUT_OF_BAND_DEBUG, HCSettings.isOutOfBandDebuggingEnabled());
            boolean bl9 = WPECTYPE.params().isCheckBoxChecked(FIELD_SCRIPTS_IN_BODY, HCSettings.isScriptsInBody());
            boolean bl10 = WPECTYPE.params().isCheckBoxChecked(FIELD_USE_REGULAR_RESOURCES, HCSettings.isUseRegularResources());
            boolean bl11 = WPECTYPE.params().isCheckBoxChecked(FIELD_USE_NONCE_SCRIPT, HCSettings.isUseNonceInScript());
            boolean bl12 = WPECTYPE.params().isCheckBoxChecked(FIELD_USE_NONCE_STYLE, HCSettings.isUseNonceInStyle());
            HCSettings.getMutableConversionSettings().setXMLWriterSettingsOptimized(!bl2).setCSSWriterSettingsOptimized(!bl3).setJSWriterSettingsOptimized(!bl4).setConsistencyChecksEnabled(bl5).setExtractOutOfBandNodes(bl6);
            HCSettings.setAutoCompleteOffForPasswordEdits((!bl7 ? 1 : 0) != 0);
            HCSettings.setOutOfBandDebuggingEnabled((boolean)bl8);
            HCSettings.setScriptsInBody((boolean)bl9);
            HCSettings.setUseRegularResources((boolean)bl10);
            HCSettings.setUseNonceInScript((boolean)bl11);
            HCSettings.setUseNonceInStyle((boolean)bl12);
            WPECTYPE.postRedirectGetInternal((IHCNode)this.success(EText.MSG_CHANGE_SUCCESS.getDisplayText(locale)));
        } else {
            BootstrapForm bootstrapForm = (BootstrapForm)hCNodeList.addAndReturnChild((IHCNode)this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE, bl));
            bootstrapForm.setLeft(3);
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_HTML_VERSION.getDisplayText(locale)).setCtrl(iHCConversionSettings.getHTMLVersion().name()));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelForCheckBox(EText.MSG_FORMAT_HTML.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_FORMAT_HTML, iHCConversionSettings.getXMLWriterSettings().getIndent().isIndent()))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelForCheckBox(EText.MSG_FORMAT_CSS.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_FORMAT_CSS, !iHCConversionSettings.getCSSWriterSettings().isOptimizedOutput()))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelForCheckBox(EText.MSG_FORMAT_JS.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_FORMAT_JS, iHCConversionSettings.getJSWriterSettings().isIndentAndAlign()))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelForCheckBox(EText.MSG_CONSISTENCY_CHECKS_ENABLED.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_CONSISTENCY_CHECKS_ENABLED, iHCConversionSettings.areConsistencyChecksEnabled()))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelForCheckBox(EText.MSG_EXTRACT_OUT_OF_BAND_NODES.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_EXTRACT_OUT_OF_BAND_NODES, iHCConversionSettings.isExtractOutOfBandNodes()))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelForCheckBox(EText.MSG_AUTO_COMPLETE_FOR_PASSWORD_EDITS.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_AUTO_COMPLETE_FOR_PASSWORD_EDITS, !HCSettings.isAutoCompleteOffForPasswordEdits()))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_ON_DOCUMENT_READY_PROVIDER.getDisplayText(locale)).setCtrl(String.valueOf(HCSettings.getOnDocumentReadyProvider())));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCRIPT_INLINE_MODE.getDisplayText(locale)).setCtrl(HCSettings.getScriptInlineMode().name()));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_STYLE_INLINE_MODE.getDisplayText(locale)).setCtrl(HCSettings.getStyleInlineMode().name()));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_NEW_LINE_MODE.getDisplayText(locale)).setCtrl(HCSettings.getNewLineMode().name()));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelForCheckBox(EText.MSG_OUT_OF_BAND_DEBUGGING.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_OUT_OF_BAND_DEBUG, HCSettings.isOutOfBandDebuggingEnabled()))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelForCheckBox(EText.MSG_SCRIPTS_IN_BODY.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_SCRIPTS_IN_BODY, HCSettings.isScriptsInBody()))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelForCheckBox(EText.MSG_USE_REGULAR_RESOURCES.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_USE_REGULAR_RESOURCES, HCSettings.isUseRegularResources()))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelForCheckBox(EText.MSG_USE_NONCE_SCRIPT.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_USE_NONCE_SCRIPT, HCSettings.isUseNonceInScript()))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelForCheckBox(EText.MSG_USE_NONCE_STYLE.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_USE_NONCE_STYLE, HCSettings.isUseNonceInStyle()))));
            BootstrapButtonToolbar bootstrapButtonToolbar = string -> StringHelper.isEmpty((String)string) ? this.em(EText.MSG_NONE.getDisplayText(locale)) : this.code((String)string);
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_FORM_LABEL_SUFFIX_OPTIONAL.getDisplayText(locale)).setCtrl(bootstrapButtonToolbar.apply((String)HCFormLabelHelper.getSuffixString((ELabelType)ELabelType.OPTIONAL))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_FORM_LABEL_SUFFIX_ALTERNATIVE.getDisplayText(locale)).setCtrl(bootstrapButtonToolbar.apply((String)HCFormLabelHelper.getSuffixString((ELabelType)ELabelType.ALTERNATIVE))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_FORM_LABEL_SUFFIX_MANDATORY.getDisplayText(locale)).setCtrl(bootstrapButtonToolbar.apply((String)HCFormLabelHelper.getSuffixString((ELabelType)ELabelType.MANDATORY))));
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_FORM_LABEL_END.getDisplayText(locale)).setCtrl(bootstrapButtonToolbar.apply((String)HCFormLabelHelper.getDefaultLabelEnd())));
            bootstrapButtonToolbar = (BootstrapButtonToolbar)bootstrapForm.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
            bootstrapButtonToolbar.addHiddenField("action", "save");
            bootstrapButtonToolbar.addSubmitButtonSave(locale);
            bootstrapButtonToolbar.addButton(EText.MSG_BUTTON_WEBRESBUNDLE.getDisplayText(locale), (ISimpleURL)WPECTYPE.getLinkToMenuItem("admin_appinfo_webresbundle"));
        }
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_HTML_VERSION("HTML-Version", "HTML version"),
        MSG_FORMAT_HTML("HTML formatieren?", "Format HTML?"),
        MSG_FORMAT_CSS("CSS formatieren?", "Format CSS?"),
        MSG_FORMAT_JS("JS formatieren?", "Format JS?"),
        MSG_CONSISTENCY_CHECKS_ENABLED("Konsistenzpr\u00fcfungen aktiv?", "Consistency checks enabled?"),
        MSG_EXTRACT_OUT_OF_BAND_NODES("Out-of-band Knoten extrahieren?", "Extract out-of-band nodes?"),
        MSG_AUTO_COMPLETE_FOR_PASSWORD_EDITS("Auto-Vervollst\u00e4ndigung f\u00fcr Passwort-Felder?", "Auto complete for password fields?"),
        MSG_ON_DOCUMENT_READY_PROVIDER("JavaScript document.ready Ersteller", "JavaScript document.ready provider"),
        MSG_SCRIPT_INLINE_MODE("<script> Modus", "<script> mode"),
        MSG_STYLE_INLINE_MODE("<style> Modus", "<style> mode"),
        MSG_NEW_LINE_MODE("Zeilenumbruch", "New line"),
        MSG_OUT_OF_BAND_DEBUGGING("Out-of-band Knoten debuggen?", "Debug out-of-band nodes?"),
        MSG_SCRIPTS_IN_BODY("<script>-Element in <body>?", "Put <script> elements in <body>?"),
        MSG_USE_REGULAR_RESOURCES("Nicht-optimierte JS/CSS inkludieren?", "Include non-minified JS/CSS?"),
        MSG_USE_NONCE_SCRIPT("'nonce'-Attribut von <script> setzen?", "Set 'nonce' attribute of <script> elements?"),
        MSG_USE_NONCE_STYLE("'nonce'-Attribut von <style> setzen?", "Set 'nonce' attribute of <style> elements?"),
        MSG_NONE("keines", "none"),
        MSG_FORM_LABEL_SUFFIX_OPTIONAL("Formular Label Suffix f\u00fcr optionale Felder", "Form label suffix for optional fields"),
        MSG_FORM_LABEL_SUFFIX_ALTERNATIVE("Formular Label Suffix f\u00fcr alternative Felder", "Form label suffix for alternative fields"),
        MSG_FORM_LABEL_SUFFIX_MANDATORY("Formular Label Suffix f\u00fcr Pflichtfelder", "Form label suffix for mandatory fields"),
        MSG_FORM_LABEL_END("Formular Label Abschluss", "Form label end"),
        MSG_BUTTON_WEBRESBUNDLE("ResourceBundle Einstellungen", "ResourceBundle settings"),
        MSG_CHANGE_SUCCESS("Die Einstellungen wurden erfolgreich gespeichert.", "Changes were changed successfully.");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

