/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.security;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.compare.ESortOrder;
import com.helger.base.id.IHasID;
import com.helger.base.name.IHasDisplayName;
import com.helger.base.name.IHasName;
import com.helger.base.string.StringHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.collection.helper.CollectionHelperExt;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.forms.HCEdit;
import com.helger.html.hc.html.tabular.HCCol;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.request.IHCRequestField;
import com.helger.photon.bootstrap4.buttongroup.BootstrapButtonToolbar;
import com.helger.photon.bootstrap4.form.BootstrapForm;
import com.helger.photon.bootstrap4.form.BootstrapFormGroup;
import com.helger.photon.bootstrap4.form.BootstrapViewForm;
import com.helger.photon.bootstrap4.nav.BootstrapTabBox;
import com.helger.photon.bootstrap4.pages.handler.AbstractBootstrapWebPageActionHandlerDelete;
import com.helger.photon.bootstrap4.pages.handler.AbstractBootstrapWebPageActionHandlerUndelete;
import com.helger.photon.bootstrap4.pages.security.AbstractWebPageSecurityObjectWithAttributes;
import com.helger.photon.bootstrap4.table.BootstrapTable;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDTColAction;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.core.form.RequestField;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.role.IRoleManager;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.security.usergroup.IUserGroup;
import com.helger.photon.security.usergroup.IUserGroupManager;
import com.helger.photon.uicore.html.select.HCRoleForUserGroupSelect;
import com.helger.photon.uicore.page.EWebPageFormAction;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.handler.IWebPageActionHandler;
import com.helger.photon.uictrls.autosize.HCTextAreaAutosize;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.compare.ComparatorHelper;
import com.helger.text.display.IHasDisplayTextWithArgs;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import com.helger.typeconvert.collection.IStringMap;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class BasePageSecurityUserGroupManagement<WPECTYPE extends IWebPageExecutionContext>
extends AbstractWebPageSecurityObjectWithAttributes<IUserGroup, WPECTYPE> {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_ROLES = "roles";

    private void _init() {
        this.setDeleteHandler((IWebPageActionHandler)new AbstractBootstrapWebPageActionHandlerDelete<IUserGroup, WPECTYPE>(){

            protected void showQuery(@Nonnull WPECTYPE WPECTYPE, @Nonnull BootstrapForm bootstrapForm, @Nullable IUserGroup iUserGroup) {
                Locale locale = WPECTYPE.getDisplayLocale();
                bootstrapForm.addChild((IHCNode)BasePageSecurityUserGroupManagement.this.question(EText.DELETE_QUERY.getDisplayTextWithArgs(locale, new Object[]{iUserGroup.getName()})));
            }

            protected void performAction(@Nonnull WPECTYPE WPECTYPE, @Nullable IUserGroup iUserGroup) {
                Locale locale = WPECTYPE.getDisplayLocale();
                IUserGroupManager iUserGroupManager = PhotonSecurityManager.getUserGroupMgr();
                if (iUserGroupManager.deleteUserGroup((String)iUserGroup.getID()).isChanged()) {
                    WPECTYPE.postRedirectGetInternal((IHCNode)BasePageSecurityUserGroupManagement.this.success(EText.DELETE_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{iUserGroup.getName()})));
                } else {
                    WPECTYPE.postRedirectGetInternal((IHCNode)BasePageSecurityUserGroupManagement.this.error(EText.DELETE_ERROR.getDisplayTextWithArgs(locale, new Object[]{iUserGroup.getName()})));
                }
            }
        });
        this.setUndeleteHandler((IWebPageActionHandler)new AbstractBootstrapWebPageActionHandlerUndelete<IUserGroup, WPECTYPE>(){

            protected void showQuery(@Nonnull WPECTYPE WPECTYPE, @Nonnull BootstrapForm bootstrapForm, @Nullable IUserGroup iUserGroup) {
                Locale locale = WPECTYPE.getDisplayLocale();
                bootstrapForm.addChild((IHCNode)BasePageSecurityUserGroupManagement.this.question(EText.UNDELETE_QUERY.getDisplayTextWithArgs(locale, new Object[]{iUserGroup.getName()})));
            }

            protected void performAction(@Nonnull WPECTYPE WPECTYPE, @Nullable IUserGroup iUserGroup) {
                Locale locale = WPECTYPE.getDisplayLocale();
                IUserGroupManager iUserGroupManager = PhotonSecurityManager.getUserGroupMgr();
                if (iUserGroupManager.undeleteUserGroup((String)iUserGroup.getID()).isChanged()) {
                    WPECTYPE.postRedirectGetInternal((IHCNode)BasePageSecurityUserGroupManagement.this.success(EText.UNDELETE_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{iUserGroup.getName()})));
                } else {
                    WPECTYPE.postRedirectGetInternal((IHCNode)BasePageSecurityUserGroupManagement.this.error(EText.UNDELETE_ERROR.getDisplayTextWithArgs(locale, new Object[]{iUserGroup.getName()})));
                }
            }
        });
    }

    public BasePageSecurityUserGroupManagement(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SECURITY_USER_GROUPS.getAsMLT());
        this._init();
    }

    public BasePageSecurityUserGroupManagement(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
        this._init();
    }

    public BasePageSecurityUserGroupManagement(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
        this._init();
    }

    public BasePageSecurityUserGroupManagement(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
        this._init();
    }

    @Nullable
    protected String getObjectDisplayName(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUserGroup iUserGroup) {
        return iUserGroup.getName();
    }

    protected boolean isActionAllowed(@Nonnull WPECTYPE WPECTYPE, @Nonnull EWebPageFormAction eWebPageFormAction, @Nullable IUserGroup iUserGroup) {
        if (eWebPageFormAction.isDelete()) {
            return BasePageSecurityUserGroupManagement.canDeleteUserGroup(iUserGroup);
        }
        if (eWebPageFormAction.isUndelete()) {
            return BasePageSecurityUserGroupManagement.canUndeleteUserGroup(iUserGroup);
        }
        return true;
    }

    @Nullable
    protected IUserGroup getSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nullable String string) {
        IUserGroupManager iUserGroupManager = PhotonSecurityManager.getUserGroupMgr();
        return iUserGroupManager.getUserGroupOfID(string);
    }

    protected void showSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUserGroup iUserGroup) {
        HCNodeList hCNodeList;
        ICommonsSet<String> iCommonsSet;
        CommonsArrayList commonsArrayList;
        IUserManager iUserManager;
        ICommonsSet iCommonsSet2;
        HCNodeList hCNodeList2 = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        hCNodeList2.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.HEADER_DETAILS.getDisplayTextWithArgs(locale, new Object[]{iUserGroup.getName()})));
        BootstrapViewForm bootstrapViewForm = (BootstrapViewForm)hCNodeList2.addAndReturnChild((IHCNode)new BootstrapViewForm());
        this.onShowSelectedObjectTableStart(WPECTYPE, bootstrapViewForm, iUserGroup);
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_NAME.getDisplayText(locale)).setCtrl(iUserGroup.getName()));
        if (iUserGroup.hasDescription()) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_DESCRIPTION.getDisplayText(locale)).setCtrl((Iterable)HCExtHelper.nl2divList((String)iUserGroup.getDescription())));
        }
        if ((iCommonsSet2 = iUserGroup.getAllContainedUserIDs()).isEmpty()) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_USERS_0.getDisplayText(locale)).setCtrl((IHCNode)this.em(EText.NONE_ASSIGNED.getDisplayText(locale))));
        } else {
            iUserManager = PhotonSecurityManager.getUserMgr();
            commonsArrayList = new CommonsArrayList((Collection)iCommonsSet2, arg_0 -> ((IUserManager)iUserManager).getUserOfID(arg_0));
            iCommonsSet = new ICommonsSet<String>();
            commonsArrayList.getSortedInline(ComparatorHelper.getComparatorCollating(IHasDisplayName::getDisplayName, (Locale)locale)).forEach(arg_0 -> this.lambda$showSelectedObject$0((HCNodeList)iCommonsSet, WPECTYPE, arg_0));
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_USERS_N.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(iCommonsSet2.size())})).setCtrl((IHCNode)iCommonsSet));
        }
        iUserManager = iUserGroup.getAllContainedRoleIDs();
        if (iUserManager.isEmpty()) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_ROLES_0.getDisplayText(locale)).setCtrl((IHCNode)this.em(EText.NONE_ASSIGNED.getDisplayText(locale))));
        } else {
            commonsArrayList = PhotonSecurityManager.getRoleMgr();
            iCommonsSet = new CommonsArrayList((Collection)iUserManager, arg_0 -> ((IRoleManager)commonsArrayList).getRoleOfID(arg_0));
            hCNodeList = new HCNodeList();
            iCommonsSet.getSortedInline(ComparatorHelper.getComparatorCollating(IHasName::getName, (Locale)locale)).forEach(iRole -> hCNodeList.addChild((IHCNode)this.div((IHCNode)new HCA((ISimpleURL)BasePageSecurityUserGroupManagement.createViewURL((ILayoutExecutionContext)WPECTYPE, (String)"admin_security_role", (String)((String)iRole.getID()), null)).addChild(iRole.getName()))));
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_ROLES_N.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(iUserManager.size())})).setCtrl((IHCNode)hCNodeList));
        }
        commonsArrayList = iUserGroup.attrs();
        iCommonsSet = this.onShowSelectedObjectCustomAttrs(WPECTYPE, iUserGroup, (Map<String, String>)commonsArrayList, bootstrapViewForm);
        if (commonsArrayList.isNotEmpty()) {
            hCNodeList = new BootstrapTable(new IHCCol[]{new HCCol(170), HCCol.star()});
            hCNodeList.addHeaderRow().addCells(new String[]{EText.HEADER_NAME.getDisplayText(locale), EText.HEADER_VALUE.getDisplayText(locale)});
            for (Map.Entry entry : commonsArrayList.entrySet()) {
                String string = (String)entry.getKey();
                if (iCommonsSet != null && iCommonsSet.contains((Object)string)) continue;
                String string2 = (String)entry.getValue();
                hCNodeList.addBodyRow().addCells(new String[]{string, string2});
            }
            if (hCNodeList.hasBodyRows()) {
                bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_ATTRIBUTES.getDisplayText(locale)).setCtrl((IHCNode)hCNodeList));
            }
        }
        this.onShowSelectedObjectTableEnd(WPECTYPE, bootstrapViewForm, iUserGroup);
    }

    protected void validateAndSaveInputParameters(@Nonnull WPECTYPE WPECTYPE, @Nullable IUserGroup iUserGroup, @Nonnull FormErrorList formErrorList, @Nonnull EWebPageFormAction eWebPageFormAction) {
        Locale locale = WPECTYPE.getDisplayLocale();
        String string = WPECTYPE.params().getAsString((Object)FIELD_NAME);
        String string2 = WPECTYPE.params().getAsString((Object)FIELD_DESCRIPTION);
        ICommonsList iCommonsList = WPECTYPE.params().getAsStringList((Object)FIELD_ROLES);
        IRoleManager iRoleManager = PhotonSecurityManager.getRoleMgr();
        IUserGroupManager iUserGroupManager = PhotonSecurityManager.getUserGroupMgr();
        if (StringHelper.isEmpty((String)string)) {
            formErrorList.addFieldError(FIELD_NAME, EText.ERROR_NAME_REQUIRED.getDisplayText(locale));
        }
        if (CollectionHelper.isEmpty((Collection)iCommonsList)) {
            formErrorList.addFieldError(FIELD_ROLES, EText.ERROR_NO_ROLE.getDisplayText(locale));
        } else if (!iRoleManager.containsAllIDs((Iterable)iCommonsList)) {
            formErrorList.addFieldError(FIELD_ROLES, EText.ERROR_INVALID_ROLES.getDisplayText(locale));
        }
        ICommonsMap<String, String> iCommonsMap = this.validateCustomInputParameters(WPECTYPE, iUserGroup, formErrorList, eWebPageFormAction);
        if (formErrorList.isEmpty()) {
            if (eWebPageFormAction.isEdit()) {
                Object object2;
                String string3 = (String)iUserGroup.getID();
                IStringMap iStringMap = iUserGroup.attrs();
                if (iCommonsMap != null) {
                    iStringMap.putAll(iCommonsMap);
                }
                iUserGroupManager.setUserGroupData(string3, string, string2, (Map)iStringMap);
                ICommonsSet iCommonsSet = iUserGroup.getAllContainedRoleIDs();
                ICommonsSet iCommonsSet2 = CollectionHelperExt.getDifference((Collection)iCommonsList, (Collection)iCommonsSet);
                for (Object object2 : iCommonsSet2) {
                    iUserGroupManager.assignRoleToUserGroup(string3, (String)object2);
                }
                Iterator iterator = CollectionHelperExt.getDifference((Collection)iCommonsSet, (Collection)iCommonsList);
                object2 = iterator.iterator();
                while (object2.hasNext()) {
                    String string4 = (String)object2.next();
                    iUserGroupManager.unassignRoleFromUserGroup(string3, string4);
                }
                WPECTYPE.postRedirectGetInternal((IHCNode)this.success(EText.SUCCESS_EDIT.getDisplayText(locale)));
            } else {
                IUserGroup iUserGroup2 = iUserGroupManager.createNewUserGroup(string, string2, iCommonsMap);
                if (iUserGroup2 == null) {
                    WPECTYPE.postRedirectGetInternal((IHCNode)this.error(EText.ERROR_CREATE.getDisplayText(locale)));
                } else {
                    for (String string5 : iCommonsList) {
                        iUserGroupManager.assignRoleToUserGroup((String)iUserGroup2.getID(), string5);
                    }
                    WPECTYPE.postRedirectGetInternal((IHCNode)this.success(EText.SUCCESS_CREATE.getDisplayText(locale)));
                }
            }
        }
    }

    protected void showInputForm(@Nonnull WPECTYPE WPECTYPE, @Nullable IUserGroup iUserGroup, @Nonnull BootstrapForm bootstrapForm, boolean bl, @Nonnull EWebPageFormAction eWebPageFormAction, @Nonnull FormErrorList formErrorList) {
        Locale locale = WPECTYPE.getDisplayLocale();
        bootstrapForm.addChild((IHCNode)this.getUIHandler().createActionHeader(eWebPageFormAction.isEdit() ? EText.TITLE_EDIT.getDisplayTextWithArgs(locale, new Object[]{iUserGroup.getName()}) : EText.TITLE_CREATE.getDisplayText(locale)));
        String string = EText.LABEL_NAME.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelMandatory(string).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(FIELD_NAME, iUserGroup == null ? null : iUserGroup.getName())).setPlaceholder(string)).setErrorList(formErrorList.getListOfField(FIELD_NAME)));
        string = EText.LABEL_DESCRIPTION.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string).setCtrl((IHCNode)new HCTextAreaAutosize((IHCRequestField)new RequestField(FIELD_DESCRIPTION, iUserGroup == null ? null : iUserGroup.getDescription())).setPlaceholder(string)).setErrorList(formErrorList.getListOfField(FIELD_DESCRIPTION)));
        string = iUserGroup == null ? WPECTYPE.params().getAsStringList((Object)FIELD_ROLES) : iUserGroup.getAllContainedRoleIDs();
        HCRoleForUserGroupSelect hCRoleForUserGroupSelect = new HCRoleForUserGroupSelect(new RequestField(FIELD_ROLES), (Collection)((Object)string));
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelMandatory(EText.LABEL_ROLES_0.getDisplayText(locale)).setCtrl((IHCNode)hCRoleForUserGroupSelect).setErrorList(formErrorList.getListOfField(FIELD_ROLES)));
        this.onShowInputFormEnd(WPECTYPE, iUserGroup, bootstrapForm, eWebPageFormAction, formErrorList);
    }

    protected static boolean canDeleteUserGroup(@Nullable IUserGroup iUserGroup) {
        return iUserGroup != null && !iUserGroup.isDeleted() && !iUserGroup.hasContainedUsers() && !((String)iUserGroup.getID()).equals("ugadmin");
    }

    protected static boolean canUndeleteUserGroup(@Nullable IUserGroup iUserGroup) {
        return iUserGroup != null && iUserGroup.isDeleted();
    }

    @Nonnull
    protected IHCNode getTabWithUserGroups(@Nonnull WPECTYPE WPECTYPE, @Nonnull ICommonsList<IUserGroup> iCommonsList, @Nonnull @Nonempty String string) {
        Locale locale = WPECTYPE.getDisplayLocale();
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol().setVisible(false), new DTCol(EText.HEADER_NAME.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.HEADER_IN_USE.getDisplayText(locale)), new BootstrapDTColAction(locale)}).setID(string);
        for (IUserGroup iUserGroup : iCommonsList) {
            SimpleURL simpleURL = BasePageSecurityUserGroupManagement.createViewURL(WPECTYPE, (IHasID)iUserGroup);
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell((String)iUserGroup.getID());
            hCRow.addCell((IHCNode)new HCA((ISimpleURL)simpleURL).addChild(iUserGroup.getName()));
            hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)iUserGroup.hasContainedUsers(), (Locale)locale));
            IHCCell iHCCell = hCRow.addCell();
            iHCCell.addChild((IHCNode)BasePageSecurityUserGroupManagement.createEditLink(WPECTYPE, (IHasID)iUserGroup, (String)EWebPageText.OBJECT_EDIT.getDisplayTextWithArgs(locale, new Object[]{iUserGroup.getName()})));
            iHCCell.addChild(" ");
            if (BasePageSecurityUserGroupManagement.canDeleteUserGroup(iUserGroup)) {
                iHCCell.addChild((IHCNode)BasePageSecurityUserGroupManagement.createDeleteLink(WPECTYPE, (IHasID)iUserGroup, (String)EWebPageText.OBJECT_DELETE.getDisplayTextWithArgs(locale, new Object[]{iUserGroup.getName()})));
            } else {
                iHCCell.addChild((IHCNode)BasePageSecurityUserGroupManagement.createEmptyAction());
            }
            iHCCell.addChild(" ");
            if (BasePageSecurityUserGroupManagement.canUndeleteUserGroup(iUserGroup)) {
                iHCCell.addChild((IHCNode)BasePageSecurityUserGroupManagement.createUndeleteLink(WPECTYPE, (IHasID)iUserGroup, (String)EWebPageText.OBJECT_UNDELETE.getDisplayTextWithArgs(locale, new Object[]{iUserGroup.getName()})));
                continue;
            }
            iHCCell.addChild((IHCNode)BasePageSecurityUserGroupManagement.createEmptyAction());
        }
        Iterator iterator = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        return ((HCNodeList)new HCNodeList().addChild((IHCNode)hCTable)).addChild((IHCNode)iterator);
    }

    protected void showListOfExistingObjects(@Nonnull WPECTYPE WPECTYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        IUserGroupManager iUserGroupManager = PhotonSecurityManager.getUserGroupMgr();
        BootstrapButtonToolbar bootstrapButtonToolbar = (BootstrapButtonToolbar)hCNodeList.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
        bootstrapButtonToolbar.addButtonNew(EText.BUTTON_CREATE_NEW_USERGROUP.getDisplayText(locale), (ISimpleURL)BasePageSecurityUserGroupManagement.createCreateURL(WPECTYPE));
        BootstrapTabBox bootstrapTabBox = new BootstrapTabBox();
        ICommonsList iCommonsList = iUserGroupManager.getAllActiveUserGroups();
        bootstrapTabBox.addTab("active", EText.TAB_ACTIVE.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(iCommonsList.size())}), this.getTabWithUserGroups(WPECTYPE, (ICommonsList<IUserGroup>)iCommonsList, this.getID() + "1"));
        ICommonsList iCommonsList2 = iUserGroupManager.getAllDeletedUserGroups();
        bootstrapTabBox.addTab("deleted", EText.TAB_DELETED.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(iCommonsList2.size())}), this.getTabWithUserGroups(WPECTYPE, (ICommonsList<IUserGroup>)iCommonsList2, this.getID() + "2"));
        hCNodeList.addChild((IHCNode)bootstrapTabBox);
    }

    private /* synthetic */ void lambda$showSelectedObject$0(HCNodeList hCNodeList, IWebPageExecutionContext iWebPageExecutionContext, IUser iUser) {
        hCNodeList.addChild((IHCNode)this.div((IHCNode)new HCA((ISimpleURL)BasePageSecurityUserGroupManagement.createViewURL((ILayoutExecutionContext)iWebPageExecutionContext, (String)"admin_security_user", (String)((String)iUser.getID()), null)).addChild(iUser.getDisplayName())));
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        BUTTON_CREATE_NEW_USERGROUP("Neue Benutzergruppe anlegen", "Create new user group"),
        TAB_ACTIVE("Aktive Benutzergruppen ({0})", "Active user groups ({0})"),
        TAB_DELETED("Gel\u00f6schte Benutzergruppen ({0})", "Deleted user groups ({0})"),
        HEADER_NAME("Name", "Name"),
        HEADER_IN_USE("Verwendet?", "In use?"),
        HEADER_VALUE("Wert", "Value"),
        HEADER_DETAILS("Details von Benutzergruppe {0}", "Details of user group {0}"),
        LABEL_NAME("Name", "Name"),
        LABEL_DESCRIPTION("Beschreibung", "Description"),
        LABEL_USERS_0("Benutzer", "Users"),
        LABEL_USERS_N("Benutzer ({0})", "Users ({0})"),
        LABEL_ROLES_0("Rollen", "Roles"),
        LABEL_ROLES_N("Rollen ({0})", "Roles ({0})"),
        LABEL_ATTRIBUTES("Attribute", "Attributes"),
        NONE_ASSIGNED("keine zugeordnet", "none assigned"),
        TITLE_CREATE("Neue Benutzergruppe anlegen", "Create new user group"),
        TITLE_EDIT("Benutzergruppe ''{0}'' bearbeiten", "Edit user group ''{0}''"),
        ERROR_NAME_REQUIRED("Es muss ein Name angegeben werden!", "A name must be specified!"),
        ERROR_NO_ROLE("Es muss mindestens eine Rolle ausgew\u00e4hlt werden!", "At least one role must be selected!"),
        ERROR_INVALID_ROLES("Mindestens eine der angegebenen Rolle ist ung\u00fcltig!", "At least one selected role is invalid!"),
        DELETE_QUERY("Soll die Benutzergruppe ''{0}'' wirklich gel\u00f6scht werden?", "Are you sure to delete the user group ''{0}''?"),
        DELETE_SUCCESS("Die Benutzergruppe ''{0}'' wurden erfolgreich gel\u00f6scht!", "The user group ''{0}'' was successfully deleted!"),
        DELETE_ERROR("Fehler beim L\u00f6schen der Benutzergruppe ''{0}''!", "Error deleting the user group ''{0}''!"),
        UNDELETE_QUERY("Sind Sie sicher, dass Sie die Benutzergruppe ''{0}'' wiederherstellen wollen?", "Are you sure you want to undelete user group ''{0}''?"),
        UNDELETE_SUCCESS("Die Benutzergruppe ''{0}'' wurde erfolgreich wiederhergestellt!", "User group ''{0}'' was successfully undeleted!"),
        UNDELETE_ERROR("Beim Wiederherstellen der Benutzergruppe ''{0}'' ist ein Fehler aufgetreten!", "An error occurred while undeleting user group ''{0}''!"),
        ERROR_CREATE("Die neue BenutzerGruppe konnte nicht angelegt werden!", "Failed to create the new user group!"),
        SUCCESS_CREATE("Die neue BenutzerGruppe wurde erfolgreich angelegt!", "Successfully created the new user group!"),
        SUCCESS_EDIT("Die Benutzergruppe wurde erfolgreich bearbeitet!", "Successfully edited the user group!");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

