/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.monitoring;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.CGlobal;
import com.helger.base.compare.ESortOrder;
import com.helger.base.numeric.BigHelper;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.web.PDTWebDateHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.ajax.decl.AjaxFunctionDeclaration;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.bootstrap4.buttongroup.BootstrapButtonToolbar;
import com.helger.photon.bootstrap4.nav.BootstrapTabBox;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.statistics.api.IStatisticsHandlerCache;
import com.helger.statistics.api.IStatisticsHandlerCounter;
import com.helger.statistics.api.IStatisticsHandlerKeyedCounter;
import com.helger.statistics.api.IStatisticsHandlerKeyedSize;
import com.helger.statistics.api.IStatisticsHandlerKeyedTimer;
import com.helger.statistics.api.IStatisticsHandlerSize;
import com.helger.statistics.api.IStatisticsHandlerTimer;
import com.helger.statistics.visit.IStatisticsVisitorCallback;
import com.helger.statistics.visit.StatisticsVisitor;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import com.helger.url.ISimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.util.statistics.StatisticsExporter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePageMonitoringStatistics<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePageMonitoringStatistics.class);
    private static final AjaxFunctionDeclaration AJAX_SAVE_STATS = BasePageMonitoringStatistics.addAjax((IAjaxExecutor & Serializable)(iRequestWebScopeWithoutResponse, photonUnifiedResponse) -> {
        LOGGER.info("Downloading ph-oton statistics");
        IMicroDocument iMicroDocument = StatisticsExporter.getAsXMLDocument();
        iMicroDocument.getDocumentElement().setAttribute("location", "user-interface");
        iMicroDocument.getDocumentElement().setAttribute("datetime", PDTWebDateHelper.getAsStringXSD((LocalDateTime)PDTFactory.getCurrentLocalDateTime()));
        photonUnifiedResponse.xml((IMicroNode)iMicroDocument).setContentDispositionFilename("ph-oton-statistics.xml").disableCaching();
    });

    public BasePageMonitoringStatistics(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_MONITORING_STATISTICS.getAsMLT());
    }

    public BasePageMonitoringStatistics(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
    }

    public BasePageMonitoringStatistics(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageMonitoringStatistics(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse = WPECTYPE.getRequestScope();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_DOWNLOAD.getDisplayText(locale), (ISimpleURL)AJAX_SAVE_STATS.getInvocationURL(iRequestWebScopeWithoutResponse), (IIcon)EDefaultIcon.SAVE);
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        final HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)).setDataSort(new int[]{0, 1}), new DTCol(EText.MSG_KEY.getDisplayText(locale)), new DTCol(EText.MSG_INVOCATION.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_TIMER_MIN.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_TIMER_MAX.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_TIMER_AVG.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_TIMER_SUM.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale).setInitialSorting(ESortOrder.DESCENDING)}).setID(this.getID() + "timer");
        final HCTable hCTable2 = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)).setDataSort(new int[]{0, 1}), new DTCol(EText.MSG_KEY.getDisplayText(locale)), new DTCol(EText.MSG_INVOCATION.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_MIN.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_MAX.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_AVG.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_SUM.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale)}).setID(this.getID() + "size");
        final HCTable hCTable3 = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)).setDataSort(new int[]{0, 1}), new DTCol(EText.MSG_KEY.getDisplayText(locale)), new DTCol(EText.MSG_INVOCATION.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_COUNT.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale)}).setID(this.getID() + "counter");
        final HCTable hCTable4 = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)), new DTCol(EText.MSG_INVOCATION.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_CACHE_HIT.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_CACHE_HIT_PERC.getDisplayText(locale)).setDisplayType(EDTColType.DOUBLE, locale), new DTCol(EText.MSG_CACHE_MISS.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale).setInitialSorting(ESortOrder.DESCENDING), new DTCol(EText.MSG_CACHE_MISS_PERC.getDisplayText(locale)).setDisplayType(EDTColType.DOUBLE, locale)}).setID(this.getID() + "cache");
        StatisticsVisitor.visitStatistics((IStatisticsVisitorCallback)new IStatisticsVisitorCallback(){

            public void onTimer(@Nonnull String string, @Nonnull IStatisticsHandlerTimer iStatisticsHandlerTimer) {
                if (iStatisticsHandlerTimer.getInvocationCount() > 0) {
                    hCTable.addBodyRow().addCells(new String[]{string, "", Integer.toString(iStatisticsHandlerTimer.getInvocationCount()), Long.toString(iStatisticsHandlerTimer.getMin()), Long.toString(iStatisticsHandlerTimer.getMax()), Long.toString(iStatisticsHandlerTimer.getAverage()), iStatisticsHandlerTimer.getSum().toString()});
                }
            }

            public void onSize(@Nonnull String string, @Nonnull IStatisticsHandlerSize iStatisticsHandlerSize) {
                if (iStatisticsHandlerSize.getInvocationCount() > 0) {
                    hCTable2.addBodyRow().addCells(new String[]{string, "", Integer.toString(iStatisticsHandlerSize.getInvocationCount()), Long.toString(iStatisticsHandlerSize.getMin()), Long.toString(iStatisticsHandlerSize.getMax()), Long.toString(iStatisticsHandlerSize.getAverage()), iStatisticsHandlerSize.getSum().toString()});
                }
            }

            public void onCounter(@Nonnull String string, @Nonnull IStatisticsHandlerCounter iStatisticsHandlerCounter) {
                if (iStatisticsHandlerCounter.getInvocationCount() > 0) {
                    hCTable3.addBodyRow().addCells(new String[]{string, "", Integer.toString(iStatisticsHandlerCounter.getInvocationCount()), Long.toString(iStatisticsHandlerCounter.getCount())});
                }
            }

            public void onCache(@Nonnull String string, @Nonnull IStatisticsHandlerCache iStatisticsHandlerCache) {
                if (iStatisticsHandlerCache.getInvocationCount() > 0) {
                    int n = iStatisticsHandlerCache.getInvocationCount();
                    int n2 = iStatisticsHandlerCache.getHits();
                    int n3 = iStatisticsHandlerCache.getMisses();
                    BigDecimal bigDecimal = BigHelper.getDividedBigDecimal((long)n2, (long)n, (int)4, (RoundingMode)RoundingMode.HALF_UP).multiply(CGlobal.BIGDEC_100).setScale(2);
                    BigDecimal bigDecimal2 = CGlobal.BIGDEC_100.subtract(bigDecimal);
                    hCTable4.addBodyRow().addCells(new String[]{string, Integer.toString(n), Integer.toString(n2), bigDecimal.toPlainString() + "%", Integer.toString(n3), bigDecimal2.toPlainString() + "%"});
                }
            }

            public void onKeyedTimer(@Nonnull String string, @Nonnull IStatisticsHandlerKeyedTimer iStatisticsHandlerKeyedTimer) {
                for (String string2 : iStatisticsHandlerKeyedTimer.getAllKeys()) {
                    int n = iStatisticsHandlerKeyedTimer.getInvocationCount(string2);
                    if (n <= 0) continue;
                    hCTable.addBodyRow().addCells(new String[]{string, string2, Integer.toString(n), Long.toString(iStatisticsHandlerKeyedTimer.getMin(string2)), Long.toString(iStatisticsHandlerKeyedTimer.getMax(string2)), Long.toString(iStatisticsHandlerKeyedTimer.getAverage(string2)), iStatisticsHandlerKeyedTimer.getSum(string2).toString()});
                }
            }

            public void onKeyedSize(@Nonnull String string, @Nonnull IStatisticsHandlerKeyedSize iStatisticsHandlerKeyedSize) {
                for (String string2 : iStatisticsHandlerKeyedSize.getAllKeys()) {
                    int n = iStatisticsHandlerKeyedSize.getInvocationCount(string2);
                    if (n <= 0) continue;
                    hCTable2.addBodyRow().addCells(new String[]{string, string2, Integer.toString(n), Long.toString(iStatisticsHandlerKeyedSize.getMin(string2)), Long.toString(iStatisticsHandlerKeyedSize.getMax(string2)), Long.toString(iStatisticsHandlerKeyedSize.getAverage(string2)), iStatisticsHandlerKeyedSize.getSum(string2).toString()});
                }
            }

            public void onKeyedCounter(@Nonnull String string, @Nonnull IStatisticsHandlerKeyedCounter iStatisticsHandlerKeyedCounter) {
                for (String string2 : iStatisticsHandlerKeyedCounter.getAllKeys()) {
                    int n = iStatisticsHandlerKeyedCounter.getInvocationCount(string2);
                    if (n <= 0) continue;
                    hCTable3.addBodyRow().addCells(new String[]{string, string2, Integer.toString(n), Long.toString(iStatisticsHandlerKeyedCounter.getCount(string2))});
                }
            }
        });
        BootstrapTabBox bootstrapTabBox = new BootstrapTabBox();
        HCNodeList hCNodeList2 = new HCNodeList();
        hCNodeList2.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList2.addChild((IHCNode)bootstrapDataTables);
        bootstrapTabBox.addTab("timer", EText.MSG_TAB_TIMER.getDisplayText(locale), (IHCNode)hCNodeList2);
        hCNodeList2 = new HCNodeList();
        hCNodeList2.addChild((IHCNode)hCTable2);
        bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable2);
        hCNodeList2.addChild((IHCNode)bootstrapDataTables);
        bootstrapTabBox.addTab("size", EText.MSG_TAB_SIZE.getDisplayText(locale), (IHCNode)hCNodeList2);
        hCNodeList2 = new HCNodeList();
        hCNodeList2.addChild((IHCNode)hCTable3);
        bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable3);
        hCNodeList2.addChild((IHCNode)bootstrapDataTables);
        bootstrapTabBox.addTab("counter", EText.MSG_TAB_COUNTER.getDisplayText(locale), (IHCNode)hCNodeList2);
        hCNodeList2 = new HCNodeList();
        hCNodeList2.addChild((IHCNode)hCTable4);
        bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable4);
        hCNodeList2.addChild((IHCNode)bootstrapDataTables);
        bootstrapTabBox.addTab("cache", EText.MSG_TAB_CACHE.getDisplayText(locale), (IHCNode)hCNodeList2);
        hCNodeList.addChild((IHCNode)bootstrapTabBox);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_TAB_TIMER("Zeiten", "Timer"),
        MSG_TAB_SIZE("Gr\u00f6\u00dfe", "Size"),
        MSG_TAB_COUNTER("Z\u00e4hler", "Counter"),
        MSG_TAB_CACHE("Cache", "Cache"),
        MSG_NAME("Name", "Name"),
        MSG_KEY("Schl\u00fcssel", "Key"),
        MSG_INVOCATION("Aufrufe", "Invocations"),
        MSG_TIMER_MIN("Minimum (ms)", "Minimum (ms)"),
        MSG_TIMER_MAX("Maximum (ms)", "Maximum (ms)"),
        MSG_TIMER_AVG("Durchschnitt (ms)", "Average (ms)"),
        MSG_TIMER_SUM("Summe (ms)", "Sum (ms)"),
        MSG_MIN("Minimum", "Minimum"),
        MSG_MAX("Maximum", "Maximum"),
        MSG_AVG("Durchschnitt", "Average"),
        MSG_SUM("Summe", "Sum"),
        MSG_COUNT("Anzahl", "Count"),
        MSG_CACHE_HIT("Cache hit", "Cache hit"),
        MSG_CACHE_HIT_PERC("Cache hit %", "Cache hit %"),
        MSG_CACHE_MISS("Cache miss", "Cache miss"),
        MSG_CACHE_MISS_PERC("Cache miss %", "Cache miss %");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

