/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.monitoring;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.compare.ESortOrder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.datetime.format.PDTToString;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap4.buttongroup.BootstrapButtonToolbar;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.security.lock.ILockInfo;
import com.helger.photon.security.lock.ILockManager;
import com.helger.photon.security.util.SecurityHelper;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Map;

public class BasePageMonitoringLockedObjects<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    private final ILockManager<String> m_aLockMgr;

    public BasePageMonitoringLockedObjects(@Nonnull @Nonempty String string, @Nonnull ILockManager<String> iLockManager) {
        super(string, EWebPageText.PAGE_NAME_MONITORING_LOCKED_OBJECTS.getAsMLT());
        this.m_aLockMgr = (ILockManager)ValueEnforcer.notNull(iLockManager, (String)"LockManager");
    }

    public BasePageMonitoringLockedObjects(@Nonnull @Nonempty String string, @Nonnull String string2, @Nonnull ILockManager<String> iLockManager) {
        super(string, string2);
        this.m_aLockMgr = (ILockManager)ValueEnforcer.notNull(iLockManager, (String)"LockManager");
    }

    public BasePageMonitoringLockedObjects(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3, @Nonnull ILockManager<String> iLockManager) {
        super(string, string2, string3);
        this.m_aLockMgr = (ILockManager)ValueEnforcer.notNull(iLockManager, (String)"LockManager");
    }

    public BasePageMonitoringLockedObjects(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2, @Nonnull ILockManager<String> iLockManager) {
        super(string, iMultilingualText, iMultilingualText2);
        this.m_aLockMgr = (ILockManager)ValueEnforcer.notNull(iLockManager, (String)"LockManager");
    }

    @Nonnull
    protected final ILockManager<String> getLockMgr() {
        return this.m_aLockMgr;
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_DATE.getDisplayText(locale)).setDisplayType(EDTColType.DATETIME, locale).setInitialSorting(ESortOrder.DESCENDING), new DTCol(EText.MSG_USER.getDisplayText(locale)), new DTCol(EText.MSG_OBJECTID.getDisplayText(locale))}).setID(this.getID());
        for (Map.Entry entry : this.m_aLockMgr.getAllLockInfos().entrySet()) {
            String string = (String)entry.getKey();
            ILockInfo iLockInfo = (ILockInfo)entry.getValue();
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell(PDTToString.getAsString((LocalDateTime)iLockInfo.getLockDateTime(), (Locale)locale));
            hCRow.addCell(SecurityHelper.getUserDisplayName((String)iLockInfo.getLockUserID(), (Locale)locale));
            hCRow.addCell(string);
        }
        hCNodeList.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)bootstrapDataTables);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_DATE("Datum", "Date"),
        MSG_USER("Benutzer", "User"),
        MSG_OBJECTID("ID", "ID");

        @Nonnull
        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

