/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.monitoring;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.compare.ESortOrder;
import com.helger.base.email.IEmailAddress;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.collection.commons.ICommonsList;
import com.helger.datetime.format.PDTToString;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCA_MailTo;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap4.button.BootstrapButton;
import com.helger.photon.bootstrap4.buttongroup.BootstrapButtonToolbar;
import com.helger.photon.bootstrap4.form.BootstrapForm;
import com.helger.photon.bootstrap4.form.BootstrapFormGroup;
import com.helger.photon.bootstrap4.form.BootstrapViewForm;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPageForm;
import com.helger.photon.bootstrap4.pages.handler.AbstractBootstrapWebPageActionHandler;
import com.helger.photon.bootstrap4.pages.handler.AbstractBootstrapWebPageActionHandlerDelete;
import com.helger.photon.bootstrap4.table.BootstrapTable;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.core.mgr.PhotonCoreManager;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EShowList;
import com.helger.photon.uicore.page.EWebPageFormAction;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.handler.IWebPageActionHandler;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.smtp.data.IEmailAttachment;
import com.helger.smtp.data.IEmailAttachmentList;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.failed.FailedMailData;
import com.helger.smtp.failed.FailedMailQueue;
import com.helger.smtp.scope.ScopedMailAPI;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.transport.MailSendDetails;
import com.helger.smtp.transport.MailTransportError;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayTextWithArgs;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePageMonitoringFailedMails<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPageForm<FailedMailData, WPECTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePageMonitoringFailedMails.class);
    private static final String ACTION_RESEND = "resend";
    private static final String ACTION_RESEND_DEFAULT_SETTINGS = "resend-default-settings";
    private static final String ACTION_RESEND_ALL = "resend-all";
    private static final String ACTION_RESEND_ALL_DEFAULT_SETTINGS = "resend-all-default-settings";
    private final FailedMailQueue m_aFailedMailQueue;

    private void _init() {
        this.setDeleteHandler((IWebPageActionHandler)new AbstractBootstrapWebPageActionHandlerDelete<FailedMailData, WPECTYPE>(){

            protected void showQuery(@Nonnull WPECTYPE WPECTYPE, @Nonnull BootstrapForm bootstrapForm, @Nullable FailedMailData failedMailData) {
                assert (failedMailData != null);
                Locale locale = WPECTYPE.getDisplayLocale();
                bootstrapForm.addChild((IHCNode)BasePageMonitoringFailedMails.this.question(EText.DELETE_QUERY.getDisplayText(locale)));
            }

            protected void performAction(@Nonnull WPECTYPE WPECTYPE, @Nullable FailedMailData failedMailData) {
                assert (failedMailData != null);
                Locale locale = WPECTYPE.getDisplayLocale();
                if (BasePageMonitoringFailedMails.this.m_aFailedMailQueue.remove(failedMailData.getID()) != null) {
                    LOGGER.info("Deleted single failed mail with ID " + failedMailData.getID() + "!");
                    WPECTYPE.postRedirectGetInternal((IHCNode)BasePageMonitoringFailedMails.this.success(EText.DELETE_SUCCESS.getDisplayText(locale)));
                }
            }
        });
        this.addCustomHandler("delete-all", (IWebPageActionHandler)new AbstractBootstrapWebPageActionHandler<FailedMailData, WPECTYPE>(false){

            @Nonnull
            public EShowList handleAction(@Nonnull WPECTYPE WPECTYPE, @Nullable FailedMailData failedMailData) {
                assert (failedMailData == null);
                Locale locale = WPECTYPE.getDisplayLocale();
                ICommonsList iCommonsList = BasePageMonitoringFailedMails.this.m_aFailedMailQueue.removeAll();
                if (iCommonsList.isNotEmpty()) {
                    LOGGER.info("Deleted " + iCommonsList.size() + " failed mails!");
                    String string = iCommonsList.size() == 1 ? EText.DELETE_ALL_SUCCESS_1.getDisplayText(locale) : EText.DELETE_ALL_SUCCESS_N.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(iCommonsList.size())});
                    WPECTYPE.postRedirectGetInternal((IHCNode)BasePageMonitoringFailedMails.this.success(string));
                }
                return EShowList.SHOW_LIST;
            }
        });
        AbstractBootstrapWebPageActionHandler abstractBootstrapWebPageActionHandler = new AbstractBootstrapWebPageActionHandler<FailedMailData, WPECTYPE>(true){

            @Nonnull
            public EShowList handleAction(@Nonnull WPECTYPE WPECTYPE, @Nullable FailedMailData failedMailData) {
                ValueEnforcer.notNull((Object)failedMailData, (String)"SelectedObject");
                Locale locale = WPECTYPE.getDisplayLocale();
                FailedMailData failedMailData2 = BasePageMonitoringFailedMails.this.m_aFailedMailQueue.remove(failedMailData.getID());
                if (failedMailData2 != null) {
                    ISMTPSettings iSMTPSettings = WPECTYPE.hasAction(BasePageMonitoringFailedMails.ACTION_RESEND_DEFAULT_SETTINGS) ? PhotonCoreManager.getSMTPSettingsMgr().getDefaultSMTPSettings() : null;
                    LOGGER.info("Trying to resend single failed mail with ID " + failedMailData2.getID() + (iSMTPSettings != null ? " with default settings" : "") + "!");
                    ISMTPSettings iSMTPSettings2 = iSMTPSettings != null ? iSMTPSettings : failedMailData2.getSMTPSettings();
                    ScopedMailAPI.getInstance().queueMail(iSMTPSettings2, failedMailData2.getEmailData());
                    WPECTYPE.postRedirectGetInternal((IHCNode)BasePageMonitoringFailedMails.this.success(EText.RESENT_SUCCESS.getDisplayText(locale)));
                }
                return EShowList.SHOW_LIST;
            }
        };
        this.addCustomHandler(ACTION_RESEND, (IWebPageActionHandler)abstractBootstrapWebPageActionHandler);
        this.addCustomHandler(ACTION_RESEND_DEFAULT_SETTINGS, (IWebPageActionHandler)abstractBootstrapWebPageActionHandler);
        AbstractBootstrapWebPageActionHandler abstractBootstrapWebPageActionHandler2 = new AbstractBootstrapWebPageActionHandler<FailedMailData, WPECTYPE>(false){

            @Nonnull
            public EShowList handleAction(@Nonnull WPECTYPE WPECTYPE, FailedMailData failedMailData) {
                Locale locale = WPECTYPE.getDisplayLocale();
                ICommonsList iCommonsList = BasePageMonitoringFailedMails.this.m_aFailedMailQueue.removeAll();
                if (!iCommonsList.isEmpty()) {
                    ISMTPSettings iSMTPSettings = WPECTYPE.hasAction(BasePageMonitoringFailedMails.ACTION_RESEND_ALL_DEFAULT_SETTINGS) ? PhotonCoreManager.getSMTPSettingsMgr().getDefaultSMTPSettings() : null;
                    LOGGER.info("Trying to resend " + iCommonsList.size() + " failed mails" + (iSMTPSettings != null ? " with default settings" : "") + "!");
                    for (FailedMailData failedMailData2 : iCommonsList) {
                        ScopedMailAPI.getInstance().queueMail(iSMTPSettings != null ? iSMTPSettings : failedMailData2.getSMTPSettings(), failedMailData2.getEmailData());
                    }
                    String string = iCommonsList.size() == 1 ? EText.RESENT_ALL_SUCCESS_1.getDisplayText(locale) : EText.RESENT_ALL_SUCCESS_N.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(iCommonsList.size())});
                    WPECTYPE.postRedirectGetInternal((IHCNode)BasePageMonitoringFailedMails.this.success(string));
                }
                return EShowList.SHOW_LIST;
            }
        };
        this.addCustomHandler(ACTION_RESEND_ALL, (IWebPageActionHandler)abstractBootstrapWebPageActionHandler2);
        this.addCustomHandler(ACTION_RESEND_ALL_DEFAULT_SETTINGS, (IWebPageActionHandler)abstractBootstrapWebPageActionHandler2);
        this.setObjectLockingEnabled(true);
    }

    public BasePageMonitoringFailedMails(@Nonnull @Nonempty String string, @Nonnull FailedMailQueue failedMailQueue) {
        super(string, EWebPageText.PAGE_NAME_MONITORING_FAILED_MAILS.getAsMLT());
        this.m_aFailedMailQueue = (FailedMailQueue)ValueEnforcer.notNull((Object)failedMailQueue, (String)"FailedMailQueue");
        this._init();
    }

    public BasePageMonitoringFailedMails(@Nonnull @Nonempty String string, @Nonnull String string2, @Nonnull FailedMailQueue failedMailQueue) {
        super(string, string2);
        this.m_aFailedMailQueue = (FailedMailQueue)ValueEnforcer.notNull((Object)failedMailQueue, (String)"FailedMailQueue");
        this._init();
    }

    public BasePageMonitoringFailedMails(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3, @Nonnull FailedMailQueue failedMailQueue) {
        super(string, string2, string3);
        this.m_aFailedMailQueue = (FailedMailQueue)ValueEnforcer.notNull((Object)failedMailQueue, (String)"FailedMailQueue");
        this._init();
    }

    public BasePageMonitoringFailedMails(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2, @Nonnull FailedMailQueue failedMailQueue) {
        super(string, iMultilingualText, iMultilingualText2);
        this.m_aFailedMailQueue = (FailedMailQueue)ValueEnforcer.notNull((Object)failedMailQueue, (String)"FailedMailQueue");
        this._init();
    }

    protected boolean isActionAllowed(@Nonnull WPECTYPE WPECTYPE, @Nonnull EWebPageFormAction eWebPageFormAction, @Nullable FailedMailData failedMailData) {
        if (eWebPageFormAction.isEdit()) {
            return false;
        }
        return super.isActionAllowed(WPECTYPE, eWebPageFormAction, (IHasID)failedMailData);
    }

    @Nullable
    protected FailedMailData getSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nullable String string) {
        return this.m_aFailedMailQueue.getFailedMailOfID(string);
    }

    protected void modifyViewToolbar(@Nonnull WPECTYPE WPECTYPE, @Nonnull FailedMailData failedMailData, @Nonnull BootstrapButtonToolbar bootstrapButtonToolbar) {
        Locale locale = WPECTYPE.getDisplayLocale();
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_RESEND.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref().add("action", ACTION_RESEND).add("object", failedMailData.getID()), (IIcon)EDefaultIcon.YES);
        bootstrapButtonToolbar.addButton(EText.MSG_BUTTON_RESEND_DEFAULT_SETTINGS.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref().add("action", ACTION_RESEND_DEFAULT_SETTINGS).add("object", failedMailData.getID()), (IIcon)EDefaultIcon.YES);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_DELETE.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref().add("action", "delete").add("object", failedMailData.getID()), (IIcon)EDefaultIcon.DELETE);
    }

    @Nullable
    private IHCNode _getAsString(@Nonnull List<? extends IEmailAddress> list) {
        if (list.isEmpty()) {
            return null;
        }
        HCNodeList hCNodeList = new HCNodeList();
        for (IEmailAddress iEmailAddress : list) {
            hCNodeList.addChild((IHCNode)this.div(iEmailAddress.getDisplayName()));
        }
        return hCNodeList;
    }

    protected void showSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nonnull FailedMailData failedMailData) {
        HCRow hCRow;
        BootstrapTable bootstrapTable;
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        IMutableEmailData iMutableEmailData = failedMailData.getEmailData();
        MailTransportError mailTransportError = failedMailData.getTransportError();
        BootstrapViewForm bootstrapViewForm = (BootstrapViewForm)hCNodeList.addAndReturnChild((IHCNode)new BootstrapViewForm());
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_ID.getDisplayText(locale)).setCtrl(failedMailData.getID()));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_ERROR_DT.getDisplayText(locale)).setCtrl(PDTToString.getAsString((LocalDateTime)failedMailData.getErrorDateTime(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SMTP_SETTINGS.getDisplayText(locale)).setCtrl(failedMailData.getSMTPServerDisplayText()));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SENDING_DT.getDisplayText(locale)).setCtrl(PDTToString.getAsString((LocalDateTime)failedMailData.getOriginalSentDateTime(), (Locale)locale)));
        if (iMutableEmailData != null) {
            MailSendDetails mailSendDetails;
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_EMAIL_TYPE.getDisplayText(locale)).setCtrl(iMutableEmailData.getEmailType().getID()));
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_FROM.getDisplayText(locale)).setCtrl(iMutableEmailData.getFrom().getDisplayName()));
            bootstrapTable = this._getAsString((List<IEmailAddress>)iMutableEmailData.replyTo());
            if (bootstrapTable != null) {
                bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_REPLY_TO.getDisplayText(locale)).setCtrl((IHCNode)bootstrapTable));
            }
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_TO.getDisplayText(locale)).setCtrl(this._getAsString((List<IEmailAddress>)iMutableEmailData.to())));
            Iterator iterator = this._getAsString((List<IEmailAddress>)iMutableEmailData.cc());
            if (iterator != null) {
                bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_CC.getDisplayText(locale)).setCtrl((IHCNode)iterator));
            }
            if ((mailSendDetails = this._getAsString((List<IEmailAddress>)iMutableEmailData.bcc())) != null) {
                bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_BCC.getDisplayText(locale)).setCtrl((IHCNode)mailSendDetails));
            }
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SUBJECT.getDisplayText(locale)).setCtrl(iMutableEmailData.getSubject()));
            hCRow = null;
            switch (iMutableEmailData.getEmailType()) {
                case TEXT: {
                    hCRow = HCExtHelper.nl2divList((String)iMutableEmailData.getBody());
                    break;
                }
                case HTML: {
                    hCRow = HCExtHelper.nl2divList((String)iMutableEmailData.getBody());
                }
            }
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_BODY.getDisplayText(locale)).setCtrl((Iterable)hCRow));
            IEmailAttachmentList iEmailAttachmentList = iMutableEmailData.getAttachments();
            if (iEmailAttachmentList != null && !iEmailAttachmentList.isEmpty()) {
                HCNodeList hCNodeList2 = new HCNodeList();
                for (IEmailAttachment iEmailAttachment : iEmailAttachmentList.getAllAttachments()) {
                    Object object = iEmailAttachment.getFilename();
                    if (iEmailAttachment.hasCharset()) {
                        object = (String)object + " (" + iEmailAttachment.getCharset().name() + ")";
                    }
                    if (iEmailAttachment.hasContentType()) {
                        object = (String)object + " [" + iEmailAttachment.getContentType() + "]";
                    }
                    object = (String)object + "; disposition=" + iEmailAttachment.getDisposition().getID();
                    hCNodeList2.addChild((IHCNode)this.div((String)object));
                }
                bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_ATTACHMENTS.getDisplayText(locale)).setCtrl((IHCNode)hCNodeList2));
            }
        }
        if (mailTransportError != null) {
            bootstrapTable = null;
            if (mailTransportError.hasAnyDetails()) {
                bootstrapTable = new BootstrapTable();
                bootstrapTable.addHeaderRow().addCells(new String[]{"Empf\u00e4nger Adresse", "Adresse g\u00fcltig", "Fehlermeldung"});
                for (MailSendDetails mailSendDetails : mailTransportError.getAllDetails()) {
                    hCRow = bootstrapTable.addBodyRow();
                    hCRow.addCell((IHCNode)HCA_MailTo.createLinkedEmail((String)mailSendDetails.getAddress()));
                    hCRow.addCell().addChild((IHCNode)(mailSendDetails.isAddressValid() ? EDefaultIcon.YES.getAsNode() : EDefaultIcon.NO.getAsNode()));
                    hCRow.addCell((Iterable)HCExtHelper.nl2divList((String)mailSendDetails.getErrorMessage()));
                }
            }
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_ERROR.getDisplayText(locale)).setCtrl(new IHCNode[]{this.error(mailTransportError.getThrowable().getMessage()), bootstrapTable}));
        }
    }

    protected void validateAndSaveInputParameters(@Nonnull WPECTYPE WPECTYPE, @Nullable FailedMailData failedMailData, @Nonnull FormErrorList formErrorList, @Nonnull EWebPageFormAction eWebPageFormAction) {
        throw new UnsupportedOperationException();
    }

    protected void showInputForm(@Nonnull WPECTYPE WPECTYPE, @Nullable FailedMailData failedMailData, @Nonnull BootstrapForm bootstrapForm, boolean bl, @Nonnull EWebPageFormAction eWebPageFormAction, @Nonnull FormErrorList formErrorList) {
        throw new UnsupportedOperationException();
    }

    protected void showListOfExistingObjects(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        boolean bl = this.m_aFailedMailQueue.getAllFailedMails().isEmpty();
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        bootstrapButtonToolbar.addChild((IHCNode)((BootstrapButton)((BootstrapButton)new BootstrapButton().addChild(EPhotonCoreText.BUTTON_RESEND_ALL.getDisplayText(locale))).setOnClick((ISimpleURL)WPECTYPE.getSelfHref().add("action", ACTION_RESEND_ALL))).setIcon((IIcon)EDefaultIcon.YES).setDisabled(bl));
        bootstrapButtonToolbar.addChild((IHCNode)((BootstrapButton)((BootstrapButton)new BootstrapButton().addChild(EText.MSG_BUTTON_RESEND_ALL_DEFAULT_SETTINGS.getDisplayText(locale))).setOnClick((ISimpleURL)WPECTYPE.getSelfHref().add("action", ACTION_RESEND_ALL_DEFAULT_SETTINGS))).setIcon((IIcon)EDefaultIcon.YES).setDisabled(bl));
        bootstrapButtonToolbar.addChild((IHCNode)((BootstrapButton)((BootstrapButton)new BootstrapButton().addChild(EPhotonCoreText.BUTTON_DELETE_ALL.getDisplayText(locale))).setOnClick((ISimpleURL)WPECTYPE.getSelfHref().add("action", "delete-all"))).setIcon((IIcon)EDefaultIcon.DELETE).setDisabled(bl));
        if (WPECTYPE.getMenuTree().containsItemWithID((Object)"admin_settings_smtp")) {
            bootstrapButtonToolbar.addChild((IHCNode)((BootstrapButton)((BootstrapButton)new BootstrapButton().addChild(EWebPageText.PAGE_NAME_SETTINGS_SMTP.getDisplayText(locale))).setOnClick((ISimpleURL)WPECTYPE.getLinkToMenuItem("admin_settings_smtp"))).setIcon((IIcon)EDefaultIcon.NEXT));
        }
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_ID.getDisplayText(locale)).setInitialSorting(ESortOrder.DESCENDING), new DTCol(EText.MSG_ERROR_DT.getDisplayText(locale)).setDisplayType(EDTColType.DATETIME, locale), new DTCol(EText.MSG_SMTP_SETTINGS.getDisplayText(locale)), new DTCol(EText.MSG_SUBJECT.getDisplayText(locale)), new DTCol(EText.MSG_ERROR.getDisplayText(locale))}).setID(this.getID());
        for (FailedMailData failedMailData : this.m_aFailedMailQueue.getAllFailedMails()) {
            SimpleURL simpleURL = BasePageMonitoringFailedMails.createViewURL(WPECTYPE, (IHasID)failedMailData);
            IMutableEmailData iMutableEmailData = failedMailData.getEmailData();
            Throwable throwable = failedMailData.getTransportThrowable();
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell((IHCNode)new HCA((ISimpleURL)simpleURL).addChild(failedMailData.getID()));
            hCRow.addCell(PDTToString.getAsString((LocalDateTime)failedMailData.getErrorDateTime(), (Locale)locale));
            hCRow.addCell(failedMailData.getSMTPServerDisplayText());
            hCRow.addCell(iMutableEmailData == null ? null : iMutableEmailData.getSubject());
            hCRow.addCell(throwable == null ? null : throwable.getMessage());
        }
        hCNodeList.addChild((IHCNode)hCTable);
        Iterator iterator = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)iterator);
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        MSG_ID("ID", "ID"),
        MSG_ERROR_DT("Fehler-Datum", "Error date"),
        MSG_SMTP_SETTINGS("SMTP-Einstellungen", "SMTP settings"),
        MSG_SENDING_DT("Sendedatum", "Sending date"),
        MSG_EMAIL_TYPE("E-Mail Typ", "Email type"),
        MSG_FROM("Von", "From"),
        MSG_REPLY_TO("Antwort an", "Reply to"),
        MSG_TO("An", "To"),
        MSG_CC("Cc", "Cc"),
        MSG_BCC("Bcc", "Bcc"),
        MSG_SUBJECT("Betreff", "Subject"),
        MSG_BODY("Inhalt", "Body"),
        MSG_ATTACHMENTS("Beilagen", "Attachments"),
        MSG_ERROR("Fehlermeldung", "Error message"),
        RESENT_SUCCESS("Das E-Mail wurde erneut versendet.", "The email was scheduled for resending."),
        RESENT_ALL_SUCCESS_1("Es wurde 1 E-Mail erneut versendet.", "1 email was scheduled for resending."),
        RESENT_ALL_SUCCESS_N("Es wurden {0} E-Mails erneut versendet.", "{0} emails were scheduled for resending."),
        DELETE_QUERY("Soll das E-Mail wirklich gel\u00f6scht werden?", "Should the email really be deleted?"),
        DELETE_SUCCESS("Das E-Mail wurde erfolgreich gel\u00f6scht.", "The email was successfully deleted."),
        DELETE_ALL_SUCCESS_1("Es wurde 1 E-Mail erfolgreich gel\u00f6scht.", "1 email was successfully deleted."),
        DELETE_ALL_SUCCESS_N("Es wurden {0} E-Mails erfolgreich gel\u00f6scht.", "{0} emails were successfully deleted."),
        MSG_BUTTON_RESEND_DEFAULT_SETTINGS("Erneut versenden (mit aktuellen SMTP-Einstellungen)", "Resend (with current SMTP settings)"),
        MSG_BUTTON_RESEND_ALL_DEFAULT_SETTINGS("Alle erneut versenden (mit aktuellen SMTP-Einstellungen)", "Resend all (with current SMTP settings)");

        @Nonnull
        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

