/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.monitoring;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.compare.ESortOrder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.datetime.format.PDTToString;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.audit.IAuditItem;
import com.helger.photon.audit.IAuditManager;
import com.helger.photon.bootstrap4.buttongroup.BootstrapButtonToolbar;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.security.util.SecurityHelper;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Locale;

public class BasePageMonitoringAudit<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public static final int DEFAULT_MAX_ITEMS = 250;
    public static final String PARAM_MAX_ITEMS = "maxitems";
    private final IAuditManager m_aAuditMgr;

    public BasePageMonitoringAudit(@Nonnull @Nonempty String string, @Nonnull IAuditManager iAuditManager) {
        super(string, EWebPageText.PAGE_NAME_MONITORING_AUDIT.getAsMLT());
        this.m_aAuditMgr = (IAuditManager)ValueEnforcer.notNull((Object)iAuditManager, (String)"AuditManager");
    }

    public BasePageMonitoringAudit(@Nonnull @Nonempty String string, @Nonnull String string2, @Nonnull IAuditManager iAuditManager) {
        super(string, string2);
        this.m_aAuditMgr = (IAuditManager)ValueEnforcer.notNull((Object)iAuditManager, (String)"AuditManager");
    }

    public BasePageMonitoringAudit(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3, @Nonnull IAuditManager iAuditManager) {
        super(string, string2, string3);
        this.m_aAuditMgr = (IAuditManager)ValueEnforcer.notNull((Object)iAuditManager, (String)"AuditManager");
    }

    public BasePageMonitoringAudit(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2, @Nonnull IAuditManager iAuditManager) {
        super(string, iMultilingualText, iMultilingualText2);
        this.m_aAuditMgr = (IAuditManager)ValueEnforcer.notNull((Object)iAuditManager, (String)"AuditManager");
    }

    @Nonnull
    protected final IAuditManager getAuditMgr() {
        return this.m_aAuditMgr;
    }

    @Nonnull
    @OverrideOnDemand
    protected String getActionString(@Nonnull IAuditItem iAuditItem) {
        return iAuditItem.getAction();
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        hCNodeList.addChild((IHCNode)this.div(EText.MSG_EARLIEST_DATA.getDisplayText(locale)).addChild(PDTToString.getAsString((LocalDate)this.m_aAuditMgr.getEarliestAuditDate(), (Locale)locale)));
        int n = WPECTYPE.params().getAsInt((Object)PARAM_MAX_ITEMS);
        if (n <= 0) {
            n = 250;
        }
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_DATE.getDisplayText(locale)).setDisplayType(EDTColType.DATETIME, locale).setInitialSorting(ESortOrder.DESCENDING), new DTCol(EText.MSG_USER.getDisplayText(locale)), new DTCol(EText.MSG_TYPE.getDisplayText(locale)), new DTCol(EText.MSG_SUCCESS.getDisplayText(locale)), new DTCol(EText.MSG_ACTION.getDisplayText(locale)).setDataSort(new int[]{4, 0})}).setID(this.getID());
        for (IAuditItem iAuditItem : this.m_aAuditMgr.getLastAuditItems(n)) {
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell(PDTToString.getAsString((LocalDateTime)iAuditItem.getDateTime(), (Locale)locale));
            hCRow.addCell(SecurityHelper.getUserDisplayName((String)iAuditItem.getUserID(), (Locale)locale));
            hCRow.addCell(iAuditItem.getType().getID());
            hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)iAuditItem.getSuccess().isSuccess(), (Locale)locale));
            hCRow.addCell(this.getActionString(iAuditItem));
        }
        hCNodeList.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)bootstrapDataTables);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_EARLIEST_DATA("\u00c4lteste verf\u00fcgbare Daten: ", "Earliest available data: "),
        MSG_DATE("Datum", "Date"),
        MSG_USER("Benutzer", "User"),
        MSG_TYPE("Typ", "Type"),
        MSG_SUCCESS("Erfolg?", "Success?"),
        MSG_ACTION("Aktion", "Action");

        @Nonnull
        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

