/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.data;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.compare.ESortOrder;
import com.helger.datetime.format.PDTToString;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.zone.PDTConfig;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayTextWithArgs;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.TextStyle;
import java.time.zone.ZoneRules;
import java.util.Locale;

public class BasePageDataTimeZones<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageDataTimeZones(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_DATA_TIMEZONES.getAsMLT());
    }

    public BasePageDataTimeZones(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
    }

    public BasePageDataTimeZones(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageDataTimeZones(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTime();
        ZoneId zoneId = PDTConfig.getDefaultZoneId();
        hCNodeList.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.MSG_CURRENT_TIMEZONE.getDisplayText(locale) + zoneId.getId() + " - " + zoneId.getDisplayName(TextStyle.FULL, locale)));
        hCNodeList.addChild((IHCNode)this.div(EText.MSG_CURRENT_LOCAL_TIME.getDisplayTextWithArgs(locale, new Object[]{PDTToString.getAsString((LocalDateTime)PDTFactory.getCurrentLocalDateTime(), (Locale)locale)})));
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_ID.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_NAME.getDisplayText(locale)), new DTCol(EText.MSG_SHORTNAME.getDisplayText(locale)), new DTCol(EText.MSG_OFFSET.getDisplayText(locale)).setDisplayType(EDTColType.DURATION, locale), new DTCol(EText.MSG_FIXED.getDisplayText(locale))}).setID(this.getID());
        for (String string : ZoneId.getAvailableZoneIds()) {
            ZoneId zoneId2 = ZoneId.of(string);
            ZoneRules zoneRules = zoneId2.getRules();
            ZoneOffset zoneOffset = zoneRules.getOffset(localDateTime);
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell(string);
            hCRow.addCell(zoneId2.getDisplayName(TextStyle.FULL, locale));
            hCRow.addCell(zoneId2.getDisplayName(TextStyle.SHORT, locale));
            hCRow.addCell(Duration.ofSeconds(zoneOffset.getTotalSeconds()).toString());
            hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)zoneRules.isFixedOffset(), (Locale)locale));
        }
        hCNodeList.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)bootstrapDataTables);
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        MSG_CURRENT_TIMEZONE("Eingestellte Zeitzone: ", "Time zone set: "),
        MSG_CURRENT_LOCAL_TIME("Aktuelle lokale Uhrzeit: {0}", "Current local time: {0}"),
        MSG_ID("ID", "ID"),
        MSG_NAME("Name", "Name"),
        MSG_SHORTNAME("Kurzer Name", "Short name"),
        MSG_OFFSET("Aktuelle Abweichung", "Current offset"),
        MSG_FIXED("Konstant?", "Fixed?");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

