/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.data;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.compare.ESortOrder;
import com.helger.collection.commons.ICommonsSortedSet;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.masterdata.locale.ContinentHelper;
import com.helger.masterdata.locale.EContinent;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.EUICtrlsCSSPathProvider;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.famfam.EFamFamFlagIcon;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import com.helger.text.locale.country.CountryCache;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.Locale;

public class BasePageDataCountries<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageDataCountries(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_DATA_COUNTRIES.getAsMLT());
    }

    public BasePageDataCountries(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageDataCountries(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageDataCountries(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_ID.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_NAME.getDisplayText(locale)), new DTCol(EText.MSG_CONTINENTS.getDisplayText(locale))}).setID(this.getID());
        for (Locale locale2 : CountryCache.getInstance().getAllCountryLocales()) {
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell(locale2.getCountry());
            HCDiv hCDiv = this.div();
            EFamFamFlagIcon eFamFamFlagIcon = EFamFamFlagIcon.getFromIDOrNull((String)locale2.getCountry());
            if (eFamFamFlagIcon != null) {
                ((HCDiv)hCDiv.addChild((IHCNode)eFamFamFlagIcon.getAsNode())).addChild(" ");
            }
            hCDiv.addChild(locale2.getDisplayCountry(locale));
            hCRow.addCell((IHCNode)hCDiv);
            ICommonsSortedSet iCommonsSortedSet = ContinentHelper.getContinentsOfCountry((Locale)locale2);
            StringBuilder stringBuilder = new StringBuilder();
            if (iCommonsSortedSet != null) {
                for (EContinent eContinent : iCommonsSortedSet) {
                    if (eContinent == null) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(eContinent.getDisplayText(locale));
                }
            }
            hCRow.addCell(stringBuilder.toString());
        }
        hCNodeList.addChild((IHCNode)hCTable);
        Iterator iterator = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)iterator);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EUICtrlsCSSPathProvider.FAMFAM_FLAGS);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_ID("ID", "ID"),
        MSG_NAME("Name", "Name"),
        MSG_CONTINENTS("Kontinente", "Continents");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

