/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages.appinfo;

import com.helger.annotation.Nonempty;
import com.helger.annotation.misc.Translatable;
import com.helger.base.compare.ESortOrder;
import com.helger.datetime.format.PDTToString;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap4.buttongroup.BootstrapButtonToolbar;
import com.helger.photon.bootstrap4.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap4.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.display.IHasDisplayText;
import com.helger.text.resolve.DefaultTextResolver;
import com.helger.text.util.TextHelper;
import com.helger.url.ISimpleURL;
import com.helger.xservlet.servletstatus.EServletStatus;
import com.helger.xservlet.servletstatus.ServletStatus;
import com.helger.xservlet.servletstatus.ServletStatusManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Map;

public class BasePageAppInfoServletStatus<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageAppInfoServletStatus(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_APPINFO_SERVLETSTATUS.getAsMLT());
    }

    public BasePageAppInfoServletStatus(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageAppInfoServletStatus(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageAppInfoServletStatus(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_SERVLET.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_STATUS.getDisplayText(locale)), new DTCol(EText.MSG_INVOCATION_COUNT.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_INIT_DT.getDisplayText(locale)).setDisplayType(EDTColType.DATETIME, locale)}).setID(this.getID());
        for (Map.Entry entry : ServletStatusManager.getInstance().getAllStatus().entrySet()) {
            ServletStatus servletStatus = (ServletStatus)entry.getValue();
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell((String)entry.getKey());
            hCRow.addCell(servletStatus.getCurrentStatus().getDisplayText(locale));
            hCRow.addCell(Integer.toString(servletStatus.getInvocationCount()));
            hCRow.addCell(PDTToString.getAsString((LocalDateTime)servletStatus.getDateTimeOfStatus(EServletStatus.INITED), (Locale)locale));
        }
        hCNodeList.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)bootstrapDataTables);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_SERVLET("Servlet Klasse", "Servlet class"),
        MSG_STATUS("Status", "Status"),
        MSG_INVOCATION_COUNT("Aufrufe", "Invocations"),
        MSG_INIT_DT("Initialisiert", "Initialized");

        @Nonnull
        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

