/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.pages;

import com.helger.annotation.concurrent.Immutable;
import com.helger.photon.app.PhotonAppManager;
import com.helger.photon.app.resource.WebSiteResourceBundleManager;
import com.helger.photon.audit.IAuditManager;
import com.helger.photon.bootstrap4.pages.appinfo.BasePageAppInfoAPI;
import com.helger.photon.bootstrap4.pages.appinfo.BasePageAppInfoAjaxFunctions;
import com.helger.photon.bootstrap4.pages.appinfo.BasePageAppInfoConfigurationFiles;
import com.helger.photon.bootstrap4.pages.appinfo.BasePageAppInfoGlobalScope;
import com.helger.photon.bootstrap4.pages.appinfo.BasePageAppInfoGo;
import com.helger.photon.bootstrap4.pages.appinfo.BasePageAppInfoPathMapper;
import com.helger.photon.bootstrap4.pages.appinfo.BasePageAppInfoScheduler;
import com.helger.photon.bootstrap4.pages.appinfo.BasePageAppInfoServletStatus;
import com.helger.photon.bootstrap4.pages.appinfo.BasePageAppInfoWebSiteResourceBundles;
import com.helger.photon.bootstrap4.pages.data.BasePageDataCountries;
import com.helger.photon.bootstrap4.pages.data.BasePageDataCurrencies;
import com.helger.photon.bootstrap4.pages.data.BasePageDataLanguages;
import com.helger.photon.bootstrap4.pages.data.BasePageDataTimeZones;
import com.helger.photon.bootstrap4.pages.monitoring.BasePageMonitoringAudit;
import com.helger.photon.bootstrap4.pages.monitoring.BasePageMonitoringFailedMails;
import com.helger.photon.bootstrap4.pages.monitoring.BasePageMonitoringLockedObjects;
import com.helger.photon.bootstrap4.pages.monitoring.BasePageMonitoringLoginInfo;
import com.helger.photon.bootstrap4.pages.monitoring.BasePageMonitoringSessions;
import com.helger.photon.bootstrap4.pages.monitoring.BasePageMonitoringStatistics;
import com.helger.photon.bootstrap4.pages.monitoring.BasePageMonitoringSystemMigrations;
import com.helger.photon.bootstrap4.pages.security.BasePageSecurityRoleManagement;
import com.helger.photon.bootstrap4.pages.security.BasePageSecurityUserGroupManagement;
import com.helger.photon.bootstrap4.pages.security.BasePageSecurityUserManagement;
import com.helger.photon.bootstrap4.pages.security.BasePageSecurityUserTokenManagement;
import com.helger.photon.bootstrap4.pages.settings.BasePageSettingsGlobal;
import com.helger.photon.bootstrap4.pages.settings.BasePageSettingsHTML;
import com.helger.photon.bootstrap4.pages.settings.BasePageSettingsLogLevel;
import com.helger.photon.bootstrap4.pages.settings.BasePageSettingsSMTP;
import com.helger.photon.bootstrap4.pages.settings.BasePageSettingsSystemMessage;
import com.helger.photon.bootstrap4.pages.sysinfo.BasePageSysInfoCACerts;
import com.helger.photon.bootstrap4.pages.sysinfo.BasePageSysInfoEnvironmentVariables;
import com.helger.photon.bootstrap4.pages.sysinfo.BasePageSysInfoNetwork;
import com.helger.photon.bootstrap4.pages.sysinfo.BasePageSysInfoRequest;
import com.helger.photon.bootstrap4.pages.sysinfo.BasePageSysInfoSecurity;
import com.helger.photon.bootstrap4.pages.sysinfo.BasePageSysInfoServletContext;
import com.helger.photon.bootstrap4.pages.sysinfo.BasePageSysInfoSystemProperties;
import com.helger.photon.bootstrap4.pages.sysinfo.BasePageSysInfoThirdPartyLibraries;
import com.helger.photon.bootstrap4.pages.sysinfo.BasePageSysInfoThreads;
import com.helger.photon.bootstrap4.pages.utils.BasePageUtilsBase64Decode;
import com.helger.photon.bootstrap4.pages.utils.BasePageUtilsBase64Encode;
import com.helger.photon.bootstrap4.pages.utils.BasePageUtilsHttpClient;
import com.helger.photon.bootstrap4.pages.utils.BasePageUtilsPortChecker;
import com.helger.photon.core.go.GoMappingManager;
import com.helger.photon.core.menu.IMenuItem;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuObjectFilter;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.mgr.PhotonBasicManager;
import com.helger.photon.core.mgr.PhotonCoreManager;
import com.helger.photon.core.page.IPage;
import com.helger.photon.core.smtp.NamedSMTPSettingsManager;
import com.helger.photon.core.sysmigration.SystemMigrationManager;
import com.helger.photon.security.lock.ILockManager;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.system.BasePageShowChildren;
import com.helger.smtp.failed.FailedMailQueue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@Immutable
public final class BootstrapPagesMenuConfigurator {
    public static final String MENU_ADMIN_SECURITY = "admin_security";
    public static final String MENU_ADMIN_SECURITY_USER = "admin_security_user";
    public static final String MENU_ADMIN_SECURITY_USER_GROUP = "admin_security_usergroup";
    public static final String MENU_ADMIN_SECURITY_ROLE = "admin_security_role";
    public static final String MENU_ADMIN_SECURITY_USER_TOKEN = "admin_security_usertoken";
    public static final String MENU_ADMIN_MONITORING = "admin_monitoring";
    public static final String MENU_ADMIN_MONITORING_AUDIT = "admin_monitoring_audit";
    public static final String MENU_ADMIN_MONITORING_FAILEDMAILS = "admin_monitoring_failedmails";
    public static final String MENU_ADMIN_MONITORING_LOCKEDOBJECTS = "admin_monitoring_lockedobjects";
    public static final String MENU_ADMIN_MONITORING_LOGININFO = "admin_monitoring_logininfo";
    public static final String MENU_ADMIN_MONITORING_SESSIONS = "admin_monitoring_sessions";
    public static final String MENU_ADMIN_MONITORING_STATISTICS = "admin_monitoring_statistics";
    public static final String MENU_ADMIN_MONITORING_SYSTEMMIGRATIONS = "admin_monitoring_systemmigrations";
    public static final String MENU_ADMIN_SYSINFO = "admin_sysinfo";
    public static final String MENU_ADMIN_SYSINFO_CACERTS = "admin_sysinfo_cacerts";
    public static final String MENU_ADMIN_SYSINFO_ENVVARS = "admin_sysinfo_envvars";
    public static final String MENU_ADMIN_SYSINFO_NETWORK = "admin_sysinfo_network";
    public static final String MENU_ADMIN_SYSINFO_REQUEST = "admin_sysinfo_request";
    public static final String MENU_ADMIN_SYSINFO_SECURITY = "admin_sysinfo_security";
    public static final String MENU_ADMIN_SYSINFO_SERVLETCONTEXT = "admin_sysinfo_servletcontext";
    public static final String MENU_ADMIN_SYSINFO_SYSPROPS = "admin_sysinfo_sysprops";
    public static final String MENU_ADMIN_SYSINFO_THIRDPARTYLIBS = "admin_sysinfo_thirdpartylibs";
    public static final String MENU_ADMIN_SYSINFO_THREADS = "admin_sysinfo_threads";
    public static final String MENU_ADMIN_APPINFO = "admin_appinfo";
    public static final String MENU_ADMIN_APPINFO_AJAX_FUNCTIONS = "admin_appinfo_ajax_functions";
    public static final String MENU_ADMIN_APPINFO_API = "admin_appinfo_api";
    public static final String MENU_ADMIN_APPINFO_CONFIGFILES = "admin_appinfo_configfiles";
    public static final String MENU_ADMIN_APPINFO_GO = "admin_appinfo_go";
    public static final String MENU_ADMIN_APPINFO_PATH_MAPPER = "admin_appinfo_pathmapper";
    public static final String MENU_ADMIN_APPINFO_SCHEDULER = "admin_appinfo_scheduler";
    public static final String MENU_ADMIN_APPINFO_GLOBAL_SCOPE = "admin_appinfo_scopes";
    public static final String MENU_ADMIN_APPINFO_SERVLETSTATUS = "admin_appinfo_servletstatus";
    public static final String MENU_ADMIN_APPINFO_WEBRESBUNDLE = "admin_appinfo_webresbundle";
    public static final String MENU_ADMIN_DATA = "admin_data";
    public static final String MENU_ADMIN_DATA_COUNTRIES = "admin_data_countries";
    public static final String MENU_ADMIN_DATA_CURRENCIES = "admin_data_currencies";
    public static final String MENU_ADMIN_DATA_LANGUAGES = "admin_data_languages";
    public static final String MENU_ADMIN_DATA_TIMEZONES = "admin_data_timezones";
    public static final String MENU_ADMIN_UTILS = "admin_utils";
    public static final String MENU_ADMIN_UTILS_BASE64_DECODE = "admin_utils_base64decode";
    public static final String MENU_ADMIN_UTILS_BASE64_ENCODE = "admin_utils_base64encode";
    public static final String MENU_ADMIN_UTILS_HTTP_CLIENT = "admin_utils_httpclient";
    public static final String MENU_ADMIN_UTILS_PORT_CHECKER = "admin_utils_portchecker";
    public static final String MENU_ADMIN_SETTINGS = "admin_settings";
    public static final String MENU_ADMIN_SETTINGS_GLOBAL = "admin_settings_global";
    public static final String MENU_ADMIN_SETTINGS_HTML = "admin_settings_html";
    public static final String MENU_ADMIN_SETTINGS_LOG_LEVEL = "admin_settings_log_level";
    public static final String MENU_ADMIN_SETTINGS_SMTP = "admin_settings_smtp";
    public static final String MENU_ADMIN_SETTINGS_SYSTEMMESSAGE = "admin_settings_systemmessage";

    private BootstrapPagesMenuConfigurator() {
    }

    @Nonnull
    public static IMenuItemPage addSecurityItems(@Nonnull IMenuTree iMenuTree, @Nonnull IMenuItem iMenuItem, @Nullable IMenuObjectFilter iMenuObjectFilter, @Nonnull Locale locale) {
        IMenuItemPage iMenuItemPage = iMenuTree.createItem(iMenuItem, (IPage)new BasePageShowChildren(MENU_ADMIN_SECURITY, EWebPageText.PAGE_NAME_SECURITY.getAsMLT(), iMenuTree)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSecurityUserManagement(MENU_ADMIN_SECURITY_USER).setDefaultUserLocale(locale)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSecurityUserGroupManagement(MENU_ADMIN_SECURITY_USER_GROUP)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSecurityRoleManagement(MENU_ADMIN_SECURITY_ROLE)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSecurityUserTokenManagement(MENU_ADMIN_SECURITY_USER_TOKEN)).setDisplayFilter(iMenuObjectFilter);
        return iMenuItemPage;
    }

    @Nonnull
    public static IMenuItemPage addMonitoringItems(@Nonnull IMenuTree iMenuTree, @Nonnull IMenuItem iMenuItem, @Nullable IMenuObjectFilter iMenuObjectFilter) {
        return BootstrapPagesMenuConfigurator.addMonitoringItems(iMenuTree, iMenuItem, iMenuObjectFilter, PhotonSecurityManager.getAuditMgr(), (FailedMailQueue)PhotonCoreManager.getFailedMailQueue(), (ILockManager<String>)PhotonSecurityManager.getLockMgr(), PhotonBasicManager.getSystemMigrationMgr());
    }

    @Nonnull
    public static IMenuItemPage addMonitoringItems(@Nonnull IMenuTree iMenuTree, @Nonnull IMenuItem iMenuItem, @Nullable IMenuObjectFilter iMenuObjectFilter, @Nullable IAuditManager iAuditManager, @Nullable FailedMailQueue failedMailQueue, @Nullable ILockManager<String> iLockManager, @Nullable SystemMigrationManager systemMigrationManager) {
        IMenuItemPage iMenuItemPage = iMenuTree.createItem(iMenuItem, (IPage)new BasePageShowChildren(MENU_ADMIN_MONITORING, EWebPageText.PAGE_NAME_MONITORING.getAsMLT(), iMenuTree)).setDisplayFilter(iMenuObjectFilter);
        if (iAuditManager != null) {
            iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageMonitoringAudit(MENU_ADMIN_MONITORING_AUDIT, iAuditManager)).setDisplayFilter(iMenuObjectFilter);
        }
        if (failedMailQueue != null) {
            iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageMonitoringFailedMails(MENU_ADMIN_MONITORING_FAILEDMAILS, failedMailQueue)).setDisplayFilter(iMenuObjectFilter);
        }
        if (iLockManager != null) {
            iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageMonitoringLockedObjects(MENU_ADMIN_MONITORING_LOCKEDOBJECTS, iLockManager)).setDisplayFilter(iMenuObjectFilter);
        }
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageMonitoringLoginInfo(MENU_ADMIN_MONITORING_LOGININFO)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageMonitoringSessions(MENU_ADMIN_MONITORING_SESSIONS)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageMonitoringStatistics(MENU_ADMIN_MONITORING_STATISTICS)).setDisplayFilter(iMenuObjectFilter);
        if (systemMigrationManager != null) {
            iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageMonitoringSystemMigrations(MENU_ADMIN_MONITORING_SYSTEMMIGRATIONS, systemMigrationManager)).setDisplayFilter(iMenuObjectFilter);
        }
        return iMenuItemPage;
    }

    @Nonnull
    public static IMenuItemPage addSysInfoItems(@Nonnull IMenuTree iMenuTree, @Nonnull IMenuItem iMenuItem, @Nullable IMenuObjectFilter iMenuObjectFilter) {
        IMenuItemPage iMenuItemPage = iMenuTree.createItem(iMenuItem, (IPage)new BasePageShowChildren(MENU_ADMIN_SYSINFO, EWebPageText.PAGE_NAME_SYSINFO.getAsMLT(), iMenuTree)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSysInfoCACerts(MENU_ADMIN_SYSINFO_CACERTS)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSysInfoEnvironmentVariables(MENU_ADMIN_SYSINFO_ENVVARS)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSysInfoNetwork(MENU_ADMIN_SYSINFO_NETWORK)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSysInfoRequest(MENU_ADMIN_SYSINFO_REQUEST)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSysInfoSecurity(MENU_ADMIN_SYSINFO_SECURITY)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSysInfoServletContext(MENU_ADMIN_SYSINFO_SERVLETCONTEXT)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSysInfoSystemProperties(MENU_ADMIN_SYSINFO_SYSPROPS)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSysInfoThirdPartyLibraries(MENU_ADMIN_SYSINFO_THIRDPARTYLIBS)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSysInfoThreads(MENU_ADMIN_SYSINFO_THREADS)).setDisplayFilter(iMenuObjectFilter);
        return iMenuItemPage;
    }

    @Nonnull
    public static IMenuItemPage addAppInfoItems(@Nonnull IMenuTree iMenuTree, @Nonnull IMenuItem iMenuItem, @Nullable IMenuObjectFilter iMenuObjectFilter) {
        return BootstrapPagesMenuConfigurator.addAppInfoItems(iMenuTree, iMenuItem, iMenuObjectFilter, PhotonCoreManager.getGoMappingMgr(), PhotonAppManager.getWebSiteResourceBundleMgr());
    }

    @Nonnull
    public static IMenuItemPage addAppInfoItems(@Nonnull IMenuTree iMenuTree, @Nonnull IMenuItem iMenuItem, @Nullable IMenuObjectFilter iMenuObjectFilter, @Nullable GoMappingManager goMappingManager, @Nullable WebSiteResourceBundleManager webSiteResourceBundleManager) {
        IMenuItemPage iMenuItemPage = iMenuTree.createItem(iMenuItem, (IPage)new BasePageShowChildren(MENU_ADMIN_APPINFO, EWebPageText.PAGE_NAME_APPINFO.getAsMLT(), iMenuTree)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageAppInfoAjaxFunctions(MENU_ADMIN_APPINFO_AJAX_FUNCTIONS)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageAppInfoAPI(MENU_ADMIN_APPINFO_API)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageAppInfoConfigurationFiles(MENU_ADMIN_APPINFO_CONFIGFILES)).setDisplayFilter(iMenuObjectFilter);
        if (goMappingManager != null) {
            iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageAppInfoGo(MENU_ADMIN_APPINFO_GO, goMappingManager)).setDisplayFilter(iMenuObjectFilter);
        }
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageAppInfoPathMapper(MENU_ADMIN_APPINFO_PATH_MAPPER)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageAppInfoScheduler(MENU_ADMIN_APPINFO_SCHEDULER)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageAppInfoGlobalScope(MENU_ADMIN_APPINFO_GLOBAL_SCOPE)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageAppInfoServletStatus(MENU_ADMIN_APPINFO_SERVLETSTATUS)).setDisplayFilter(iMenuObjectFilter);
        if (webSiteResourceBundleManager != null) {
            iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageAppInfoWebSiteResourceBundles(MENU_ADMIN_APPINFO_WEBRESBUNDLE, webSiteResourceBundleManager)).setDisplayFilter(iMenuObjectFilter);
        }
        return iMenuItemPage;
    }

    @Nonnull
    public static IMenuItemPage addDataItems(@Nonnull IMenuTree iMenuTree, @Nonnull IMenuItem iMenuItem, @Nullable IMenuObjectFilter iMenuObjectFilter) {
        IMenuItemPage iMenuItemPage = iMenuTree.createItem(iMenuItem, (IPage)new BasePageShowChildren(MENU_ADMIN_DATA, EWebPageText.PAGE_NAME_DATA.getAsMLT(), iMenuTree)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageDataCountries(MENU_ADMIN_DATA_COUNTRIES)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageDataCurrencies(MENU_ADMIN_DATA_CURRENCIES)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageDataLanguages(MENU_ADMIN_DATA_LANGUAGES)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageDataTimeZones(MENU_ADMIN_DATA_TIMEZONES)).setDisplayFilter(iMenuObjectFilter);
        return iMenuItemPage;
    }

    @Nonnull
    public static IMenuItemPage addUtilsItems(@Nonnull IMenuTree iMenuTree, @Nonnull IMenuItem iMenuItem, @Nullable IMenuObjectFilter iMenuObjectFilter) {
        IMenuItemPage iMenuItemPage = iMenuTree.createItem(iMenuItem, (IPage)new BasePageShowChildren(MENU_ADMIN_UTILS, EWebPageText.PAGE_NAME_UTILS.getAsMLT(), iMenuTree)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageUtilsBase64Decode(MENU_ADMIN_UTILS_BASE64_DECODE)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageUtilsBase64Encode(MENU_ADMIN_UTILS_BASE64_ENCODE)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageUtilsHttpClient(MENU_ADMIN_UTILS_HTTP_CLIENT)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageUtilsPortChecker(MENU_ADMIN_UTILS_PORT_CHECKER)).setDisplayFilter(iMenuObjectFilter);
        return iMenuItemPage;
    }

    @Nonnull
    public static IMenuItemPage addSettingsItems(@Nonnull IMenuTree iMenuTree, @Nonnull IMenuItem iMenuItem, @Nullable IMenuObjectFilter iMenuObjectFilter) {
        return BootstrapPagesMenuConfigurator.addSettingsItems(iMenuTree, iMenuItem, iMenuObjectFilter, PhotonCoreManager.getSMTPSettingsMgr());
    }

    @Nonnull
    public static IMenuItemPage addSettingsItems(@Nonnull IMenuTree iMenuTree, @Nonnull IMenuItem iMenuItem, @Nullable IMenuObjectFilter iMenuObjectFilter, @Nullable NamedSMTPSettingsManager namedSMTPSettingsManager) {
        IMenuItemPage iMenuItemPage = iMenuTree.createItem(iMenuItem, (IPage)new BasePageShowChildren(MENU_ADMIN_SETTINGS, EWebPageText.PAGE_NAME_SETTINGS.getAsMLT(), iMenuTree)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSettingsGlobal(MENU_ADMIN_SETTINGS_GLOBAL)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSettingsHTML(MENU_ADMIN_SETTINGS_HTML)).setDisplayFilter(iMenuObjectFilter);
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSettingsLogLevel(MENU_ADMIN_SETTINGS_LOG_LEVEL)).setDisplayFilter(iMenuObjectFilter);
        if (namedSMTPSettingsManager != null) {
            iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSettingsSMTP(namedSMTPSettingsManager, MENU_ADMIN_SETTINGS_SMTP)).setDisplayFilter(iMenuObjectFilter);
        }
        iMenuTree.createItem((IMenuItem)iMenuItemPage, new BasePageSettingsSystemMessage(MENU_ADMIN_SETTINGS_SYSTEMMESSAGE)).setDisplayFilter(iMenuObjectFilter);
        return iMenuItemPage;
    }

    public static void addAllItems(@Nonnull IMenuTree iMenuTree, @Nonnull IMenuItem iMenuItem, @Nullable IMenuObjectFilter iMenuObjectFilter, @Nonnull Locale locale) {
        BootstrapPagesMenuConfigurator.addSecurityItems(iMenuTree, iMenuItem, iMenuObjectFilter, locale);
        BootstrapPagesMenuConfigurator.addMonitoringItems(iMenuTree, iMenuItem, iMenuObjectFilter);
        BootstrapPagesMenuConfigurator.addSysInfoItems(iMenuTree, iMenuItem, iMenuObjectFilter);
        BootstrapPagesMenuConfigurator.addAppInfoItems(iMenuTree, iMenuItem, iMenuObjectFilter);
        BootstrapPagesMenuConfigurator.addDataItems(iMenuTree, iMenuItem, iMenuObjectFilter);
        BootstrapPagesMenuConfigurator.addUtilsItems(iMenuTree, iMenuItem, iMenuObjectFilter);
        BootstrapPagesMenuConfigurator.addSettingsItems(iMenuTree, iMenuItem, iMenuObjectFilter);
    }
}

