/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit.v2.pipeline;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.callback.ICallback;
import com.helger.base.callback.exception.IExceptionCallback;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.diagnostics.callback.exception.LoggingExceptionCallback;
import com.helger.photon.audit.v2.domain.AuditEvent;
import com.helger.photon.audit.v2.pipeline.IAuditEventConsumer;
import jakarta.annotation.Nonnull;

@NotThreadSafe
public class AuditEventConsumerPipeline
implements IAuditEventConsumer {
    private final ICommonsList<IAuditEventConsumer> m_aConsumers = new CommonsArrayList();
    private final CallbackList<IExceptionCallback<? super Exception>> m_aExCallbacks = new CallbackList();

    public AuditEventConsumerPipeline() {
        this.m_aExCallbacks.add((ICallback)new LoggingExceptionCallback());
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<IAuditEventConsumer> consumers() {
        return this.m_aConsumers;
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IExceptionCallback<? super Exception>> exceptionCallbacks() {
        return this.m_aExCallbacks;
    }

    @Override
    public void consumeAuditEvent(@Nonnull AuditEvent auditEvent) {
        for (IAuditEventConsumer iAuditEventConsumer : this.m_aConsumers) {
            try {
                iAuditEventConsumer.consumeAuditEvent(auditEvent);
            }
            catch (Exception exception) {
                this.m_aExCallbacks.forEach(iExceptionCallback -> iExceptionCallback.onException((Throwable)exception));
            }
        }
    }
}

