/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.base.type.ObjectType;
import com.helger.photon.audit.EAuditActionType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@FunctionalInterface
public interface IAuditor {
    public void createAuditItem(@Nonnull EAuditActionType var1, @Nonnull ESuccess var2, @Nullable ObjectType var3, @Nullable String var4, Object ... var5);

    default public void onCreateSuccess(@Nonnull ObjectType objectType, Object ... objectArray) {
        ValueEnforcer.notNull((Object)objectType, (String)"ObjectType");
        this.createAuditItem(EAuditActionType.CREATE, ESuccess.SUCCESS, objectType, null, objectArray);
    }

    default public void onCreateFailure(@Nonnull ObjectType objectType, Object ... objectArray) {
        ValueEnforcer.notNull((Object)objectType, (String)"ObjectType");
        this.createAuditItem(EAuditActionType.CREATE, ESuccess.FAILURE, objectType, null, objectArray);
    }

    default public void onModifySuccess(@Nonnull ObjectType objectType, @Nonnull String string, Object ... objectArray) {
        ValueEnforcer.notNull((Object)objectType, (String)"ObjectType");
        this.createAuditItem(EAuditActionType.MODIFY, ESuccess.SUCCESS, objectType, null, ArrayHelper.getConcatenated((Object)string, (Object[])objectArray, Object.class));
    }

    default public void onModifyFailure(@Nonnull ObjectType objectType, @Nonnull String string, Object ... objectArray) {
        ValueEnforcer.notNull((Object)objectType, (String)"ObjectType");
        this.createAuditItem(EAuditActionType.MODIFY, ESuccess.FAILURE, objectType, null, ArrayHelper.getConcatenated((Object)string, (Object[])objectArray, Object.class));
    }

    default public void onDeleteSuccess(@Nonnull ObjectType objectType, Object ... objectArray) {
        ValueEnforcer.notNull((Object)objectType, (String)"ObjectType");
        this.createAuditItem(EAuditActionType.DELETE, ESuccess.SUCCESS, objectType, null, objectArray);
    }

    default public void onDeleteFailure(@Nonnull ObjectType objectType, Object ... objectArray) {
        ValueEnforcer.notNull((Object)objectType, (String)"ObjectType");
        this.createAuditItem(EAuditActionType.DELETE, ESuccess.FAILURE, objectType, null, objectArray);
    }

    default public void onUndeleteSuccess(@Nonnull ObjectType objectType, Object ... objectArray) {
        ValueEnforcer.notNull((Object)objectType, (String)"ObjectType");
        this.createAuditItem(EAuditActionType.UNDELETE, ESuccess.SUCCESS, objectType, null, objectArray);
    }

    default public void onUndeleteFailure(@Nonnull ObjectType objectType, Object ... objectArray) {
        ValueEnforcer.notNull((Object)objectType, (String)"ObjectType");
        this.createAuditItem(EAuditActionType.UNDELETE, ESuccess.FAILURE, objectType, null, objectArray);
    }

    default public void onExecuteSuccess(@Nonnull String string, Object ... objectArray) {
        this.createAuditItem(EAuditActionType.EXECUTE, ESuccess.SUCCESS, null, string, objectArray);
    }

    default public void onExecuteFailure(@Nonnull String string, Object ... objectArray) {
        this.createAuditItem(EAuditActionType.EXECUTE, ESuccess.FAILURE, null, string, objectArray);
    }

    default public void onExecuteSuccess(@Nonnull ObjectType objectType, @Nonnull String string, Object ... objectArray) {
        ValueEnforcer.notNull((Object)objectType, (String)"ObjectType");
        this.createAuditItem(EAuditActionType.EXECUTE, ESuccess.SUCCESS, objectType, null, ArrayHelper.getConcatenated((Object)string, (Object[])objectArray, Object.class));
    }

    default public void onExecuteFailure(@Nonnull ObjectType objectType, @Nonnull String string, Object ... objectArray) {
        ValueEnforcer.notNull((Object)objectType, (String)"ObjectType");
        this.createAuditItem(EAuditActionType.EXECUTE, ESuccess.FAILURE, objectType, null, ArrayHelper.getConcatenated((Object)string, (Object[])objectArray, Object.class));
    }
}

