/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.helper.PDTFactory;
import com.helger.photon.audit.EAuditActionType;
import com.helger.photon.audit.IAuditItem;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;

@Immutable
public final class AuditItem
implements IAuditItem {
    private final LocalDateTime m_aDateTime;
    private final String m_sUserID;
    private final EAuditActionType m_eType;
    private final ESuccess m_eSuccess;
    private final String m_sAction;

    public AuditItem(@Nullable String string, @Nonnull EAuditActionType eAuditActionType, @Nonnull ESuccess eSuccess, @Nonnull String string2) {
        this(PDTFactory.getCurrentLocalDateTime(), StringHelper.isNotEmpty((String)string) ? string : "$GUEST$", eAuditActionType, eSuccess, string2);
    }

    public AuditItem(@Nonnull LocalDateTime localDateTime, @Nonnull String string, @Nonnull EAuditActionType eAuditActionType, @Nonnull ESuccess eSuccess, @Nonnull String string2) {
        this.m_aDateTime = (LocalDateTime)ValueEnforcer.notNull((Object)localDateTime, (String)"LocalDateTime");
        this.m_sUserID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"UserID");
        this.m_eType = (EAuditActionType)((Object)ValueEnforcer.notNull((Object)((Object)eAuditActionType), (String)"Type"));
        this.m_eSuccess = (ESuccess)ValueEnforcer.notNull((Object)eSuccess, (String)"Success");
        this.m_sAction = (String)ValueEnforcer.notNull((Object)string2, (String)"Action");
    }

    @Override
    @Nonnull
    public LocalDateTime getDateTime() {
        return this.m_aDateTime;
    }

    @Nonnull
    public String getUserID() {
        return this.m_sUserID;
    }

    @Override
    @Nonnull
    public EAuditActionType getType() {
        return this.m_eType;
    }

    @Override
    @Nonnull
    public ESuccess getSuccess() {
        return this.m_eSuccess;
    }

    @Override
    @Nonnull
    public String getAction() {
        return this.m_sAction;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AuditItem auditItem = (AuditItem)object;
        return this.m_aDateTime.equals(auditItem.m_aDateTime) && this.m_sUserID.equals(auditItem.m_sUserID) && this.m_eType.equals((Object)auditItem.m_eType) && this.m_eSuccess.equals((Object)auditItem.m_eSuccess) && this.m_sAction.equals(auditItem.m_sAction);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aDateTime).append((Object)this.m_sUserID).append((Object)this.m_eType).append((Object)this.m_eSuccess).append((Object)this.m_sAction).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("dateTime", (Object)this.m_aDateTime).append("userID", (Object)this.m_sUserID).append("type", (Enum)this.m_eType).append("success", (Enum)this.m_eSuccess).append("action", (Object)this.m_sAction).getToString();
    }
}

