/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.url;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.cache.regex.RegExHelper;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.url.SimpleURL;
import com.helger.url.protocol.URLProtocolRegistry;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.web.scope.mgr.WebScopeManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LinkHelper {
    public static final String STREAM_SERVLET_NAME_REGEX = "[a-zA-Z0-9-_]+";
    public static final String DEFAULT_STREAM_SERVLET_NAME = "stream";
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkHelper.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static String s_sStreamServletName = "stream";

    private LinkHelper() {
    }

    public static void setStreamServletName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"StreamServletName");
        if (!RegExHelper.stringMatchesPattern((String)STREAM_SERVLET_NAME_REGEX, (String)string)) {
            throw new IllegalArgumentException("Invalid StreamServletName '" + string + "' passed. It must match the following rexg: [a-zA-Z0-9-_]+");
        }
        RW_LOCK.writeLocked(() -> {
            s_sStreamServletName = string;
        });
    }

    @Nonnull
    @Nonempty
    public static String getStreamServletName() {
        return (String)RW_LOCK.readLockedGet(() -> s_sStreamServletName);
    }

    @Nonnull
    @Nonempty
    public static String getStreamServletPath() {
        return (String)RW_LOCK.readLockedGet(() -> "/" + s_sStreamServletName);
    }

    public static boolean hasKnownProtocol(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return URLProtocolRegistry.getInstance().hasKnownProtocol(string) || string.startsWith("//");
    }

    @Nonnull
    private static String _getURIWithContext(@Nonnull String string, @Nonnull String string2) {
        if (StringHelper.isNotEmpty((String)string) && string2.startsWith(string)) {
            LOGGER.warn("The passed href '" + string2 + "' already contains the context path '" + string + "'!");
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (!StringHelper.startsWith((CharSequence)string2, (char)'/')) {
            stringBuilder.append('/');
        }
        return stringBuilder.append(string2).toString();
    }

    @Nonnull
    public static String getURIWithContext(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"HRef");
        if (LinkHelper.hasKnownProtocol(string)) {
            return string;
        }
        String string2 = ServletContextPathHolder.getContextPath();
        return LinkHelper._getURIWithContext(string2, string);
    }

    @Nonnull
    public static String getURIWithContext(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iRequestWebScopeWithoutResponse, (String)"RequestScope");
        ValueEnforcer.notNull((Object)string, (String)"HRef");
        if (LinkHelper.hasKnownProtocol(string)) {
            return string;
        }
        String string2 = iRequestWebScopeWithoutResponse.getContextPath();
        return iRequestWebScopeWithoutResponse.encodeURL(LinkHelper._getURIWithContext(string2, string));
    }

    @Nonnull
    public static SimpleURL getURLWithContext(@Nonnull String string) {
        return new SimpleURL(LinkHelper.getURIWithContext(string));
    }

    @Nonnull
    public static SimpleURL getURLWithContext(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull String string) {
        return new SimpleURL(LinkHelper.getURIWithContext(iRequestWebScopeWithoutResponse, string));
    }

    @Nonnull
    public static String getURIWithServerAndContext(@Nonnull String string) {
        if (LinkHelper.hasKnownProtocol(string)) {
            return string;
        }
        IRequestWebScope iRequestWebScope = WebScopeManager.getRequestScope();
        String string2 = iRequestWebScope.getContextPath();
        return iRequestWebScope.getFullServerPath() + LinkHelper._getURIWithContext(string2, string);
    }

    @Nonnull
    public static String getURIWithServerAndContext(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iRequestWebScopeWithoutResponse, (String)"RequestScope");
        ValueEnforcer.notNull((Object)string, (String)"HRef");
        if (LinkHelper.hasKnownProtocol(string)) {
            return string;
        }
        String string2 = iRequestWebScopeWithoutResponse.getContextPath();
        String string3 = iRequestWebScopeWithoutResponse.getFullServerPath() + LinkHelper._getURIWithContext(string2, string);
        return iRequestWebScopeWithoutResponse.encodeURL(string3);
    }

    @Nonnull
    public static SimpleURL getURLWithServerAndContext(@Nonnull String string) {
        return new SimpleURL(LinkHelper.getURIWithServerAndContext(string));
    }

    @Nonnull
    public static SimpleURL getURLWithServerAndContext(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull String string) {
        return new SimpleURL(LinkHelper.getURIWithServerAndContext(iRequestWebScopeWithoutResponse, string));
    }

    @Nonnull
    public static SimpleURL getHomeLinkWithoutSession() {
        String string = ServletContextPathHolder.getContextPath();
        return new SimpleURL(string.length() == 0 ? "/" : string);
    }

    @Nonnull
    public static SimpleURL getStreamURL(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)iRequestWebScopeWithoutResponse, (String)"RequestScope");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"URL");
        if (LinkHelper.hasKnownProtocol(string)) {
            return new SimpleURL(string);
        }
        StringBuilder stringBuilder = new StringBuilder(LinkHelper.getStreamServletPath());
        if (!StringHelper.startsWith((CharSequence)string, (char)'/')) {
            stringBuilder.append('/');
        }
        return LinkHelper.getURLWithContext(iRequestWebScopeWithoutResponse, stringBuilder.append(string).toString());
    }
}

