/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.resource;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.resource.css.ConstantCSSPathProvider;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.ConstantJSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.resource.EWebSiteResourceType;
import com.helger.photon.app.resource.WebSiteResource;
import com.helger.photon.app.resource.WebSiteResourceCache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class WebSiteResourceWithCondition {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSiteResourceWithCondition.class);
    private final WebSiteResource m_aResource;
    private final String m_sConditionalComment;
    private final boolean m_bIsBundlable;
    private final CSSMediaList m_aMediaList;

    public WebSiteResourceWithCondition(@Nonnull EWebSiteResourceType eWebSiteResourceType, @Nonnull @Nonempty String string, @Nonnull Charset charset, @Nullable String string2, boolean bl, @Nullable ICSSMediaList iCSSMediaList) {
        this(WebSiteResourceCache.getOrCreateResource(eWebSiteResourceType, string, charset), string2, bl, iCSSMediaList);
    }

    protected WebSiteResourceWithCondition(@Nonnull WebSiteResource webSiteResource, @Nullable String string, boolean bl, @Nullable ICSSMediaList iCSSMediaList) {
        this.m_aResource = (WebSiteResource)ValueEnforcer.notNull((Object)webSiteResource, (String)"Resource");
        this.m_sConditionalComment = string;
        this.m_bIsBundlable = bl;
        this.m_aMediaList = iCSSMediaList == null || iCSSMediaList.hasNoMedia() ? null : new CSSMediaList(iCSSMediaList);
    }

    @Nonnull
    public WebSiteResource getResource() {
        return this.m_aResource;
    }

    public boolean canBeBundledWith(@Nonnull WebSiteResourceWithCondition webSiteResourceWithCondition) {
        ValueEnforcer.notNull((Object)webSiteResourceWithCondition, (String)"Other");
        if (!this.m_bIsBundlable || !webSiteResourceWithCondition.isBundlable()) {
            return false;
        }
        if (!this.m_aResource.getResourceType().equals((Object)webSiteResourceWithCondition.m_aResource.getResourceType())) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.m_sConditionalComment, (Object)webSiteResourceWithCondition.m_sConditionalComment)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.m_aMediaList, (Object)webSiteResourceWithCondition.m_aMediaList)) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("this can be bundled with " + String.valueOf(webSiteResourceWithCondition));
        }
        return true;
    }

    public boolean hasConditionalComment() {
        return StringHelper.isNotEmpty((String)this.m_sConditionalComment);
    }

    @Nullable
    public String getConditionalComment() {
        return this.m_sConditionalComment;
    }

    public boolean isBundlable() {
        return this.m_bIsBundlable;
    }

    @Nullable
    public ICSSMediaList getMediaList() {
        return this.m_aMediaList;
    }

    @Nonnull
    public ConstantCSSPathProvider getAsCSSPathProvider() {
        if (this.m_aResource.getResourceType() != EWebSiteResourceType.CSS) {
            throw new IllegalStateException("This can only be performed on a CSS resource!");
        }
        return ConstantCSSPathProvider.builder().path(this.m_aResource.getPath()).minifiedPathFromPath().conditionalComment(this.m_sConditionalComment).cssMediaList((ICSSMediaList)this.m_aMediaList).bundlable(this.m_bIsBundlable).build();
    }

    @Nonnull
    public ConstantJSPathProvider getAsJSPathProvider() {
        if (this.m_aResource.getResourceType() != EWebSiteResourceType.JS) {
            throw new IllegalStateException("This can only be performed on a JS resource!");
        }
        return ConstantJSPathProvider.builder().path(this.m_aResource.getPath()).minifiedPathFromPath().conditionalComment(this.m_sConditionalComment).bundlable(this.m_bIsBundlable).build();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        WebSiteResourceWithCondition webSiteResourceWithCondition = (WebSiteResourceWithCondition)object;
        return this.m_aResource.equals(webSiteResourceWithCondition.m_aResource) && EqualsHelper.equals((Object)this.m_sConditionalComment, (Object)webSiteResourceWithCondition.m_sConditionalComment) && this.m_bIsBundlable == webSiteResourceWithCondition.m_bIsBundlable && EqualsHelper.equals((Object)this.m_aMediaList, (Object)webSiteResourceWithCondition.m_aMediaList);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aResource).append((Object)this.m_sConditionalComment).append(this.m_bIsBundlable).append((Object)this.m_aMediaList).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("resource", (Object)this.m_aResource).appendIfNotNull("conditionalComment", (Object)this.m_sConditionalComment).append("isBundlable", this.m_bIsBundlable).appendIfNotNull("mediaList", (Object)this.m_aMediaList).getToString();
    }

    @Nonnull
    public static WebSiteResourceWithCondition createForJS(@Nonnull IJSPathProvider iJSPathProvider, boolean bl) {
        return WebSiteResourceWithCondition.createForJS(iJSPathProvider.getJSItemPath(bl), iJSPathProvider.getConditionalComment(), iJSPathProvider.isBundlable());
    }

    @Nonnull
    public static WebSiteResourceWithCondition createForJS(@Nonnull @Nonempty String string, @Nullable String string2, boolean bl) {
        return new WebSiteResourceWithCondition(EWebSiteResourceType.JS, string, StandardCharsets.UTF_8, string2, bl, null);
    }

    @Nonnull
    public static WebSiteResourceWithCondition createForCSS(@Nonnull ICSSPathProvider iCSSPathProvider, boolean bl) {
        return WebSiteResourceWithCondition.createForCSS(iCSSPathProvider.getCSSItemPath(bl), iCSSPathProvider.getConditionalComment(), iCSSPathProvider.isBundlable(), iCSSPathProvider.getMediaList());
    }

    @Nonnull
    public static WebSiteResourceWithCondition createForCSS(@Nonnull @Nonempty String string, @Nullable String string2, boolean bl, @Nullable ICSSMediaList iCSSMediaList) {
        return new WebSiteResourceWithCondition(EWebSiteResourceType.CSS, string, StandardCharsets.UTF_8, string2, bl, iCSSMediaList);
    }
}

