/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.resource;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.EAppend;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.helper.PDTFactory;
import com.helger.html.hc.IHCNode;
import com.helger.io.resource.FileSystemResource;
import com.helger.mime.IMimeType;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.resource.WebSiteResource;
import com.helger.photon.app.resource.WebSiteResourceBundle;
import com.helger.photon.app.url.LinkHelper;
import com.helger.photon.io.WebFileIO;
import com.helger.url.ISimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSiteResourceBundleSerialized
implements IHasInputStream {
    public static final String RESOURCE_BUNDLE_PATH = "resource-bundles/";
    public static final Charset CHARSET_TO_USE = StandardCharsets.UTF_8;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSiteResourceBundleSerialized.class);
    private final String m_sBundleID;
    private final WebSiteResourceBundle m_aBundle;
    private final LocalDateTime m_aCreationDT;

    public WebSiteResourceBundleSerialized(@Nonnull @Nonempty String string, @Nonnull WebSiteResourceBundle webSiteResourceBundle, boolean bl) {
        this(string, webSiteResourceBundle, PDTFactory.getCurrentLocalDateTime());
        this._ensureSerialized(bl);
    }

    WebSiteResourceBundleSerialized(@Nonnull @Nonempty String string, @Nonnull WebSiteResourceBundle webSiteResourceBundle, @Nonnull LocalDateTime localDateTime) {
        this.m_sBundleID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"BundleID");
        this.m_aBundle = (WebSiteResourceBundle)ValueEnforcer.notNull((Object)webSiteResourceBundle, (String)"Bundle");
        this.m_aCreationDT = (LocalDateTime)ValueEnforcer.notNull((Object)localDateTime, (String)"CreationDT");
    }

    private void _ensureSerialized(boolean bl) {
        FileSystemResource fileSystemResource = WebSiteResourceBundleSerialized.getResource(this.m_sBundleID);
        if (!fileSystemResource.exists()) {
            try (Writer writer = StreamHelper.getBuffered((Writer)fileSystemResource.getWriter(StandardCharsets.UTF_8, EAppend.TRUNCATE));){
                if (writer == null) {
                    LOGGER.error("Failed to serialize " + this.m_aBundle.getResourceType().getID() + " bundle '" + this.m_sBundleID + "' with " + String.valueOf(this.m_aBundle.getAllResourcePaths()) + (String)(this.m_aBundle.hasConditionalComment() ? " and conditional comment '" + this.m_aBundle.getConditionalComment() + "'" : "") + " to path " + fileSystemResource.getAsFile().getAbsolutePath());
                } else {
                    Object object;
                    for (WebSiteResource webSiteResource : this.m_aBundle.getAllResources()) {
                        object = "/* " + webSiteResource.getPath() + " - " + webSiteResource.getContentHashAsString() + " */\n";
                        writer.write((String)object);
                    }
                    for (WebSiteResource webSiteResource : this.m_aBundle.getAllResources()) {
                        object = webSiteResource.getContent(bl);
                        if (object != null) {
                            writer.write((String)object);
                            if (StringHelper.getLastChar((CharSequence)object) == '\n') continue;
                            writer.write(10);
                            continue;
                        }
                        LOGGER.error("Web site resource '" + webSiteResource.getPath() + "' at '" + webSiteResource.getAsURLString() + "' has no content/does not exist!");
                    }
                    LOGGER.info("Serialized " + this.m_aBundle.getResourceType().getID() + " bundle '" + this.m_sBundleID + "' with " + String.valueOf(this.m_aBundle.getAllResourcePaths()) + (String)(this.m_aBundle.hasConditionalComment() ? " and conditional comment '" + this.m_aBundle.getConditionalComment() + "'" : ""));
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error serializing bundle '" + this.m_sBundleID + "' with " + String.valueOf(this.m_aBundle.getAllResourcePaths()), (Throwable)exception);
                throw new IllegalStateException(exception);
            }
        }
    }

    @Nonnull
    @Nonempty
    public String getBundleID() {
        return this.m_sBundleID;
    }

    @Nonnull
    public WebSiteResourceBundle getBundle() {
        return this.m_aBundle;
    }

    @Nullable
    public static FileSystemResource getResource(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"BundleID");
        return WebFileIO.getDataIO().getResource(RESOURCE_BUNDLE_PATH + string);
    }

    @Nullable
    public InputStream getInputStream() {
        return WebSiteResourceBundleSerialized.getResource(this.m_sBundleID).getInputStream();
    }

    public boolean isReadMultiple() {
        return true;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aBundle.getMimeType();
    }

    @Nonnull
    public LocalDateTime getCreationDT() {
        return this.m_aCreationDT;
    }

    @Nonnull
    public IHCNode createNode(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        WebSiteResource webSiteResource;
        ISimpleURL iSimpleURL = null;
        if (this.m_aBundle.getResourceCount() == 1 && !this.m_aBundle.isBundlable()) {
            webSiteResource = this.m_aBundle.getResourceAtIndex(0);
            iSimpleURL = webSiteResource.getAsURL(iRequestWebScopeWithoutResponse);
        }
        if (iSimpleURL == null) {
            iSimpleURL = LinkHelper.getURLWithContext(iRequestWebScopeWithoutResponse, PhotonAppSettings.getResourceBundleServletName() + "/" + this.m_sBundleID + this.m_aBundle.getResourceType().getFileExtension());
        }
        webSiteResource = this.m_aBundle.getResourceType().createNode(iSimpleURL, this.m_aBundle.getMediaList());
        return this.m_aBundle.getWrapped((IHCNode)webSiteResource);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BundleID", (Object)this.m_sBundleID).append("Bundle", (Object)this.m_aBundle).append("CreationDT", (Object)this.m_aCreationDT).getToString();
    }
}

