/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.resource;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.base.name.IHasDisplayName;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.html.metadata.HCLink;
import com.helger.html.hc.html.script.HCScriptFile;
import com.helger.mime.CMimeType;
import com.helger.mime.IMimeType;
import com.helger.photon.app.csrf.CSRFSessionManager;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EWebSiteResourceType implements IHasID<String>,
IHasDisplayName
{
    JS("js", CMimeType.TEXT_JAVASCRIPT, ".js", "JavaScript"){

        @Override
        @Nonnull
        public IHCNode createNode(@Nonnull ISimpleURL iSimpleURL, @Nullable ICSSMediaList iCSSMediaList) {
            HCScriptFile hCScriptFile = new HCScriptFile().setSrc(iSimpleURL);
            if (HCSettings.isUseNonceInScript()) {
                hCScriptFile.setNonce(CSRFSessionManager.getInstance().getNonce());
            }
            return hCScriptFile;
        }
    }
    ,
    CSS("css", CMimeType.TEXT_CSS, ".css", "CSS"){

        @Override
        @Nonnull
        public IHCNode createNode(@Nonnull ISimpleURL iSimpleURL, @Nullable ICSSMediaList iCSSMediaList) {
            HCLink hCLink = HCLink.createCSSLink((ISimpleURL)iSimpleURL).setMedia(iCSSMediaList);
            if (HCSettings.isUseNonceInStyle()) {
                hCLink.setNonce(CSRFSessionManager.getInstance().getNonce());
            }
            return hCLink;
        }
    };

    private final String m_sID;
    private final IMimeType m_aMimeType;
    private final String m_sFileExtension;
    private final String m_sDisplayName;

    private EWebSiteResourceType(@Nonnull @Nonempty String string2, @Nonnull @Nonempty IMimeType iMimeType, String string3, String string4) {
        this.m_sID = string2;
        this.m_aMimeType = iMimeType;
        this.m_sFileExtension = string3;
        this.m_sDisplayName = string4;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nonnull
    @Nonempty
    public String getFileExtension() {
        return this.m_sFileExtension;
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    public abstract IHCNode createNode(@Nonnull ISimpleURL var1, @Nullable ICSSMediaList var2);

    @Nullable
    public static EWebSiteResourceType getFromIDOrNull(@Nullable String string) {
        return (EWebSiteResourceType)EnumHelper.getFromIDOrNull(EWebSiteResourceType.class, (Object)string);
    }
}

