/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.mock;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.id.factory.IIntIDFactory;
import com.helger.collection.stack.NonBlockingStack;
import com.helger.photon.app.PhotonAppInit;
import com.helger.photon.io.WebFileIO;
import com.helger.photon.io.WebIOIntIDFactory;
import jakarta.annotation.Nonnull;
import java.io.File;

@Immutable
public final class PhotonAppTestInit {
    private PhotonAppTestInit() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Runnable> init(@Nonnull File file, @Nonnull @Nonempty String string) {
        NonBlockingStack nonBlockingStack = new NonBlockingStack();
        PhotonAppInit.startUp();
        WebFileIO.initPaths((File)file, (String)string, (boolean)false);
        nonBlockingStack.push(WebFileIO::resetPaths);
        if (!GlobalIDFactory.hasPersistentIntIDFactory()) {
            GlobalIDFactory.setPersistentIntIDFactory((IIntIDFactory)new WebIOIntIDFactory("ph-oton-app.id"));
            nonBlockingStack.push(() -> GlobalIDFactory.setPersistentIntIDFactory(null));
        }
        return nonBlockingStack;
    }
}

