/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.html;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.meta.IMetaElement;
import com.helger.html.meta.MetaElement;
import com.helger.html.meta.MetaElementList;
import com.helger.io.resource.IReadableResource;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xml.microdom.util.XMLMapHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PhotonMetaElements {
    public static final String DEFAULT_FILENAME = "html/metatags.xml";
    private static final String REQUEST_ATTR_METAELEMENTS = PhotonMetaElements.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonMetaElements.class);
    private static final MetaElementList GLOBAL = new MetaElementList();
    private static final SimpleLock LOCK = new SimpleLock();

    private PhotonMetaElements() {
    }

    public static void _readMetaElements(@Nonnull IReadableResource iReadableResource, @Nonnull MetaElementList metaElementList) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Res");
        ValueEnforcer.notNull((Object)metaElementList, (String)"Target");
        if (iReadableResource.exists()) {
            CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
            if (XMLMapHandler.readMap((IHasInputStream)iReadableResource, (Map)commonsLinkedHashMap).isFailure()) {
                LOGGER.error("Failed to read meta element file " + iReadableResource.getPath());
            }
            for (Map.Entry entry : commonsLinkedHashMap.entrySet()) {
                metaElementList.addMetaElement((IMetaElement)MetaElement.createMeta((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
        }
    }

    public static void readMetaElementsForGlobal(@Nonnull IReadableResource iReadableResource) {
        PhotonMetaElements._readMetaElements(iReadableResource, GLOBAL);
    }

    public static void registerMetaElementForGlobal(@Nonnull IMetaElement iMetaElement) {
        GLOBAL.addMetaElement(iMetaElement);
    }

    public static void unregisterMetaElementForGlobal(@Nullable String string) {
        GLOBAL.removeMetaElement(string);
    }

    public static void unregisterAllMetaElementsFromGlobal() {
        GLOBAL.removeAllMetaElements();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IMetaElement> getAllRegisteredMetaElementsForGlobal() {
        return GLOBAL.getAllMetaElements();
    }

    public static void getAllRegisteredMetaElementsForGlobal(@Nonnull Collection<? super IMetaElement> collection) {
        GLOBAL.getAllMetaElements(collection);
    }

    public static boolean hasRegisteredMetaElementsForGlobal() {
        return GLOBAL.hasMetaElements();
    }

    @Nullable
    private static MetaElementList _getPerRequestSet(boolean bl) {
        IRequestWebScope iRequestWebScope = WebScopeManager.getRequestScope();
        return (MetaElementList)LOCK.lockedGet(() -> PhotonMetaElements.lambda$_getPerRequestSet$0((IRequestWebScopeWithoutResponse)iRequestWebScope, bl));
    }

    public static void registerMetaElementForThisRequest(@Nonnull IMetaElement iMetaElement) {
        PhotonMetaElements._getPerRequestSet(true).addMetaElement(iMetaElement);
    }

    public static void unregisterMetaElementFromThisRequest(@Nullable String string) {
        MetaElementList metaElementList = PhotonMetaElements._getPerRequestSet(false);
        if (metaElementList != null) {
            metaElementList.removeMetaElement(string);
        }
    }

    public static void unregisterAllMetaElementsFromThisRequest() {
        MetaElementList metaElementList = PhotonMetaElements._getPerRequestSet(false);
        if (metaElementList != null) {
            metaElementList.removeAllMetaElements();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IMetaElement> getAllRegisteredMetaElementsForThisRequest() {
        MetaElementList metaElementList = PhotonMetaElements._getPerRequestSet(false);
        return metaElementList == null ? new CommonsArrayList() : metaElementList.getAllMetaElements();
    }

    public static void getAllRegisteredMetaElementsForThisRequest(@Nonnull Collection<? super IMetaElement> collection) {
        MetaElementList metaElementList = PhotonMetaElements._getPerRequestSet(false);
        if (metaElementList != null) {
            metaElementList.getAllMetaElements(collection);
        }
    }

    public static boolean hasRegisteredMetaElementsForThisRequest() {
        MetaElementList metaElementList = PhotonMetaElements._getPerRequestSet(false);
        return metaElementList != null && metaElementList.hasMetaElements();
    }

    private static /* synthetic */ MetaElementList lambda$_getPerRequestSet$0(IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, boolean bl) {
        MetaElementList metaElementList = (MetaElementList)iRequestWebScopeWithoutResponse.attrs().getCastedValue((Object)REQUEST_ATTR_METAELEMENTS);
        if (metaElementList == null && bl) {
            metaElementList = new MetaElementList();
            iRequestWebScopeWithoutResponse.attrs().putIn((Object)REQUEST_ATTR_METAELEMENTS, (Object)metaElementList);
        }
        return metaElementList;
    }
}

