/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.html;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.io.stream.HasInputStream;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.hc.IHCConversionSettings;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCConversionSettings;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.ext.HCConditionalCommentNode;
import com.helger.html.hc.html.metadata.HCCSSNodeDetector;
import com.helger.html.hc.html.metadata.HCHead;
import com.helger.html.hc.html.metadata.HCLink;
import com.helger.html.hc.html.metadata.HCMeta;
import com.helger.html.hc.html.root.HCHtml;
import com.helger.html.hc.html.script.HCJSNodeDetector;
import com.helger.html.hc.html.script.HCScriptFile;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.meta.EStandardMetaElement;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.mime.CMimeType;
import com.helger.mime.IMimeType;
import com.helger.mime.MimeType;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.csrf.CSRFSessionManager;
import com.helger.photon.app.html.IHTMLProvider;
import com.helger.photon.app.resource.IWebSiteResourceBundleProvider;
import com.helger.photon.app.resource.WebSiteResourceBundleSerialized;
import com.helger.photon.app.resource.WebSiteResourceWithCondition;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.url.ISimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.OutputStream;
import java.util.List;

@NotThreadSafe
public final class PhotonHTMLHelper {
    public static final String META_GENERATOR_VALUE = "https://github.com/phax/ph-oton // phax // ASL 2.0";

    private PhotonHTMLHelper() {
    }

    private static void _applySessionNonce(@Nonnull HCConversionSettings hCConversionSettings) {
        boolean bl = HCSettings.isUseNonceInScript();
        boolean bl2 = HCSettings.isUseNonceInStyle();
        if (bl || bl2) {
            String string = CSRFSessionManager.getInstance().getNonce();
            if (bl) {
                hCConversionSettings.setNonceScript(string);
            }
            if (bl2) {
                hCConversionSettings.setNonceStyle(string);
            }
        }
    }

    @Nonnull
    public static HCConversionSettings getHCConversionSettingsWithNonce() {
        HCConversionSettings hCConversionSettings = HCSettings.getMutableConversionSettings().getClone();
        PhotonHTMLHelper._applySessionNonce(hCConversionSettings);
        return hCConversionSettings;
    }

    @Nonnull
    public static HCConversionSettings getHCConversionSettingsWithoutNamespacesWithNonce() {
        HCConversionSettings hCConversionSettings = HCSettings.getConversionSettingsWithoutNamespaces();
        PhotonHTMLHelper._applySessionNonce(hCConversionSettings);
        return hCConversionSettings;
    }

    @Nonnull
    public static IMimeType getMimeType(@Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return new MimeType(CMimeType.TEXT_HTML).addParameter("charset", HCSettings.getHTMLCharset().name());
    }

    @Nonnull
    public static IHCNode getCSSNode(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull ICSSPathProvider iCSSPathProvider, boolean bl) {
        String string;
        HCLink hCLink = HCLink.createCSSLink((ISimpleURL)PhotonAppSettings.getCSSPath(iRequestWebScopeWithoutResponse, iCSSPathProvider, bl)).setMedia(iCSSPathProvider.getMediaList()).setPathProvider(iCSSPathProvider);
        if (HCSettings.isUseNonceInStyle()) {
            hCLink.setNonce(CSRFSessionManager.getInstance().getNonce());
        }
        if (StringHelper.isNotEmpty((String)(string = iCSSPathProvider.getConditionalComment()))) {
            return new HCConditionalCommentNode(string, (IHCNode)hCLink);
        }
        return hCLink;
    }

    @Nonnull
    public static IHCNode getJSNode(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull IJSPathProvider iJSPathProvider, boolean bl) {
        HCScriptFile hCScriptFile = new HCScriptFile().setSrc(PhotonAppSettings.getJSPath(iRequestWebScopeWithoutResponse, iJSPathProvider, bl)).setPathProvider(iJSPathProvider);
        if (HCSettings.isUseNonceInScript()) {
            hCScriptFile.setNonce(CSRFSessionManager.getInstance().getNonce());
        }
        iJSPathProvider.getScriptLoadingMode().apply(hCScriptFile);
        String string = iJSPathProvider.getConditionalComment();
        if (StringHelper.isNotEmpty((String)string)) {
            return new HCConditionalCommentNode(string, (IHCNode)hCScriptFile);
        }
        return hCScriptFile;
    }

    public static void createHTMLResponse(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse, @Nonnull IHTMLProvider iHTMLProvider) {
        HCHtml hCHtml = iHTMLProvider.createHTML(iRequestWebScopeWithoutResponse);
        hCHtml.head().metaElements().add((Object)new HCMeta().setName(EStandardMetaElement.GENERATOR.getName()).setContent(META_GENERATOR_VALUE));
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(51200);){
            IMimeType iMimeType = PhotonHTMLHelper.getMimeType(iRequestWebScopeWithoutResponse);
            HCConversionSettings hCConversionSettings = PhotonHTMLHelper.getHCConversionSettingsWithNonce();
            HCRenderer.writeHtmlTo((IHCNode)hCHtml, (IHCConversionSettings)hCConversionSettings, (OutputStream)nonBlockingByteArrayOutputStream);
            unifiedResponse.setMimeType(iMimeType).setCharset(hCConversionSettings.getCharset()).setContent(HasInputStream.create((NonBlockingByteArrayOutputStream)nonBlockingByteArrayOutputStream)).disableCaching();
        }
    }

    public static void mergeExternalCSSAndJSNodes(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull HCHead hCHead, boolean bl, boolean bl2, @Nonnull IWebSiteResourceBundleProvider iWebSiteResourceBundleProvider) {
        WebSiteResourceBundleSerialized webSiteResourceBundleSerialized;
        Object object;
        boolean bl3;
        CommonsArrayList commonsArrayList;
        CommonsArrayList commonsArrayList2;
        if (!bl && !bl2) {
            return;
        }
        boolean bl4 = HCSettings.isUseRegularResources();
        if (bl) {
            commonsArrayList2 = new CommonsArrayList();
            hCHead.getAllAndRemoveAllCSSNodes((List)commonsArrayList2);
            commonsArrayList = new CommonsArrayList();
            for (Object object2 : commonsArrayList2) {
                bl3 = true;
                if (HCCSSNodeDetector.isDirectCSSFileNode((IHCNode)object2) && (object = ((HCLink)object2).getPathProvider()) != null) {
                    commonsArrayList.add((Object)WebSiteResourceWithCondition.createForCSS((ICSSPathProvider)object, bl4));
                    bl3 = false;
                }
                if (!bl3) continue;
                if (!commonsArrayList.isEmpty()) {
                    object = iWebSiteResourceBundleProvider.getResourceBundles((ICommonsList<WebSiteResourceWithCondition>)commonsArrayList, bl4).iterator();
                    while (object.hasNext()) {
                        webSiteResourceBundleSerialized = (WebSiteResourceBundleSerialized)object.next();
                        hCHead.addCSS(webSiteResourceBundleSerialized.createNode(iRequestWebScopeWithoutResponse));
                    }
                    commonsArrayList.clear();
                }
                hCHead.addCSS((IHCNode)object2);
            }
            if (!commonsArrayList.isEmpty()) {
                for (Object object2 : iWebSiteResourceBundleProvider.getResourceBundles((ICommonsList<WebSiteResourceWithCondition>)commonsArrayList, bl4)) {
                    hCHead.addCSS(((WebSiteResourceBundleSerialized)object2).createNode(iRequestWebScopeWithoutResponse));
                }
            }
        }
        if (bl2) {
            commonsArrayList2 = new CommonsArrayList();
            hCHead.getAllAndRemoveAllJSNodes((List)commonsArrayList2);
            commonsArrayList = new CommonsArrayList();
            for (Object object2 : commonsArrayList2) {
                bl3 = true;
                if (HCJSNodeDetector.isDirectJSFileNode((IHCNode)object2) && (object = ((HCScriptFile)object2).getPathProvider()) != null) {
                    commonsArrayList.add((Object)WebSiteResourceWithCondition.createForJS((IJSPathProvider)object, bl4));
                    bl3 = false;
                }
                if (!bl3) continue;
                if (!commonsArrayList.isEmpty()) {
                    object = iWebSiteResourceBundleProvider.getResourceBundles((ICommonsList<WebSiteResourceWithCondition>)commonsArrayList, bl4).iterator();
                    while (object.hasNext()) {
                        webSiteResourceBundleSerialized = (WebSiteResourceBundleSerialized)object.next();
                        hCHead.addJS(webSiteResourceBundleSerialized.createNode(iRequestWebScopeWithoutResponse));
                    }
                    commonsArrayList.clear();
                }
                hCHead.addJS((IHCNode)object2);
            }
            if (!commonsArrayList.isEmpty()) {
                for (Object object2 : iWebSiteResourceBundleProvider.getResourceBundles((ICommonsList<WebSiteResourceWithCondition>)commonsArrayList, bl4)) {
                    hCHead.addJS(((WebSiteResourceBundleSerialized)object2).createNode(iRequestWebScopeWithoutResponse));
                }
            }
        }
    }
}

