/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.html;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ECSSMedium;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.resource.css.ConstantCSSPathProvider;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.io.resource.IReadableResource;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.html.CSSResourceSet;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PhotonCSS {
    public static final String DEFAULT_FILENAME = "html/css.xml";
    private static final String REQUEST_ATTR_CSSRESOURCES = PhotonCSS.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonCSS.class);
    private static final CSSResourceSet GLOBAL = new CSSResourceSet();
    private static final SimpleLock LOCK = new SimpleLock();

    private PhotonCSS() {
    }

    public static void _readCSSIncludes(@Nonnull IReadableResource iReadableResource, @Nonnull CSSResourceSet cSSResourceSet) {
        IMicroDocument iMicroDocument;
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Res");
        ValueEnforcer.notNull((Object)cSSResourceSet, (String)"Target");
        IMicroDocument iMicroDocument2 = iMicroDocument = iReadableResource.exists() ? MicroReader.readMicroXML((IReadableResource)iReadableResource) : null;
        if (iMicroDocument != null) {
            for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("css")) {
                String string = iMicroElement.getAttributeValue("path");
                if (StringHelper.isEmpty((String)string)) {
                    LOGGER.error("Found CSS item without a path in " + iReadableResource.getPath());
                    continue;
                }
                IReadableResource iReadableResource2 = PhotonAppSettings.getURIToURLConverter().getAsResource(string);
                if (!iReadableResource2.exists()) {
                    throw new IllegalStateException("The provided global CSS resource '" + string + "' resolved to '" + String.valueOf(iReadableResource2) + "' does NOT exist!");
                }
                String string2 = iMicroElement.getAttributeValue("condcomment");
                String string3 = iMicroElement.getAttributeValue("media");
                CSSMediaList cSSMediaList = new CSSMediaList();
                if (string3 != null) {
                    for (String string4 : RegExHelper.getSplitToArray((CharSequence)string3, (String)",\\s*")) {
                        ECSSMedium eCSSMedium = ECSSMedium.getFromNameOrNull((String)string4);
                        if (eCSSMedium == null) {
                            LOGGER.warn("CSS item '" + string + "' in " + iReadableResource.getPath() + " has an invalid medium '" + string4 + "' - ignoring");
                            continue;
                        }
                        cSSMediaList.addMedium(eCSSMedium);
                    }
                }
                cSSResourceSet.addItem((ICSSPathProvider)ConstantCSSPathProvider.builder().path(string).minifiedPathFromPath().conditionalComment(string2).cssMediaList((ICSSMediaList)cSSMediaList).build());
            }
        }
    }

    public static void readCSSIncludesForGlobal(@Nonnull IReadableResource iReadableResource) {
        PhotonCSS._readCSSIncludes(iReadableResource, GLOBAL);
    }

    public static void registerCSSIncludeForGlobal(@Nonnull ICSSPathProvider iCSSPathProvider) {
        GLOBAL.addItem(iCSSPathProvider);
    }

    public static void registerCSSIncludeForGlobal(int n, @Nonnull ICSSPathProvider iCSSPathProvider) {
        GLOBAL.addItem(n, iCSSPathProvider);
    }

    public static void unregisterCSSIncludeForGlobal(@Nonnull ICSSPathProvider iCSSPathProvider) {
        GLOBAL.removeItem(iCSSPathProvider);
    }

    public static void unregisterAllCSSIncludesFromGlobal() {
        GLOBAL.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<ICSSPathProvider> getAllRegisteredCSSIncludesForGlobal() {
        return GLOBAL.getAllItems();
    }

    public static void getAllRegisteredCSSIncludesForGlobal(@Nonnull Collection<? super ICSSPathProvider> collection) {
        GLOBAL.getAllItems(collection);
    }

    public static boolean hasRegisteredCSSIncludesForGlobal() {
        return GLOBAL.isNotEmpty();
    }

    @Nullable
    private static CSSResourceSet _getPerRequestSet(boolean bl) {
        IRequestWebScope iRequestWebScope = WebScopeManager.getRequestScope();
        return (CSSResourceSet)LOCK.lockedGet(() -> PhotonCSS.lambda$_getPerRequestSet$0((IRequestWebScopeWithoutResponse)iRequestWebScope, bl));
    }

    public static void registerCSSIncludeForThisRequest(@Nonnull ICSSPathProvider iCSSPathProvider) {
        PhotonCSS._getPerRequestSet(true).addItem(iCSSPathProvider);
    }

    public static void unregisterCSSIncludeFromThisRequest(@Nonnull ICSSPathProvider iCSSPathProvider) {
        CSSResourceSet cSSResourceSet = PhotonCSS._getPerRequestSet(false);
        if (cSSResourceSet != null) {
            cSSResourceSet.removeItem(iCSSPathProvider);
        }
    }

    public static void unregisterAllCSSIncludesFromThisRequest() {
        CSSResourceSet cSSResourceSet = PhotonCSS._getPerRequestSet(false);
        if (cSSResourceSet != null) {
            cSSResourceSet.removeAll();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<ICSSPathProvider> getAllRegisteredCSSIncludesForThisRequest() {
        CSSResourceSet cSSResourceSet = PhotonCSS._getPerRequestSet(false);
        if (cSSResourceSet == null) {
            return new CommonsLinkedHashSet();
        }
        cSSResourceSet.markAsCollected();
        return cSSResourceSet.getAllItems();
    }

    public static void getAllRegisteredCSSIncludesForThisRequest(@Nonnull Collection<? super ICSSPathProvider> collection) {
        CSSResourceSet cSSResourceSet = PhotonCSS._getPerRequestSet(false);
        if (cSSResourceSet != null) {
            cSSResourceSet.markAsCollected();
            cSSResourceSet.getAllItems(collection);
        }
    }

    public static boolean hasRegisteredCSSIncludesForThisRequest() {
        CSSResourceSet cSSResourceSet = PhotonCSS._getPerRequestSet(false);
        return cSSResourceSet != null && cSSResourceSet.isNotEmpty();
    }

    private static /* synthetic */ CSSResourceSet lambda$_getPerRequestSet$0(IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, boolean bl) {
        CSSResourceSet cSSResourceSet = (CSSResourceSet)iRequestWebScopeWithoutResponse.attrs().getCastedValue((Object)REQUEST_ATTR_CSSRESOURCES);
        if (cSSResourceSet == null && bl) {
            cSSResourceSet = new CSSResourceSet();
            iRequestWebScopeWithoutResponse.attrs().putIn((Object)REQUEST_ATTR_CSSRESOURCES, (Object)cSSResourceSet);
        }
        return cSSResourceSet;
    }
}

