/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.html;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.photon.app.html.IWebResourceSet;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CSSResourceSet
implements IWebResourceSet<ICSSPathProvider> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSResourceSet.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<ICSSPathProvider> m_aList = new CommonsArrayList();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<ICSSPathProvider> m_aSet = new CommonsHashSet();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bIsCollected = false;

    public CSSResourceSet() {
    }

    public CSSResourceSet(@Nonnull CSSResourceSet cSSResourceSet) {
        ValueEnforcer.notNull((Object)cSSResourceSet, (String)"Other");
        Iterator<ICSSPathProvider> iterator = cSSResourceSet.iterator();
        while (iterator.hasNext()) {
            ICSSPathProvider iCSSPathProvider = iterator.next();
            this.addItem(iCSSPathProvider);
        }
    }

    public CSSResourceSet(@Nonnull Collection<? extends ICSSPathProvider> collection) {
        ValueEnforcer.notEmptyNoNullValue(collection, (String)"Other");
        for (ICSSPathProvider iCSSPathProvider : collection) {
            this.addItem(iCSSPathProvider);
        }
    }

    public CSSResourceSet(ICSSPathProvider ... iCSSPathProviderArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iCSSPathProviderArray, (String)"Other");
        for (ICSSPathProvider iCSSPathProvider : iCSSPathProviderArray) {
            this.addItem(iCSSPathProvider);
        }
    }

    private static void _collectWarn(@Nonnull String string) {
        LOGGER.warn(string);
    }

    @Override
    @Nonnull
    public EChange addItem(@Nonnull ICSSPathProvider iCSSPathProvider) {
        return this.addItem(-1, iCSSPathProvider);
    }

    @Override
    @Nonnull
    public EChange addItem(int n, @Nonnull ICSSPathProvider iCSSPathProvider) {
        ValueEnforcer.notNull((Object)iCSSPathProvider, (String)"CSSPathProvider");
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (!this.m_aSet.add((Object)iCSSPathProvider)) {
                return EChange.UNCHANGED;
            }
            if (n >= 0) {
                this.m_aList.add(n, (Object)iCSSPathProvider);
            } else {
                this.m_aList.add((Object)iCSSPathProvider);
            }
            if (this.m_bIsCollected) {
                CSSResourceSet._collectWarn("Adding item " + String.valueOf(iCSSPathProvider) + " after collection!");
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    public EChange addItems(@Nonnull IWebResourceSet<? extends ICSSPathProvider> iWebResourceSet) {
        ValueEnforcer.notNull(iWebResourceSet, (String)"Items");
        EChange eChange = EChange.UNCHANGED;
        Iterator iterator = iWebResourceSet.iterator();
        while (iterator.hasNext()) {
            ICSSPathProvider iCSSPathProvider = (ICSSPathProvider)iterator.next();
            eChange = eChange.or((IChangeIndicator)this.addItem(iCSSPathProvider));
        }
        return eChange;
    }

    @Override
    @Nonnull
    public EChange addItems(int n, @Nonnull IWebResourceSet<? extends ICSSPathProvider> iWebResourceSet) {
        ValueEnforcer.notNull(iWebResourceSet, (String)"Items");
        if (n < 0) {
            return this.addItems(iWebResourceSet);
        }
        EChange eChange = EChange.UNCHANGED;
        int n2 = n;
        Iterator iterator = iWebResourceSet.iterator();
        while (iterator.hasNext()) {
            ICSSPathProvider iCSSPathProvider = (ICSSPathProvider)iterator.next();
            if (!this.addItem(n2, iCSSPathProvider).isChanged()) continue;
            eChange = EChange.CHANGED;
            ++n2;
        }
        return eChange;
    }

    @Override
    @Nonnull
    public EChange removeItem(@Nonnull ICSSPathProvider iCSSPathProvider) {
        ValueEnforcer.notNull((Object)iCSSPathProvider, (String)"CSSPathProvider");
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (!this.m_aSet.remove((Object)iCSSPathProvider)) {
                return EChange.UNCHANGED;
            }
            this.m_aList.remove((Object)iCSSPathProvider);
            if (this.m_bIsCollected) {
                CSSResourceSet._collectWarn("Removed item " + String.valueOf(iCSSPathProvider) + " after collection!");
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    public EChange removeAll() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aSet.isEmpty()) {
                return EChange.UNCHANGED;
            }
            this.m_aSet.clear();
            this.m_aList.clear();
            if (this.m_bIsCollected) {
                CSSResourceSet._collectWarn("Removed all items after collection!");
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<ICSSPathProvider> getAllItems() {
        return (ICommonsOrderedSet)this.m_aRWLock.readLockedGet(() -> new CommonsLinkedHashSet(this.m_aList));
    }

    @Override
    public void getAllItems(@Nonnull Collection<? super ICSSPathProvider> collection) {
        ValueEnforcer.notNull(collection, (String)"Target");
        this.m_aRWLock.readLockedBoolean(() -> collection.addAll((Collection<? super ICSSPathProvider>)this.m_aList));
    }

    @Override
    public boolean isEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aList.isEmpty());
    }

    @Override
    public boolean isNotEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aList.isNotEmpty());
    }

    @Nonnegative
    public int size() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aList.size());
    }

    @Nonnull
    public Iterator<ICSSPathProvider> iterator() {
        return (Iterator)this.m_aRWLock.readLockedGet(() -> this.m_aList.iterator());
    }

    public boolean isCollected() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bIsCollected);
    }

    @Override
    public void markAsCollected() {
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_bIsCollected) {
                CSSResourceSet._collectWarn("Resource set was already collected before!");
            }
            this.m_bIsCollected = true;
        });
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSResourceSet cSSResourceSet = (CSSResourceSet)object;
        return this.m_aList.equals(cSSResourceSet.m_aList);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aList).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("list", this.m_aList).getToString();
    }
}

