/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.csrf;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.app.csrf.CSRFManager;
import com.helger.scope.IScope;
import com.helger.web.scope.singleton.AbstractSessionWebSingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CSRFSessionManager
extends AbstractSessionWebSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSRFSessionManager.class);
    @GuardedBy(value="m_aRWLock")
    private String m_sNonce = CSRFManager.getInstance().createNewNonce();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public CSRFSessionManager() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created CSRF session nonce '" + this.m_sNonce + "'");
        }
    }

    @Nonnull
    public static CSRFSessionManager getInstance() {
        return (CSRFSessionManager)CSRFSessionManager.getSessionSingleton(CSRFSessionManager.class);
    }

    protected void onDestroy(@Nonnull IScope iScope) {
        this.m_aRWLock.writeLocked(() -> {
            CSRFManager cSRFManager = CSRFManager.getInstanceIfInstantiated();
            if (cSRFManager != null) {
                cSRFManager.removeNonce(this.m_sNonce);
            }
            this.m_sNonce = null;
        });
    }

    @Nonnull
    @Nonempty
    public String getNonce() {
        return (String)this.m_aRWLock.readLockedGet(() -> this.m_sNonce);
    }

    public boolean isExpectedNonce(@Nullable String string) {
        String string2 = this.getNonce();
        return StringHelper.isNotEmpty((String)string2) && string2.equals(string) && CSRFManager.getInstance().isValidNonce(string);
    }

    public void generateNewNonce() {
        CSRFManager cSRFManager = CSRFManager.getInstance();
        this.m_aRWLock.writeLocked(() -> {
            cSRFManager.removeNonce(this.m_sNonce);
            this.m_sNonce = cSRFManager.createNewNonce();
        });
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Nonce", (Object)this.m_sNonce).getToString();
    }
}

