/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app;

import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.exception.InitializationException;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.photon.app.resource.WebSiteResourceBundleManager;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhotonAppManager
extends AbstractGlobalSingleton {
    public static final String WEBSITE_RESOURCE_BUNDLES_XML = "resource-bundles.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonAppManager.class);
    private WebSiteResourceBundleManager m_aWebSiteResourceBundleMgr;

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public PhotonAppManager() {
    }

    protected void onAfterInstantiation(@Nonnull IScope iScope) {
        try {
            this.m_aWebSiteResourceBundleMgr = new WebSiteResourceBundleManager(WEBSITE_RESOURCE_BUNDLES_XML);
            LOGGER.info(ClassHelper.getClassLocalName((Object)((Object)this)) + " was initialized");
        }
        catch (Exception exception) {
            throw new InitializationException("Failed to init " + ClassHelper.getClassLocalName((Object)((Object)this)), (Throwable)exception);
        }
    }

    @Nonnull
    public static PhotonAppManager getInstance() {
        return (PhotonAppManager)PhotonAppManager.getGlobalSingleton(PhotonAppManager.class);
    }

    @Nonnull
    public static WebSiteResourceBundleManager getWebSiteResourceBundleMgr() {
        return PhotonAppManager.getInstance().m_aWebSiteResourceBundleMgr;
    }
}

