/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api.servlet;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.numeric.mutable.MutableInt;
import com.helger.base.reflection.GenericReflection;
import com.helger.http.EHttpMethod;
import com.helger.http.EHttpVersion;
import com.helger.photon.api.APIPath;
import com.helger.photon.api.GlobalAPIInvoker;
import com.helger.photon.api.IAPIInvoker;
import com.helger.photon.api.IAPIRegistry;
import com.helger.photon.api.InvokableAPIDescriptor;
import com.helger.photon.app.PhotonUnifiedResponse;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIXServletHandler
implements IXServletSimpleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIXServletHandler.class);
    private final Supplier<? extends IAPIRegistry> m_aRegistryFactory;
    private final Supplier<? extends IAPIInvoker> m_aInvokerFactory;

    public APIXServletHandler() {
        this(() -> GlobalAPIInvoker.getInstance().getRegistry(), () -> GlobalAPIInvoker.getInstance().getInvoker());
    }

    public APIXServletHandler(@Nonnull Supplier<? extends IAPIRegistry> supplier, @Nonnull Supplier<? extends IAPIInvoker> supplier2) {
        this.m_aRegistryFactory = (Supplier)ValueEnforcer.notNull(supplier, (String)"RegistryFactory");
        this.m_aInvokerFactory = (Supplier)ValueEnforcer.notNull(supplier2, (String)"InvokerFactory");
    }

    @Nonnull
    public PhotonUnifiedResponse createUnifiedResponse(@Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull HttpServletRequest httpServletRequest, @Nonnull IRequestWebScope iRequestWebScope) {
        return new PhotonUnifiedResponse(eHttpVersion, eHttpMethod, httpServletRequest, (IRequestWebScopeWithoutResponse)iRequestWebScope);
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        EHttpMethod eHttpMethod = iRequestWebScopeWithoutResponse.getHttpMethod();
        if (eHttpMethod == null) {
            LOGGER.error("Missing HTTP method in request: " + String.valueOf(iRequestWebScopeWithoutResponse.getRequest()));
            unifiedResponse.setStatus(501);
            return;
        }
        APIPath aPIPath = APIPath.createForServlet(iRequestWebScopeWithoutResponse);
        IAPIRegistry iAPIRegistry = this.m_aRegistryFactory.get();
        IAPIInvoker iAPIInvoker = this.m_aInvokerFactory.get();
        InvokableAPIDescriptor invokableAPIDescriptor = iAPIRegistry.getAPIByPath(aPIPath);
        if (invokableAPIDescriptor == null) {
            LOGGER.warn("Unknown API " + String.valueOf(eHttpMethod) + " '" + aPIPath.getPath() + "' requested!");
            unifiedResponse.setStatus(404);
        } else {
            MutableInt mutableInt = new MutableInt(400);
            if (!invokableAPIDescriptor.canExecute(iRequestWebScopeWithoutResponse, mutableInt)) {
                int n = mutableInt.intValue();
                LOGGER.warn("API " + String.valueOf(eHttpMethod) + " '" + aPIPath.getPath() + "' cannot be executed for the current request. Returning HTTP " + n);
                unifiedResponse.setStatus(n);
            } else {
                unifiedResponse.disableCaching();
                try {
                    iAPIInvoker.invoke(invokableAPIDescriptor, iRequestWebScopeWithoutResponse, (UnifiedResponse)GenericReflection.uncheckedCast((Object)unifiedResponse));
                    if (unifiedResponse.isStatusCodeDefined() || unifiedResponse.isRedirectDefined()) {
                        unifiedResponse.disableCaching();
                    } else if (!(unifiedResponse.isStatusCodeDefined() || unifiedResponse.isRedirectDefined() || unifiedResponse.hasContent())) {
                        unifiedResponse.setStatus(204);
                    }
                }
                catch (ServletException | IOException throwable) {
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new ServletException("Error invoking API " + String.valueOf(eHttpMethod) + " '" + aPIPath.getPath() + "'", (Throwable)exception);
                }
            }
        }
    }
}

