/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api.pathdescriptor;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExHelper;
import com.helger.photon.api.pathdescriptor.EPathDescriptorVariableConstraintType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PathDescriptorVariableConstraint
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathDescriptorVariableConstraint.class);
    private final EPathDescriptorVariableConstraintType m_eConstraintType;
    private final String m_sConstraintValue;

    private PathDescriptorVariableConstraint(@Nonnull EPathDescriptorVariableConstraintType ePathDescriptorVariableConstraintType, @Nullable String string) {
        this.m_eConstraintType = (EPathDescriptorVariableConstraintType)((Object)ValueEnforcer.notNull((Object)((Object)ePathDescriptorVariableConstraintType), (String)"ConstraintType"));
        this.m_sConstraintValue = string;
    }

    @Nonnull
    public EPathDescriptorVariableConstraintType getConstraintType() {
        return this.m_eConstraintType;
    }

    @Nullable
    public String getConstraintValue() {
        return this.m_sConstraintValue;
    }

    public boolean matches(String string) {
        switch (this.m_eConstraintType) {
            case REGEX: {
                return RegExHelper.stringMatchesPattern((String)this.m_sConstraintValue, (String)string);
            }
        }
        throw new IllegalStateException("Constraint type " + String.valueOf((Object)this.m_eConstraintType) + " is not implemented yet!");
    }

    @Nonnull
    @Nonempty
    public String getAsURLString() {
        if (this.m_eConstraintType.isRequiresValue()) {
            return this.m_eConstraintType.getID() + "=" + this.m_sConstraintValue;
        }
        return this.m_eConstraintType.getID();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PathDescriptorVariableConstraint pathDescriptorVariableConstraint = (PathDescriptorVariableConstraint)object;
        return this.m_eConstraintType.equals((Object)pathDescriptorVariableConstraint.m_eConstraintType) && EqualsHelper.equals((Object)this.m_sConstraintValue, (Object)pathDescriptorVariableConstraint.m_sConstraintValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_eConstraintType).append((Object)this.m_sConstraintValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("ConstraintType", (Enum)this.m_eConstraintType).appendIfNotNull("ConstraintValue", (Object)this.m_sConstraintValue).getToString();
    }

    @Nullable
    public static PathDescriptorVariableConstraint createOrNull(@Nonnull String string) {
        String string2;
        String string3 = StringHelper.trim((String)string);
        if (StringHelper.isEmpty((String)string3)) {
            LOGGER.warn("Empty path descriptor variable constraint is ignored!");
            return null;
        }
        List list = StringHelper.getExploded((char)'=', (String)string, (int)2);
        String string4 = (String)list.get(0);
        EPathDescriptorVariableConstraintType ePathDescriptorVariableConstraintType = EPathDescriptorVariableConstraintType.getFromIDOrNull(string4);
        if (ePathDescriptorVariableConstraintType == null) {
            LOGGER.error("Unsupported variable constraint type '" + string4 + "' used!");
            return null;
        }
        String string5 = string2 = list.size() > 1 ? (String)list.get(1) : null;
        if (ePathDescriptorVariableConstraintType.isRequiresValue() && StringHelper.isEmpty((String)string2)) {
            LOGGER.error("Variable constraint type '" + string4 + "' requires a value but no value provided! Separate type and value with a '=' character.");
            return null;
        }
        return new PathDescriptorVariableConstraint(ePathDescriptorVariableConstraintType, string2);
    }
}

