/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api.pathdescriptor;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.photon.api.pathdescriptor.PathDescriptorVariableConstraint;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.List;

@Immutable
public final class PathDescriptorPart
implements Serializable {
    public static final String VARIABLE_START = "{";
    public static final String VARIABLE_END = "}";
    public static final char CONSTRAINT_SEPARATOR = ':';
    private static final int MIN_VARIABLE_LENGTH = "{".length() + "}".length();
    private final boolean m_bIsVariable;
    private final String m_sName;
    private final ICommonsList<PathDescriptorVariableConstraint> m_aVariableConstraints;

    private PathDescriptorPart(boolean bl, @Nonnull @Nonempty String string, @Nullable ICommonsList<PathDescriptorVariableConstraint> iCommonsList) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        this.m_bIsVariable = bl;
        this.m_sName = string;
        this.m_aVariableConstraints = iCommonsList;
    }

    public boolean isVariable() {
        return this.m_bIsVariable;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PathDescriptorVariableConstraint> getAllVariableConstraints() {
        return new CommonsArrayList(this.m_aVariableConstraints);
    }

    public boolean matches(@Nonnull String string) {
        if (this.m_bIsVariable) {
            if (this.m_aVariableConstraints != null) {
                for (PathDescriptorVariableConstraint pathDescriptorVariableConstraint : this.m_aVariableConstraints) {
                    if (pathDescriptorVariableConstraint.matches(string)) continue;
                    return false;
                }
            }
            return true;
        }
        return this.m_sName.equals(string);
    }

    @Nonnull
    @Nonempty
    public String getAsURLString() {
        if (this.m_bIsVariable) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(VARIABLE_START).append(this.m_sName);
            if (this.m_aVariableConstraints != null) {
                for (PathDescriptorVariableConstraint pathDescriptorVariableConstraint : this.m_aVariableConstraints) {
                    stringBuilder.append(':').append(pathDescriptorVariableConstraint.getAsURLString());
                }
            }
            stringBuilder.append(VARIABLE_END);
            return stringBuilder.toString();
        }
        return this.m_sName;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PathDescriptorPart pathDescriptorPart = (PathDescriptorPart)object;
        return this.m_bIsVariable == pathDescriptorPart.m_bIsVariable && this.m_sName.equals(pathDescriptorPart.m_sName) && EqualsHelper.equals(this.m_aVariableConstraints, pathDescriptorPart.m_aVariableConstraints);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_bIsVariable).append((Object)this.m_sName).append(this.m_aVariableConstraints).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("IsVariable", this.m_bIsVariable).append("Name", (Object)this.m_sName).appendIf("VariableConstraints", this.m_aVariableConstraints, CollectionHelper::isNotEmpty).getToString();
    }

    @Nonnull
    @Nonempty
    public static String getVariableName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.isFalse(() -> string.startsWith(VARIABLE_START), () -> "Name is already a variable: '" + string + "'");
        return VARIABLE_START + string + VARIABLE_END;
    }

    @Nonnull
    public static PathDescriptorPart create(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"PathPart");
        if (string.length() > MIN_VARIABLE_LENGTH && string.startsWith(VARIABLE_START) && string.endsWith(VARIABLE_END)) {
            String string2 = string.substring(VARIABLE_START.length(), string.length() - VARIABLE_END.length());
            List list = StringHelper.getExploded((char)':', (String)string2);
            String string3 = (String)list.get(0);
            CommonsArrayList commonsArrayList = null;
            int n = list.size();
            if (n > 1) {
                for (int i = 1; i < n; ++i) {
                    String string4 = (String)list.get(i);
                    PathDescriptorVariableConstraint pathDescriptorVariableConstraint = PathDescriptorVariableConstraint.createOrNull(string4);
                    if (pathDescriptorVariableConstraint == null) continue;
                    if (commonsArrayList == null) {
                        commonsArrayList = new CommonsArrayList();
                    }
                    commonsArrayList.add((Object)pathDescriptorVariableConstraint);
                }
            }
            return new PathDescriptorPart(true, string3, (ICommonsList<PathDescriptorVariableConstraint>)commonsArrayList);
        }
        return new PathDescriptorPart(false, string, null);
    }
}

