/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.api.APIInvoker;
import com.helger.photon.api.APIRegistry;
import com.helger.photon.api.IAPIInvoker;
import com.helger.photon.api.IAPIRegistry;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import jakarta.annotation.Nonnull;

@ThreadSafe
public class GlobalAPIInvoker
extends AbstractGlobalWebSingleton {
    @GuardedBy(value="m_aRWLock")
    private IAPIRegistry m_aRegistry = new APIRegistry();
    @GuardedBy(value="m_aRWLock")
    private IAPIInvoker m_aInvoker = new APIInvoker();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public GlobalAPIInvoker() {
    }

    @Nonnull
    public static GlobalAPIInvoker getInstance() {
        return (GlobalAPIInvoker)GlobalAPIInvoker.getGlobalSingleton(GlobalAPIInvoker.class);
    }

    public void resetToDefault() {
        this.m_aRegistry = new APIRegistry();
        this.m_aInvoker = new APIInvoker();
    }

    @Nonnull
    public IAPIRegistry getRegistry() {
        return (IAPIRegistry)this.m_aRWLock.readLockedGet(() -> this.m_aRegistry);
    }

    public void setRegistry(@Nonnull IAPIRegistry iAPIRegistry) {
        ValueEnforcer.notNull((Object)iAPIRegistry, (String)"Registry");
        if (this.m_aRWLock.readLockedBoolean(() -> this.m_aRegistry.getAllAPIDescriptors().isNotEmpty())) {
            throw new IllegalStateException("Cannot change the registry after an API was registered!");
        }
        this.m_aRWLock.writeLocked(() -> {
            this.m_aRegistry = iAPIRegistry;
        });
    }

    @Nonnull
    public IAPIInvoker getInvoker() {
        return (IAPIInvoker)this.m_aRWLock.readLockedGet(() -> this.m_aInvoker);
    }

    public void setInvoker(@Nonnull IAPIInvoker iAPIInvoker) {
        ValueEnforcer.notNull((Object)iAPIInvoker, (String)"Invoker");
        this.m_aRWLock.writeLocked(() -> {
            this.m_aInvoker = iAPIInvoker;
        });
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Registry", (Object)this.m_aRegistry).append("Invoker", (Object)this.m_aInvoker).getToString();
    }
}

