/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.http.EHttpMethod;
import com.helger.io.file.FilenameHelper;
import com.helger.servlet.request.RequestHelper;
import com.helger.url.SimpleURL;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;

@Immutable
@MustImplementEqualsAndHashcode
public class APIPath
implements Serializable {
    private final EHttpMethod m_eHttpMethod;
    private final String m_sPath;

    public APIPath(@Nonnull EHttpMethod eHttpMethod, @Nonnull @Nonempty String string) {
        this.m_eHttpMethod = (EHttpMethod)ValueEnforcer.notNull((Object)eHttpMethod, (String)"HttpMethod");
        this.m_sPath = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
    }

    @Nonnull
    public EHttpMethod getHttpMethod() {
        return this.m_eHttpMethod;
    }

    @Nonnull
    @Nonempty
    public String getPath() {
        return this.m_sPath;
    }

    @Nonnull
    public SimpleURL getInvocationURL(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"BasePath");
        return new SimpleURL(string + this.m_sPath);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        APIPath aPIPath = (APIPath)object;
        return this.m_eHttpMethod.equals((Object)aPIPath.m_eHttpMethod) && this.m_sPath.equals(aPIPath.m_sPath);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_eHttpMethod).append((Object)this.m_sPath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("HTTPMethod", (Enum)this.m_eHttpMethod).append("Path", (Object)this.m_sPath).getToString();
    }

    @Nonnull
    public static APIPath get(@Nonnull @Nonempty String string) {
        return new APIPath(EHttpMethod.GET, string);
    }

    @Nonnull
    public static APIPath post(@Nonnull @Nonempty String string) {
        return new APIPath(EHttpMethod.POST, string);
    }

    @Nonnull
    public static APIPath put(@Nonnull @Nonempty String string) {
        return new APIPath(EHttpMethod.PUT, string);
    }

    @Nonnull
    public static APIPath delete(@Nonnull @Nonempty String string) {
        return new APIPath(EHttpMethod.DELETE, string);
    }

    @Nonnull
    public static APIPath createForFilter(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        Object object = RequestHelper.getPathWithinServletContext((HttpServletRequest)iRequestWebScopeWithoutResponse.getRequest(), (boolean)true);
        if (object != null && !FilenameHelper.startsWithPathSeparatorChar((CharSequence)object)) {
            object = "/" + (String)object;
        }
        return new APIPath(iRequestWebScopeWithoutResponse.getHttpMethod(), (String)object);
    }

    @Nonnull
    public static APIPath createForServlet(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        Object object = RequestHelper.getPathWithinServlet((HttpServletRequest)iRequestWebScopeWithoutResponse.getRequest(), (boolean)true);
        if (object != null && !FilenameHelper.startsWithPathSeparatorChar((CharSequence)object)) {
            object = "/" + (String)object;
        }
        return new APIPath(iRequestWebScopeWithoutResponse.getHttpMethod(), (String)object);
    }
}

