/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.ajax.callback;

import com.helger.base.debug.GlobalDebug;
import com.helger.base.io.stream.StreamHelper;
import com.helger.photon.ajax.IAjaxInvoker;
import com.helger.photon.ajax.callback.IAjaxExceptionCallback;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.servlet.request.RequestLogger;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingAjaxExceptionCallback
implements IAjaxExceptionCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingAjaxExceptionCallback.class);

    @Override
    public void onAjaxExecutionException(@Nullable IAjaxInvoker iAjaxInvoker, @Nullable String string, @Nonnull IAjaxExecutor iAjaxExecutor, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull Exception exception) {
        if (exception instanceof IOException) {
            if (!StreamHelper.isKnownEOFException((Throwable)exception)) {
                LOGGER.error("Error writing result of Ajax function '" + string + "' with " + String.valueOf(iAjaxExecutor), (Throwable)exception);
            }
        } else {
            LOGGER.error("Error invoking Ajax function '" + string + "' on " + String.valueOf(iAjaxExecutor), (Throwable)exception);
            if (GlobalDebug.isDebugMode()) {
                RequestLogger.logRequestComplete((HttpServletRequest)iRequestWebScopeWithoutResponse.getRequest());
            }
        }
    }
}

