/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.ajax;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.photon.ajax.IAjaxRegistry;
import com.helger.photon.ajax.decl.IAjaxFunctionDeclaration;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AjaxRegistry
implements IAjaxRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(AjaxRegistry.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, IAjaxFunctionDeclaration> m_aFuncDecls = new CommonsHashMap();

    public static boolean isValidFunctionName(@Nullable String string) {
        return StringHelper.isNotEmpty((String)string) && RegExHelper.stringMatchesPattern((String)"^[a-zA-Z0-9\\-_]+$", (String)string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, IAjaxFunctionDeclaration> getAllRegisteredFunctions() {
        return (ICommonsMap)this.m_aRWLock.readLockedGet(() -> this.m_aFuncDecls.getClone());
    }

    @Override
    @Nullable
    public IAjaxFunctionDeclaration getRegisteredFunction(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (IAjaxFunctionDeclaration)this.m_aRWLock.readLockedGet(() -> (IAjaxFunctionDeclaration)this.m_aFuncDecls.get((Object)string));
    }

    @Override
    public boolean isRegisteredFunction(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aFuncDecls.containsKey((Object)string));
    }

    @Override
    public void registerFunction(@Nonnull IAjaxFunctionDeclaration iAjaxFunctionDeclaration) {
        ValueEnforcer.notNull((Object)iAjaxFunctionDeclaration, (String)"FunctionDeclaration");
        String string = iAjaxFunctionDeclaration.getName();
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aFuncDecls.containsKey((Object)string)) {
                throw new IllegalArgumentException("An Ajax function with the name '" + string + "' is already registered. Replacing the old declaration.");
            }
            this.m_aFuncDecls.put((Object)string, (Object)iAjaxFunctionDeclaration);
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered AJAX function '" + string + "' with executor factory " + String.valueOf(iAjaxFunctionDeclaration.getExecutorFactory()));
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("FuncDecls", this.m_aFuncDecls).getToString();
    }
}

