/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.ajax;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.timing.StopWatch;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.ajax.AjaxSettings;
import com.helger.photon.ajax.IAjaxInvoker;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.app.PhotonUnifiedResponse;
import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedCounter;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedTimer;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class AjaxInvoker
implements IAjaxInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AjaxInvoker.class);
    private static final IMutableStatisticsHandlerCounter STATS_GLOBAL_INVOKE = StatisticsManager.getCounterHandler((String)(AjaxInvoker.class.getName() + "$invocations"));
    private static final IMutableStatisticsHandlerKeyedCounter STATS_FUNCTION_INVOKE = StatisticsManager.getKeyedCounterHandler((String)(AjaxInvoker.class.getName() + "$func"));
    private static final IMutableStatisticsHandlerKeyedTimer STATS_FUNCTION_TIMER = StatisticsManager.getKeyedTimerHandler((String)(AjaxInvoker.class.getName() + "$timer"));

    @Override
    public void invokeFunction(@Nonnull String string, @Nonnull IAjaxExecutor iAjaxExecutor, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull PhotonUnifiedResponse photonUnifiedResponse) throws Exception {
        ValueEnforcer.notNull((Object)string, (String)"FunctionName");
        ValueEnforcer.notNull((Object)iAjaxExecutor, (String)"AjaxExecutor");
        ValueEnforcer.notNull((Object)iRequestWebScopeWithoutResponse, (String)"RequestScope");
        ValueEnforcer.notNull((Object)photonUnifiedResponse, (String)"AjaxResponse");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invoking Ajax function '" + string + "'");
        }
        try {
            StopWatch stopWatch = StopWatch.createdStarted();
            STATS_GLOBAL_INVOKE.increment();
            AjaxSettings.beforeExecutionCallbacks().forEach(iAjaxBeforeExecutionCallback -> iAjaxBeforeExecutionCallback.onBeforeExecution(this, string, iRequestWebScopeWithoutResponse, iAjaxExecutor));
            iAjaxExecutor.registerExternalResources();
            iAjaxExecutor.handleRequest(iRequestWebScopeWithoutResponse, photonUnifiedResponse);
            AjaxSettings.afterExecutionCallbacks().forEach(iAjaxAfterExecutionCallback -> iAjaxAfterExecutionCallback.onAfterExecution(this, string, iRequestWebScopeWithoutResponse, iAjaxExecutor, photonUnifiedResponse));
            STATS_FUNCTION_INVOKE.increment(string);
            long l = stopWatch.stopAndGetMillis();
            STATS_FUNCTION_TIMER.addTime(string, l);
            long l2 = AjaxSettings.getLongRunningExecutionLimitTime();
            if (l2 > 0L && l > l2) {
                AjaxSettings.longRunningExecutionCallbacks().forEach(iAjaxLongRunningExecutionCallback -> iAjaxLongRunningExecutionCallback.onLongRunningExecution(this, string, iRequestWebScopeWithoutResponse, iAjaxExecutor, l));
            }
        }
        catch (Exception exception) {
            AjaxSettings.exceptionCallbacks().forEach(iAjaxExceptionCallback -> iAjaxExceptionCallback.onAjaxExecutionException(this, string, iAjaxExecutor, iRequestWebScopeWithoutResponse, exception));
            throw exception;
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

