/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.httpclient.HttpClientSettings;
import com.helger.httpclient.security.PrivateKeyStrategyFromAliasCaseInsensitive;
import com.helger.httpclient.security.TrustStrategyTrustAll;
import com.helger.pd.client.PDClientConfiguration;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import com.helger.url.protocol.EURLProtocol;
import jakarta.annotation.Nonnull;
import java.security.GeneralSecurityException;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.ssl.PrivateKeyStrategy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDHttpClientSettings
extends HttpClientSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDHttpClientSettings.class);

    public PDHttpClientSettings(@Nonnull @Nonempty String string) {
        this.resetToConfiguration(string);
    }

    public final void resetToConfiguration(@Nonnull @Nonempty String string) {
        String string2;
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TargetURI");
        boolean bl = EURLProtocol.HTTPS.isUsedInURL(string);
        String string3 = PDClientConfiguration.getHttpProxyHost();
        int n = PDClientConfiguration.getHttpProxyPort();
        if (string3 != null && n > 0) {
            string2 = new HttpHost(string3, n);
            LOGGER.info("PD client uses proxy host " + String.valueOf(string2));
            this.getGeneralProxy().setProxyHost((HttpHost)string2);
        } else {
            this.getGeneralProxy().setProxyHost(null);
        }
        string2 = PDClientConfiguration.getProxyUsername();
        if (StringHelper.isNotEmpty((String)string2)) {
            LOGGER.info("PD client uses proxy credentials");
            this.getGeneralProxy().setProxyCredentials((Credentials)new UsernamePasswordCredentials(string2, PDClientConfiguration.getProxyPassword()));
        } else {
            this.getGeneralProxy().setProxyCredentials(null);
        }
        this.setHostnameVerifier(null);
        this.setSSLContext(null);
        if (bl) {
            LoadedKeyStore loadedKeyStore;
            if (PDClientConfiguration.isHttpsHostnameVerificationDisabled()) {
                LOGGER.info("PD client uses disabled hostname verification");
                this.setHostnameVerifierVerifyAll();
            }
            if ((loadedKeyStore = PDClientConfiguration.loadKeyStore()).isFailure()) {
                LOGGER.error("PD client failed to initialize keystore for service connection - can only use http now! Details: " + LoadedKeyStore.getLoadError((LoadedKeyStore)loadedKeyStore));
            } else {
                LOGGER.info("PD client keystore successfully loaded");
                LoadedKeyStore loadedKeyStore2 = PDClientConfiguration.loadPrivateKey(loadedKeyStore.getKeyStore());
                if (loadedKeyStore2.isFailure()) {
                    LOGGER.error("PD client failed to initialize key from keystore. Details: " + LoadedKey.getLoadError(loadedKeyStore2));
                } else {
                    LOGGER.info("PD client key successfully loaded");
                }
                loadedKeyStore2 = PDClientConfiguration.loadTrustStore();
                if (loadedKeyStore2.isFailure()) {
                    LOGGER.error("PD client failed to initialize truststore for service connection. Details: " + LoadedKeyStore.getLoadError((LoadedKeyStore)loadedKeyStore2));
                } else {
                    LOGGER.info("PD client truststore successfully loaded");
                }
                try {
                    PrivateKeyStrategyFromAliasCaseInsensitive privateKeyStrategyFromAliasCaseInsensitive = new PrivateKeyStrategyFromAliasCaseInsensitive(PDClientConfiguration.getKeyStoreKeyAlias());
                    TrustStrategyTrustAll trustStrategyTrustAll = new TrustStrategyTrustAll();
                    this.setSSLContext(SSLContexts.custom().loadKeyMaterial(loadedKeyStore.getKeyStore(), PDClientConfiguration.getKeyStoreKeyPassword(), (PrivateKeyStrategy)privateKeyStrategyFromAliasCaseInsensitive).loadTrustMaterial(loadedKeyStore2.getKeyStore(), (TrustStrategy)trustStrategyTrustAll).build());
                    LOGGER.info("PD client successfully set SSL context");
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new IllegalStateException("PD client failed to set SSL context", generalSecurityException);
                }
            }
        }
        this.setConnectTimeout(PDClientConfiguration.getConnectTimeout());
        this.setResponseTimeout(PDClientConfiguration.getResponseTimeout());
    }
}

