/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.exception.InitializationException;
import com.helger.base.string.StringHelper;
import com.helger.base.system.SystemProperties;
import com.helger.config.ConfigFactory;
import com.helger.config.fallback.ConfigWithFallback;
import com.helger.config.fallback.IConfigWithFallback;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.config.source.resource.properties.ConfigurationSourceProperties;
import com.helger.config.value.IConfigurationValueProvider;
import com.helger.httpclient.HttpClientSettings;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.IResourceBase;
import com.helger.io.resourceprovider.ReadableResourceProviderChain;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PDClientConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDClientConfiguration.class);
    public static final EKeyStoreType DEFAULT_TRUSTSTORE_TYPE;
    private static final IConfigWithFallback DEFAULT_CONFIG;
    private static final SimpleReadWriteLock RW_LOCK;
    @GuardedBy(value="RW_LOCK")
    private static IConfigWithFallback s_aConfig;

    @Nonnull
    public static MultiConfigurationValueProvider createPDClientValueProvider() {
        MultiConfigurationValueProvider multiConfigurationValueProvider = ConfigFactory.createDefaultValueProvider();
        ReadableResourceProviderChain readableResourceProviderChain = ConfigFactory.createDefaultResourceProviderChain();
        int n = ConfigFactory.APPLICATION_PROPERTIES_PRIORITY;
        IReadableResource iReadableResource = readableResourceProviderChain.getReadableResourceIf("private-pd-client.properties", IResourceBase::exists);
        if (iReadableResource != null) {
            LOGGER.warn("The support for the properties file 'private-pd-client.properties' is deprecated. Place the properties in 'application.properties' instead.");
            multiConfigurationValueProvider.addConfigurationSource((IConfigurationValueProvider)new ConfigurationSourceProperties(iReadableResource, StandardCharsets.UTF_8), n - 1);
        }
        if ((iReadableResource = readableResourceProviderChain.getReadableResourceIf("pd-client.properties", IResourceBase::exists)) != null) {
            LOGGER.warn("The support for the properties file 'pd-client.properties' is deprecated. Place the properties in 'application.properties' instead.");
            multiConfigurationValueProvider.addConfigurationSource((IConfigurationValueProvider)new ConfigurationSourceProperties(iReadableResource, StandardCharsets.UTF_8), n - 2);
        }
        return multiConfigurationValueProvider;
    }

    private PDClientConfiguration() {
    }

    @Nonnull
    public static IConfigWithFallback getConfig() {
        RW_LOCK.readLock().lock();
        try {
            IConfigWithFallback iConfigWithFallback = s_aConfig;
            return iConfigWithFallback;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    @Nonnull
    public static IConfigWithFallback setConfig(@Nonnull IConfigWithFallback iConfigWithFallback) {
        IConfigWithFallback iConfigWithFallback2;
        ValueEnforcer.notNull((Object)iConfigWithFallback, (String)"NewConfig");
        RW_LOCK.writeLock().lock();
        try {
            iConfigWithFallback2 = s_aConfig;
            s_aConfig = iConfigWithFallback;
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
        if (!EqualsHelper.identityEqual((Object)iConfigWithFallback2, (Object)iConfigWithFallback)) {
            LOGGER.info("The PDClient configuration provider was changed to " + String.valueOf(iConfigWithFallback));
        }
        return iConfigWithFallback2;
    }

    public static void reloadConfiguration() {
        if (PDClientConfiguration.getConfig().reloadAllResourceBasedConfigurationValues().isSuccess()) {
            LOGGER.info("Successfully re-read the resource based configuration sources");
        } else {
            LOGGER.warn("Failed to reload at least one of the resource based configuration sources");
        }
    }

    @Nonnull
    public static EKeyStoreType getKeyStoreType() {
        String string = PDClientConfiguration.getConfig().getAsStringOrFallback("pdclient.keystore.type", new String[]{"keystore.type"});
        return EKeyStoreType.getFromIDCaseInsensitiveOrDefault((String)string, (EKeyStoreType)EKeyStoreType.JKS);
    }

    @Nullable
    public static String getKeyStorePath() {
        return PDClientConfiguration.getConfig().getAsStringOrFallback("pdclient.keystore.path", new String[]{"keystore.path"});
    }

    @Nullable
    public static char[] getKeyStorePassword() {
        return PDClientConfiguration.getConfig().getAsCharArrayOrFallback("pdclient.keystore.password", new String[]{"keystore.password"});
    }

    @Nonnull
    public static LoadedKeyStore loadKeyStore() {
        return KeyStoreHelper.loadKeyStore((IKeyStoreType)PDClientConfiguration.getKeyStoreType(), (String)PDClientConfiguration.getKeyStorePath(), (char[])PDClientConfiguration.getKeyStorePassword());
    }

    @Nullable
    public static String getKeyStoreKeyAlias() {
        return PDClientConfiguration.getConfig().getAsStringOrFallback("pdclient.keystore.key.alias", new String[]{"keystore.key.alias"});
    }

    @Nullable
    public static char[] getKeyStoreKeyPassword() {
        String string = PDClientConfiguration.getConfig().getAsStringOrFallback("pdclient.keystore.key.password", new String[]{"keystore.key.password"});
        return string == null ? null : string.toCharArray();
    }

    @Nonnull
    public static LoadedKey<KeyStore.PrivateKeyEntry> loadPrivateKey(@Nonnull KeyStore keyStore) {
        return KeyStoreHelper.loadPrivateKey((KeyStore)keyStore, (String)PDClientConfiguration.getKeyStorePath(), (String)PDClientConfiguration.getKeyStoreKeyAlias(), (char[])PDClientConfiguration.getKeyStoreKeyPassword());
    }

    @Nonnull
    public static EKeyStoreType getTrustStoreType() {
        String string = PDClientConfiguration.getConfig().getAsStringOrFallback("pdclient.truststore.type", new String[]{"truststore.type"});
        return EKeyStoreType.getFromIDCaseInsensitiveOrDefault((String)string, (EKeyStoreType)DEFAULT_TRUSTSTORE_TYPE);
    }

    @Nullable
    public static String getTrustStorePath() {
        return PDClientConfiguration.getConfig().getAsStringOrFallback("pdclient.truststore.path", new String[]{"truststore.path"});
    }

    @Nullable
    public static char[] getTrustStorePassword() {
        return PDClientConfiguration.getConfig().getAsCharArrayOrFallback("pdclient.truststore.password", new String[]{"truststore.password"});
    }

    @Nonnull
    public static LoadedKeyStore loadTrustStore() {
        return KeyStoreHelper.loadKeyStore((IKeyStoreType)PDClientConfiguration.getTrustStoreType(), (String)PDClientConfiguration.getTrustStorePath(), (char[])PDClientConfiguration.getTrustStorePassword());
    }

    @Nullable
    public static String getHttpProxyHost() {
        return PDClientConfiguration.getConfig().getAsStringOrFallback("http.proxy.host", new String[]{"http.proxyHost"});
    }

    public static int getHttpProxyPort() {
        return PDClientConfiguration.getConfig().getAsIntOrFallback("http.proxy.port", -1, 0, new String[]{"http.proxyPort"});
    }

    @Nullable
    public static String getProxyUsername() {
        return PDClientConfiguration.getConfig().getAsStringOrFallback("http.proxy.username", new String[]{"proxy.username"});
    }

    @Nullable
    public static char[] getProxyPassword() {
        String string = PDClientConfiguration.getConfig().getAsStringOrFallback("http.proxy.password", new String[]{"proxy.password"});
        return string == null ? null : string.toCharArray();
    }

    @Nonnull
    public static Timeout getConnectTimeout() {
        long l = PDClientConfiguration.getConfig().getAsLongOrFallback("http.connect.timeout.ms", -1L, -1L, new String[]{"connect.timeout.ms"});
        if (l >= 0L) {
            return Timeout.ofMilliseconds((long)l);
        }
        return HttpClientSettings.DEFAULT_CONNECT_TIMEOUT;
    }

    @Nonnull
    public static Timeout getResponseTimeout() {
        long l = PDClientConfiguration.getConfig().getAsLongOrFallback("http.response.timeout.ms", -1L, -1L, new String[]{"http.request.timeout.ms", "request.timeout.ms"});
        if (l >= 0L) {
            return Timeout.ofMilliseconds((long)l);
        }
        return HttpClientSettings.DEFAULT_RESPONSE_TIMEOUT;
    }

    public static boolean isHttpsHostnameVerificationDisabled() {
        return PDClientConfiguration.getConfig().getAsBoolean((Object)"https.hostname-verification.disabled", true);
    }

    static {
        if (StringHelper.isNotEmpty((String)SystemProperties.getPropertyValueOrNull((String)"peppol.pd.client.properties.path"))) {
            throw new InitializationException("The system property 'peppol.pd.client.properties.path' is no longer supported. See https://github.com/phax/ph-commons#ph-config for alternatives. Consider using the system property 'config.file' instead.");
        }
        if (StringHelper.isNotEmpty((String)SystemProperties.getPropertyValueOrNull((String)"pd.client.properties.path"))) {
            throw new InitializationException("The system property 'pd.client.properties.path' is no longer supported. See https://github.com/phax/ph-commons#ph-config for alternatives. Consider using the system property 'config.file' instead.");
        }
        if (StringHelper.isNotEmpty((String)System.getenv().get("DIRECTORY_CLIENT_CONFIG"))) {
            throw new InitializationException("The environment variable 'DIRECTORY_CLIENT_CONFIG' is no longer supported. See https://github.com/phax/ph-commons#ph-config for alternatives. Consider using the environment variable 'CONFIG_FILE' instead.");
        }
        DEFAULT_TRUSTSTORE_TYPE = EKeyStoreType.JKS;
        DEFAULT_CONFIG = new ConfigWithFallback((IConfigurationValueProvider)PDClientConfiguration.createPDClientValueProvider());
        RW_LOCK = new SimpleReadWriteLock();
        s_aConfig = DEFAULT_CONFIG;
    }
}

