/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.client;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ESuccess;
import com.helger.base.url.URLHelper;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.HttpClientSettings;
import com.helger.pd.client.IPDClientExceptionCallback;
import com.helger.pd.client.PDClientResponseHandler;
import com.helger.pd.client.PDHttpClientSettings;
import com.helger.peppolid.IParticipantIdentifier;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PDClient
implements Closeable {
    public static final String PATH_INDEXER_10 = "indexer/1.0/";
    private static final Logger LOGGER = LoggerFactory.getLogger(PDClient.class);
    private final String m_sPDHostURI;
    private final String m_sPDIndexerURI;
    private IPDClientExceptionCallback m_aExceptionHdl = PDClient._createDefaultExCb();
    private HttpClientManager m_aHttpClientMgr;

    @Nonnull
    private static IPDClientExceptionCallback _createDefaultExCb() {
        return (iParticipantIdentifier, string, throwable) -> LOGGER.error("Internal error in " + string + " for " + iParticipantIdentifier.getURIEncoded(), throwable);
    }

    public PDClient(@Nonnull String string) {
        this(URLHelper.getAsURI((String)string));
    }

    public PDClient(@Nonnull URI uRI) {
        ValueEnforcer.notNull((Object)uRI, (String)"PDHost");
        String string = uRI.toString();
        this.m_sPDHostURI = string.endsWith("/") ? string : string + "/";
        this.m_sPDIndexerURI = this.m_sPDHostURI + PATH_INDEXER_10;
        this.m_aHttpClientMgr = HttpClientManager.create((HttpClientSettings)new PDHttpClientSettings(this.m_sPDHostURI));
    }

    @Override
    public void close() {
        StreamHelper.close((AutoCloseable)this.m_aHttpClientMgr);
    }

    @Nonnull
    public final IPDClientExceptionCallback getExceptionHandler() {
        return this.m_aExceptionHdl;
    }

    public final void setExceptionHandler(@Nonnull IPDClientExceptionCallback iPDClientExceptionCallback) {
        ValueEnforcer.notNull((Object)iPDClientExceptionCallback, (String)"ExceptionHdl");
        this.m_aExceptionHdl = iPDClientExceptionCallback;
    }

    @Nonnull
    public final String getPDHostURI() {
        return this.m_sPDHostURI;
    }

    @Nonnull
    public final String getPDIndexerURI() {
        return this.m_sPDIndexerURI;
    }

    @Nonnull
    public final HttpClientManager getHttpClientManager() {
        return this.m_aHttpClientMgr;
    }

    public final void setHttpClientManager(@Nonnull HttpClientManager httpClientManager) {
        ValueEnforcer.notNull((Object)httpClientManager, (String)"HttpClientMgr");
        this.m_aHttpClientMgr = httpClientManager;
    }

    @Nonnull
    @OverrideOnDemand
    protected <T> T executeRequest(@Nonnull HttpUriRequest httpUriRequest, @Nonnull HttpClientResponseHandler<T> httpClientResponseHandler) throws IOException {
        return (T)this.m_aHttpClientMgr.execute(httpUriRequest, httpClientResponseHandler);
    }

    @Nonnull
    public boolean isServiceGroupRegistered(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        HttpGet httpGet = new HttpGet(this.m_sPDIndexerURI + iParticipantIdentifier.getURIPercentEncoded());
        try {
            return this.executeRequest((HttpUriRequest)httpGet, new PDClientResponseHandler()).isSuccess();
        }
        catch (Exception exception) {
            this.m_aExceptionHdl.onException(iParticipantIdentifier, "isServiceGroupRegistered", exception);
            return false;
        }
    }

    @Nonnull
    public ESuccess addServiceGroupToIndex(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        String string = iParticipantIdentifier.getURIEncoded();
        HttpPut httpPut = new HttpPut(this.m_sPDIndexerURI);
        httpPut.setEntity((HttpEntity)new StringEntity(string, StandardCharsets.UTF_8));
        try {
            if (this.executeRequest((HttpUriRequest)httpPut, new PDClientResponseHandler()).isSuccess()) {
                LOGGER.info("Added service group '" + string + "' to Peppol Directory index. May take some time until it shows up.");
                return ESuccess.SUCCESS;
            }
        }
        catch (Exception exception) {
            this.m_aExceptionHdl.onException(iParticipantIdentifier, "addServiceGroupToIndex", exception);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public ESuccess deleteServiceGroupFromIndex(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        HttpDelete httpDelete = new HttpDelete(this.m_sPDIndexerURI + iParticipantIdentifier.getURIPercentEncoded());
        try {
            if (this.executeRequest((HttpUriRequest)httpDelete, new PDClientResponseHandler()).isSuccess()) {
                String string = iParticipantIdentifier.getURIEncoded();
                LOGGER.info("Removed service group '" + string + "' from Peppol Directory index. May take some time until it is removed.");
                return ESuccess.SUCCESS;
            }
        }
        catch (Exception exception) {
            this.m_aExceptionHdl.onException(iParticipantIdentifier, "deleteServiceGroupFromIndex", exception);
        }
        return ESuccess.FAILURE;
    }
}

