/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.artefact;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.IReadableResource;
import com.helger.phive.api.IValidationType;
import com.helger.phive.api.artefact.IValidationArtefact;
import jakarta.annotation.Nonnull;

@Immutable
public class ValidationArtefact
implements IValidationArtefact {
    private final IValidationType m_aValidationArtefactType;
    private final IReadableResource m_aResource;

    public ValidationArtefact(@Nonnull IValidationType iValidationType, @Nonnull IReadableResource iReadableResource) {
        this.m_aValidationArtefactType = (IValidationType)ValueEnforcer.notNull((Object)iValidationType, (String)"ValidationArtefactType");
        this.m_aResource = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
    }

    @Override
    @Nonnull
    public IValidationType getValidationType() {
        return this.m_aValidationArtefactType;
    }

    @Override
    @Nonnull
    public IReadableResource getRuleResource() {
        return this.m_aResource;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ValidationArtefact validationArtefact = (ValidationArtefact)object;
        return this.m_aValidationArtefactType.equals(validationArtefact.m_aValidationArtefactType) && this.m_aResource.equals((Object)validationArtefact.m_aResource);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aValidationArtefactType).append((Object)this.m_aResource).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ValidationArtefactType", (Object)this.m_aValidationArtefactType).append("Resource", (Object)this.m_aResource).getToString();
    }
}

