/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.profile.peppol;

import com.helger.annotation.Nonempty;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.SingleError;
import com.helger.diagnostics.error.SingleErrorBuilder;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.crypto.ECryptoAlgorithmCrypt;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.ebms3header.Ebms3MessageProperties;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.EMEP;
import com.helger.phase4.model.EMEPBinding;
import com.helger.phase4.model.ESoapVersion;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.PModePayloadService;
import com.helger.phase4.model.pmode.PModeValidationException;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.leg.PModeLegProtocol;
import com.helger.phase4.profile.IAS4ProfileValidator;
import com.helger.phase4.wss.EWSSVersion;
import jakarta.annotation.Nonnull;
import java.util.List;

public class PeppolCompatibilityValidator
implements IAS4ProfileValidator {
    @Nonnull
    private static IError _createError(@Nonnull String string) {
        return ((SingleErrorBuilder)SingleError.builderError().errorText(string)).build();
    }

    @Nonnull
    private static IError _createWarn(@Nonnull String string) {
        return ((SingleErrorBuilder)SingleError.builderWarn().errorText(string)).build();
    }

    private static void _checkIfLegIsValid(@Nonnull ErrorList errorList, @Nonnull PModeLeg pModeLeg, @Nonnull @Nonempty String string) {
        ESoapVersion eSoapVersion;
        String string2;
        PModeLegProtocol pModeLegProtocol = pModeLeg.getProtocol();
        if (pModeLegProtocol == null) {
            errorList.add((Object)PeppolCompatibilityValidator._createError(string + "Protocol is missing"));
        } else {
            string2 = pModeLegProtocol.getAddressProtocol();
            if (!(!StringHelper.isNotEmpty((String)string2) || string2.equalsIgnoreCase("https") || string2.equalsIgnoreCase("http") && GlobalDebug.isDebugMode())) {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "AddressProtocol '" + string2 + "' is unsupported"));
            }
            if (!(eSoapVersion = pModeLegProtocol.getSoapVersion()).isAS4Default()) {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "SoapVersion '" + eSoapVersion.getVersion() + "' is unsupported"));
            }
        }
        string2 = pModeLeg.getSecurity();
        if (string2 != null) {
            if (string2.getX509SignatureAlgorithm() == null) {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "Security.X509SignatureAlgorithm is missing"));
            } else if (!string2.getX509SignatureAlgorithm().equals((Object)ECryptoAlgorithmSign.RSA_SHA_256)) {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "Security.X509SignatureAlgorithm must use the value '" + ECryptoAlgorithmSign.RSA_SHA_256.getID() + "'"));
            }
            if (string2.getX509SignatureHashFunction() == null) {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "Security.X509SignatureHashFunction is missing"));
            } else if (!string2.getX509SignatureHashFunction().equals((Object)ECryptoAlgorithmSignDigest.DIGEST_SHA_256)) {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "Security.X509SignatureHashFunction must use the value '" + ECryptoAlgorithmSignDigest.DIGEST_SHA_256.getID() + "'"));
            }
            if (string2.getX509EncryptionAlgorithm() == null) {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "Security.X509EncryptionAlgorithm is missing"));
            } else if (!string2.getX509EncryptionAlgorithm().equals((Object)ECryptoAlgorithmCrypt.AES_128_GCM)) {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "Security.X509EncryptionAlgorithm must use the value '" + ECryptoAlgorithmCrypt.AES_128_GCM.getID() + "' instead of '" + string2.getX509EncryptionAlgorithm().getID() + "'"));
            }
            if (string2.getWSSVersion() != null && !string2.getWSSVersion().equals((Object)EWSSVersion.WSS_111)) {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "Security.WSSVersion must use the value " + String.valueOf(EWSSVersion.WSS_111) + " instead of " + String.valueOf(string2.getWSSVersion())));
            }
            if (string2.isPModeAuthorizeDefined()) {
                if (string2.isPModeAuthorize()) {
                    errorList.add((Object)PeppolCompatibilityValidator._createError(string + "Security.PModeAuthorize must be set to 'false'"));
                }
            } else {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "Security.PModeAuthorize is missing"));
            }
            if (string2.isSendReceiptDefined() && string2.isSendReceipt() && string2.getSendReceiptReplyPattern() != EPModeSendReceiptReplyPattern.RESPONSE) {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "Security.SendReceiptReplyPattern must use the value " + String.valueOf(EPModeSendReceiptReplyPattern.RESPONSE) + " instead of " + String.valueOf(string2.getSendReceiptReplyPattern())));
            }
        } else {
            errorList.add((Object)PeppolCompatibilityValidator._createError(string + "Security is missing"));
        }
        if ((eSoapVersion = pModeLeg.getErrorHandling()) != null) {
            if (eSoapVersion.isReportAsResponseDefined()) {
                if (!eSoapVersion.isReportAsResponse()) {
                    errorList.add((Object)PeppolCompatibilityValidator._createError(string + "ErrorHandling.Report.AsResponse must be 'true'"));
                }
            } else {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "ErrorHandling.Report.AsResponse is missing"));
            }
            if (eSoapVersion.isReportProcessErrorNotifyConsumerDefined()) {
                if (!eSoapVersion.isReportProcessErrorNotifyConsumer()) {
                    errorList.add((Object)PeppolCompatibilityValidator._createWarn(string + "ErrorHandling.Report.ProcessErrorNotifyConsumer should be 'true'"));
                }
            } else {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "ErrorHandling.Report.ProcessErrorNotifyConsumer is missing"));
            }
            if (eSoapVersion.isReportProcessErrorNotifyProducerDefined()) {
                if (!eSoapVersion.isReportProcessErrorNotifyProducer()) {
                    errorList.add((Object)PeppolCompatibilityValidator._createWarn(string + "ErrorHandling.Report.ProcessErrorNotifyProducer should be 'true'"));
                }
            } else {
                errorList.add((Object)PeppolCompatibilityValidator._createError(string + "ErrorHandling.Report.ProcessErrorNotifyProducer is missing"));
            }
        } else {
            errorList.add((Object)PeppolCompatibilityValidator._createError(string + "ErrorHandling is missing"));
        }
    }

    public void validatePMode(@Nonnull IPMode iPMode, @Nonnull ErrorList errorList, @Nonnull IAS4ProfileValidator.EAS4ProfileValidationMode eAS4ProfileValidationMode) {
        EAS4CompressionMode eAS4CompressionMode;
        PModePayloadService pModePayloadService;
        ValueEnforcer.notNull((Object)iPMode, (String)"PMode");
        ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
        ValueEnforcer.notNull((Object)eAS4ProfileValidationMode, (String)"ValidationMode");
        ValueEnforcer.isTrue((boolean)errorList.isEmpty(), () -> "Errors in global PMode validation: " + errorList.toString());
        try {
            MetaAS4Manager.getPModeMgr().validatePMode(iPMode);
        }
        catch (PModeValidationException pModeValidationException) {
            errorList.add((Object)PeppolCompatibilityValidator._createError(pModeValidationException.getMessage()));
        }
        EMEP eMEP = iPMode.getMEP();
        EMEPBinding eMEPBinding = iPMode.getMEPBinding();
        if (eMEP != EMEP.ONE_WAY || eMEPBinding != EMEPBinding.PUSH) {
            errorList.add((Object)PeppolCompatibilityValidator._createError("An invalid combination of PMode MEP (" + String.valueOf(eMEP) + ") and MEP binding (" + String.valueOf(eMEPBinding) + ") was specified, only one-way/push is valid."));
        }
        PModeLeg pModeLeg = iPMode.getLeg1();
        if (pModeLeg == null) {
            errorList.add((Object)PeppolCompatibilityValidator._createError("PMode.Leg[1] is missing"));
        } else {
            PeppolCompatibilityValidator._checkIfLegIsValid(errorList, pModeLeg, "PMode.Leg[1].");
        }
        if (iPMode.getLeg2() != null) {
            errorList.add((Object)PeppolCompatibilityValidator._createError("PMode.Leg[2] must not be present"));
        }
        if ((pModePayloadService = iPMode.getPayloadService()) != null && (eAS4CompressionMode = pModePayloadService.getCompressionMode()) != null && !eAS4CompressionMode.equals((Object)EAS4CompressionMode.GZIP)) {
            errorList.add((Object)PeppolCompatibilityValidator._createError("PMode.PayloadService.CompressionMode must be " + String.valueOf(EAS4CompressionMode.GZIP) + " instead of " + String.valueOf(eAS4CompressionMode)));
        }
    }

    public void validateUserMessage(@Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull ErrorList errorList) {
        List list;
        Ebms3MessageProperties ebms3MessageProperties;
        ValueEnforcer.notNull((Object)ebms3UserMessage, (String)"UserMsg");
        if (ebms3UserMessage.getMessageInfo() == null) {
            errorList.add((Object)PeppolCompatibilityValidator._createError("MessageInfo is missing"));
        } else {
            if (StringHelper.isEmpty((String)ebms3UserMessage.getMessageInfo().getMessageId())) {
                errorList.add((Object)PeppolCompatibilityValidator._createError("MessageInfo/MessageId is missing"));
            }
            if ((ebms3MessageProperties = ebms3UserMessage.getMessageProperties()) == null) {
                errorList.add((Object)PeppolCompatibilityValidator._createError("MessageProperties is missing but 'originalSender' and 'finalRecipient' properties are required"));
            } else {
                list = ebms3MessageProperties.getProperty();
                if (list.isEmpty()) {
                    errorList.add((Object)PeppolCompatibilityValidator._createError("MessageProperties/Property must not be empty"));
                } else {
                    String string = null;
                    String string2 = null;
                    for (Ebms3Property ebms3Property : list) {
                        if (ebms3Property.getName().equals("originalSender")) {
                            string = ebms3Property.getValue();
                            continue;
                        }
                        if (!ebms3Property.getName().equals("finalRecipient")) continue;
                        string2 = ebms3Property.getValue();
                    }
                    if (StringHelper.isEmpty(string)) {
                        errorList.add((Object)PeppolCompatibilityValidator._createError("MessageProperties/Property 'originalSender' property is empty or not existant but mandatory"));
                    }
                    if (StringHelper.isEmpty(string2)) {
                        errorList.add((Object)PeppolCompatibilityValidator._createError("MessageProperties/Property 'finalRecipient' property is empty or not existant but mandatory"));
                    }
                }
            }
        }
        if (ebms3UserMessage.getPartyInfo() == null) {
            errorList.add((Object)PeppolCompatibilityValidator._createError("PartyInfo is missing"));
        } else {
            ebms3MessageProperties = ebms3UserMessage.getPartyInfo().getFrom();
            if (ebms3MessageProperties != null) {
                if (ebms3MessageProperties.getPartyIdCount() > 1) {
                    errorList.add((Object)PeppolCompatibilityValidator._createError("PartyInfo/From must contain no more than one PartyID"));
                } else if (ebms3MessageProperties.getPartyIdCount() == 1 && !"urn:fdc:peppol.eu:2017:identifiers:ap".equals(ebms3MessageProperties.getPartyIdAtIndex(0).getType())) {
                    errorList.add((Object)PeppolCompatibilityValidator._createError("PartyInfo/From[0]/@type must be 'urn:fdc:peppol.eu:2017:identifiers:ap' instead of '" + ebms3MessageProperties.getPartyIdAtIndex(0).getType() + "'"));
                }
            }
            if ((list = ebms3UserMessage.getPartyInfo().getTo()) != null) {
                if (list.getPartyIdCount() > 1) {
                    errorList.add((Object)PeppolCompatibilityValidator._createError("PartyInfo/To must contain no more than one PartyID"));
                } else if (list.getPartyIdCount() == 1 && !"urn:fdc:peppol.eu:2017:identifiers:ap".equals(list.getPartyIdAtIndex(0).getType())) {
                    errorList.add((Object)PeppolCompatibilityValidator._createError("PartyInfo/To[0]/@type must be 'urn:fdc:peppol.eu:2017:identifiers:ap' instead of '" + list.getPartyIdAtIndex(0).getType() + "'"));
                }
            }
        }
        if (ebms3UserMessage.getCollaborationInfo() == null) {
            errorList.add((Object)PeppolCompatibilityValidator._createError("CollaborationInfo is missing"));
        } else {
            ebms3MessageProperties = ebms3UserMessage.getCollaborationInfo().getAgreementRef();
            if (ebms3MessageProperties == null) {
                errorList.add((Object)PeppolCompatibilityValidator._createError("CollaborationInfo/AgreementRef is missing"));
            } else {
                if (!"urn:fdc:peppol.eu:2017:agreements:tia:ap_provider".equals(ebms3MessageProperties.getValue())) {
                    errorList.add((Object)PeppolCompatibilityValidator._createError("CollaborationInfo/AgreementRef must be 'urn:fdc:peppol.eu:2017:agreements:tia:ap_provider' instead of '" + ebms3MessageProperties.getValue() + "'"));
                }
                if (StringHelper.isNotEmpty((String)ebms3MessageProperties.getType())) {
                    errorList.add((Object)PeppolCompatibilityValidator._createError("CollaborationInfo/AgreementRef/@type must not be set"));
                }
            }
        }
    }

    public void validateSignalMessage(@Nonnull Ebms3SignalMessage ebms3SignalMessage, @Nonnull ErrorList errorList) {
        ValueEnforcer.notNull((Object)ebms3SignalMessage, (String)"SignalMsg");
        if (ebms3SignalMessage.getMessageInfo() == null) {
            errorList.add((Object)PeppolCompatibilityValidator._createError("MessageInfo is missing"));
        } else if (StringHelper.isEmpty((String)ebms3SignalMessage.getMessageInfo().getMessageId())) {
            errorList.add((Object)PeppolCompatibilityValidator._createError("MessageInfo/MessageId is missing"));
        }
    }
}

