/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.profile.peppol;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.url.IURLDownloader;
import com.helger.httpclient.HttpClientFactory;
import com.helger.httpclient.HttpClientSettings;
import com.helger.httpclient.HttpClientUrlDownloader;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.profile.peppol.Phase4PeppolHttpClientSettings;
import com.helger.security.crl.CRLCache;
import com.helger.security.crl.CRLDownloader;
import com.helger.security.revocation.CertificateRevocationCheckerDefaults;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;

public class PeppolCRLDownloader
extends CRLDownloader {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(PeppolCRLDownloader.class);

    public PeppolCRLDownloader() {
        this(new Phase4PeppolHttpClientSettings());
    }

    public PeppolCRLDownloader(@Nonnull HttpClientSettings httpClientSettings) {
        super((IURLDownloader)new HttpClientUrlDownloader(httpClientSettings));
    }

    public PeppolCRLDownloader(@Nonnull HttpClientFactory httpClientFactory) {
        super((IURLDownloader)new HttpClientUrlDownloader(httpClientFactory));
    }

    public static void setAsDefaultCRLCache(@Nonnull HttpClientSettings httpClientSettings) {
        ValueEnforcer.notNull((Object)httpClientSettings, (String)"HttpClientSettings");
        LOGGER.info("Installing the PeppolCRLDownloader as the default CRL cache using HttpClientSettings " + String.valueOf(httpClientSettings));
        CertificateRevocationCheckerDefaults.setDefaultCRLCache((CRLCache)new CRLCache((CRLDownloader)new PeppolCRLDownloader(httpClientSettings), CRLCache.DEFAULT_CACHING_DURATION));
    }
}

