/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.peppol.servlet;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.peppolid.factory.SimpleIdentifierFactory;
import com.helger.security.certificate.TrustedCAChecker;
import com.helger.smpclient.peppol.ISMPExtendedServiceMetadataProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.cert.X509Certificate;

@Immutable
public final class Phase4PeppolReceiverConfiguration {
    private final boolean m_bReceiverCheckEnabled;
    private final ISMPExtendedServiceMetadataProvider m_aSMPClient;
    private final String m_sAS4EndpointURL;
    private final X509Certificate m_aAPCertificate;
    private final IIdentifierFactory m_aSBDHIdentifierFactory;
    private final boolean m_bPerformSBDHValueChecks;
    private final boolean m_bCheckSBDHForMandatoryCountryC1;
    private final boolean m_bCheckSigningCertificateRevocation;
    private final TrustedCAChecker m_aAPCAChecker;

    public Phase4PeppolReceiverConfiguration(boolean bl, @Nullable ISMPExtendedServiceMetadataProvider iSMPExtendedServiceMetadataProvider, @Nullable String string, @Nullable X509Certificate x509Certificate, @Nonnull IIdentifierFactory iIdentifierFactory, boolean bl2, boolean bl3, boolean bl4, @Nonnull TrustedCAChecker trustedCAChecker) {
        if (bl) {
            ValueEnforcer.notNull((Object)iSMPExtendedServiceMetadataProvider, (String)"SMPClient");
        }
        if (bl) {
            ValueEnforcer.notEmpty((CharSequence)string, (String)"AS4EndpointURL");
        }
        if (bl) {
            ValueEnforcer.notNull((Object)x509Certificate, (String)"APCertificate");
        }
        ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"SBDHIdentifierFactory");
        this.m_bReceiverCheckEnabled = bl;
        this.m_aSMPClient = iSMPExtendedServiceMetadataProvider;
        this.m_sAS4EndpointURL = string;
        this.m_aAPCertificate = x509Certificate;
        this.m_aSBDHIdentifierFactory = iIdentifierFactory;
        this.m_bPerformSBDHValueChecks = bl2;
        this.m_bCheckSBDHForMandatoryCountryC1 = bl3;
        this.m_bCheckSigningCertificateRevocation = bl4;
        this.m_aAPCAChecker = trustedCAChecker;
    }

    public boolean isReceiverCheckEnabled() {
        return this.m_bReceiverCheckEnabled;
    }

    @Nullable
    public ISMPExtendedServiceMetadataProvider getSMPClient() {
        return this.m_aSMPClient;
    }

    @Nullable
    public String getAS4EndpointURL() {
        return this.m_sAS4EndpointURL;
    }

    @Nonnull
    public X509Certificate getAPCertificate() {
        return this.m_aAPCertificate;
    }

    @Nonnull
    public IIdentifierFactory getSBDHIdentifierFactory() {
        return this.m_aSBDHIdentifierFactory;
    }

    public boolean isPerformSBDHValueChecks() {
        return this.m_bPerformSBDHValueChecks;
    }

    public boolean isCheckSBDHForMandatoryCountryC1() {
        return this.m_bCheckSBDHForMandatoryCountryC1;
    }

    public boolean isCheckSigningCertificateRevocation() {
        return this.m_bCheckSigningCertificateRevocation;
    }

    @Nonnull
    public TrustedCAChecker getAPCAChecker() {
        return this.m_aAPCAChecker;
    }

    public String toString() {
        return new ToStringGenerator(null).append("ReceiverCheckEnabled", this.m_bReceiverCheckEnabled).append("SMPClient", (Object)this.m_aSMPClient).append("AS4EndpointURL", (Object)this.m_sAS4EndpointURL).append("APCertificate", (Object)this.m_aAPCertificate).append("SBDHIdentifierFactory", (Object)this.m_aSBDHIdentifierFactory).append("PerformSBDHValueChecks", this.m_bPerformSBDHValueChecks).append("CheckSBDHForMandatoryCountryC1", this.m_bCheckSBDHForMandatoryCountryC1).append("CheckSigningCertificateRevocation", this.m_bCheckSigningCertificateRevocation).append("APCAChecker", (Object)this.m_aAPCAChecker).getToString();
    }

    @Nonnull
    public static Phase4PeppolReceiverConfigurationBuilder builder() {
        return new Phase4PeppolReceiverConfigurationBuilder();
    }

    @Nonnull
    public static Phase4PeppolReceiverConfigurationBuilder builder(@Nonnull Phase4PeppolReceiverConfiguration phase4PeppolReceiverConfiguration) {
        return new Phase4PeppolReceiverConfigurationBuilder(phase4PeppolReceiverConfiguration);
    }

    public static class Phase4PeppolReceiverConfigurationBuilder
    implements IBuilder<Phase4PeppolReceiverConfiguration> {
        private boolean m_bReceiverCheckEnabled;
        private ISMPExtendedServiceMetadataProvider m_aSMPClient;
        private String m_sAS4EndpointURL;
        private X509Certificate m_aAPCertificate;
        private IIdentifierFactory m_aSBDHIdentifierFactory;
        private boolean m_bPerformSBDHValueChecks;
        private boolean m_bCheckSBDHForMandatoryCountryC1;
        private boolean m_bCheckSigningCertificateRevocation;
        private TrustedCAChecker m_aAPCAChecker;

        public Phase4PeppolReceiverConfigurationBuilder() {
        }

        public Phase4PeppolReceiverConfigurationBuilder(@Nonnull Phase4PeppolReceiverConfiguration phase4PeppolReceiverConfiguration) {
            ValueEnforcer.notNull((Object)phase4PeppolReceiverConfiguration, (String)"Src");
            this.receiverCheckEnabled(phase4PeppolReceiverConfiguration.isReceiverCheckEnabled()).serviceMetadataProvider(phase4PeppolReceiverConfiguration.getSMPClient()).as4EndpointUrl(phase4PeppolReceiverConfiguration.getAS4EndpointURL()).apCertificate(phase4PeppolReceiverConfiguration.getAPCertificate()).sbdhIdentifierFactory(phase4PeppolReceiverConfiguration.getSBDHIdentifierFactory()).performSBDHValueChecks(phase4PeppolReceiverConfiguration.isPerformSBDHValueChecks()).checkSBDHForMandatoryCountryC1(phase4PeppolReceiverConfiguration.isCheckSBDHForMandatoryCountryC1()).checkSigningCertificateRevocation(phase4PeppolReceiverConfiguration.isCheckSigningCertificateRevocation()).apCAChecker(phase4PeppolReceiverConfiguration.getAPCAChecker());
        }

        @Nonnull
        public Phase4PeppolReceiverConfigurationBuilder receiverCheckEnabled(boolean bl) {
            this.m_bReceiverCheckEnabled = bl;
            return this;
        }

        @Nonnull
        public Phase4PeppolReceiverConfigurationBuilder serviceMetadataProvider(@Nullable ISMPExtendedServiceMetadataProvider iSMPExtendedServiceMetadataProvider) {
            this.m_aSMPClient = iSMPExtendedServiceMetadataProvider;
            return this;
        }

        @Nonnull
        public Phase4PeppolReceiverConfigurationBuilder as4EndpointUrl(@Nullable String string) {
            this.m_sAS4EndpointURL = string;
            return this;
        }

        @Nonnull
        public Phase4PeppolReceiverConfigurationBuilder apCertificate(@Nullable X509Certificate x509Certificate) {
            this.m_aAPCertificate = x509Certificate;
            return this;
        }

        @Nonnull
        public Phase4PeppolReceiverConfigurationBuilder sbdhIdentifierFactorySimple() {
            return this.sbdhIdentifierFactory((IIdentifierFactory)SimpleIdentifierFactory.INSTANCE);
        }

        @Nonnull
        public Phase4PeppolReceiverConfigurationBuilder sbdhIdentifierFactoryPeppol() {
            return this.sbdhIdentifierFactory((IIdentifierFactory)PeppolIdentifierFactory.INSTANCE);
        }

        @Nonnull
        public Phase4PeppolReceiverConfigurationBuilder sbdhIdentifierFactory(@Nullable IIdentifierFactory iIdentifierFactory) {
            this.m_aSBDHIdentifierFactory = iIdentifierFactory;
            return this;
        }

        @Nonnull
        public Phase4PeppolReceiverConfigurationBuilder performSBDHValueChecks(boolean bl) {
            this.m_bPerformSBDHValueChecks = bl;
            return this;
        }

        @Nonnull
        public Phase4PeppolReceiverConfigurationBuilder checkSBDHForMandatoryCountryC1(boolean bl) {
            this.m_bCheckSBDHForMandatoryCountryC1 = bl;
            return this;
        }

        @Nonnull
        public Phase4PeppolReceiverConfigurationBuilder checkSigningCertificateRevocation(boolean bl) {
            this.m_bCheckSigningCertificateRevocation = bl;
            return this;
        }

        @Nonnull
        public Phase4PeppolReceiverConfigurationBuilder apCAChecker(@Nullable TrustedCAChecker trustedCAChecker) {
            this.m_aAPCAChecker = trustedCAChecker;
            return this;
        }

        @Nonnull
        public Phase4PeppolReceiverConfiguration build() {
            if (this.m_bReceiverCheckEnabled) {
                if (this.m_aSMPClient == null) {
                    throw new IllegalStateException("The SMP Client must be provided");
                }
                if (StringHelper.isEmpty((String)this.m_sAS4EndpointURL)) {
                    throw new IllegalStateException("Our AS4 Endpoint URL must be provided");
                }
                if (this.m_aAPCertificate == null) {
                    throw new IllegalStateException("Our AS4 AP certificate must be provided");
                }
            }
            if (this.m_aSBDHIdentifierFactory == null) {
                throw new IllegalStateException("The SBDH Identifier Factory must be provided");
            }
            if (this.m_aAPCAChecker == null) {
                throw new IllegalStateException("The Peppol AP CA checker must be provided");
            }
            return new Phase4PeppolReceiverConfiguration(this.m_bReceiverCheckEnabled, this.m_aSMPClient, this.m_sAS4EndpointURL, this.m_aAPCertificate, this.m_aSBDHIdentifierFactory, this.m_bPerformSBDHValueChecks, this.m_bCheckSBDHForMandatoryCountryC1, this.m_bCheckSigningCertificateRevocation, this.m_aAPCAChecker);
        }
    }
}

